/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.monster.precasia;

import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.common.registration.entity.AoAEntitySpawnPlacements;
import net.tslat.aoa3.common.registration.entity.AoAEntityStats;
import net.tslat.aoa3.common.registration.worldgen.AoABiomes;
import net.tslat.aoa3.common.registration.worldgen.AoADimensions;
import net.tslat.aoa3.content.entity.base.AoAMeleeMob;
import net.tslat.aoa3.library.object.EntityDataHolder;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.effectslib.api.util.EffectBuilder;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DefaultAnimations;

public class AttercopusEntity
extends AoAMeleeMob<AttercopusEntity> {
    public static final EntityDataHolder<Boolean> CLIMBING = EntityDataHolder.register(AttercopusEntity.class, EntityDataSerializers.BOOLEAN, false, entity -> entity.climbing, (entity, value) -> {
        entity.climbing = value;
    });
    private boolean climbing = false;

    public AttercopusEntity(EntityType<? extends AttercopusEntity> entityType, Level level) {
        super((EntityType<? extends AoAMeleeMob>)entityType, level);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        this.registerDataParams(builder, CLIMBING);
    }

    @Override
    protected int getAttackSwingDuration() {
        return 10;
    }

    @Override
    protected int getPreAttackTime() {
        return 7;
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.SPIDER_AMBIENT;
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundEvents.SPIDER_HURT;
    }

    @Override
    protected SoundEvent getDeathSound() {
        return SoundEvents.SPIDER_DEATH;
    }

    @Override
    @Nullable
    protected SoundEvent getStepSound(BlockPos pos, BlockState blockState) {
        return SoundEvents.SPIDER_STEP;
    }

    @Override
    protected PathNavigation createNavigation(Level pLevel) {
        return new WallClimberNavigation((Mob)this, pLevel);
    }

    public boolean onClimbable() {
        return CLIMBING.get((Entity)this);
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            CLIMBING.set((Entity)this, this.horizontalCollision);
        }
    }

    public void makeStuckInBlock(BlockState state, Vec3 motionModifier) {
        if (!state.is(Blocks.COBWEB)) {
            super.makeStuckInBlock(state, motionModifier);
        }
    }

    @Override
    protected DamageSource getAttackDamageSource(Entity target) {
        DamageSource damageSource;
        if (target instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)target;
            damageSource = this.damageSources().sting(livingTarget);
        } else {
            damageSource = super.getAttackDamageSource(target);
        }
        return damageSource;
    }

    public boolean canBeAffected(MobEffectInstance effect) {
        return effect.getEffect() != MobEffects.POISON && super.canBeAffected(effect);
    }

    protected int calculateFallDamage(float pFallDistance, float pDamageMultiplier) {
        return Math.max(0, super.calculateFallDamage(pFallDistance, pDamageMultiplier) - 10) / 2;
    }

    @Override
    protected void onAttack(Entity target) {
        if (target instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)target;
            EntityUtil.applyPotions((Entity)livingTarget, new EffectBuilder(MobEffects.POISON, this.level().getDifficulty().getId() * 8 * 20));
        }
    }

    public static SpawnPlacements.SpawnPredicate<Mob> spawnRules() {
        return AoAEntitySpawnPlacements.SpawnBuilder.DEFAULT_DAY_NIGHT_MONSTER.and((SpawnPlacements.SpawnPredicate<Mob>)((SpawnPlacements.SpawnPredicate)(entityType, level, spawnType, pos, rand) -> {
            if (level.getLevel().dimension() != AoADimensions.PRECASIA) {
                return true;
            }
            if (pos.getY() <= 50) {
                return spawnType != MobSpawnType.NATURAL || rand.nextFloat() < 0.05f;
            }
            return level.getBiome(pos).is(AoABiomes.PRECASIAN_DESERT) && level.getSkyDarken() >= 4 && rand.nextFloat() < 0.05f * level.getCurrentDifficultyAt(pos).getEffectiveDifficulty();
        }));
    }

    public static AoAEntityStats.AttributeBuilder entityStats(EntityType<AttercopusEntity> entityType) {
        return AoAEntityStats.AttributeBuilder.createMonster(entityType).health(29.0).moveSpeed(0.3).meleeStrength(5.5).aggroRange(16.0).followRange(32.0);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(DefaultAnimations.genericWalkIdleController((GeoAnimatable)this));
        controllers.add(DefaultAnimations.genericAttackAnimation((LivingEntity)this, (RawAnimation)DefaultAnimations.ATTACK_STRIKE));
    }
}

