/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.monster.overworld;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.damagesource.DamageContainer;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.entity.AoAEntitySpawnPlacements;
import net.tslat.aoa3.common.registration.entity.AoAEntityStats;
import net.tslat.aoa3.common.registration.entity.AoAMobEffects;
import net.tslat.aoa3.content.entity.ai.mob.TelegraphedMeleeAttackGoal;
import net.tslat.aoa3.content.entity.base.AoAMeleeMob;
import net.tslat.aoa3.library.builder.SoundBuilder;
import net.tslat.aoa3.library.constant.ScreenImageEffect;
import net.tslat.aoa3.library.object.EntityDataHolder;
import net.tslat.aoa3.util.AdvancementUtil;
import net.tslat.aoa3.util.AttributeUtil;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.effectslib.api.particle.ParticleBuilder;
import net.tslat.effectslib.api.util.EffectBuilder;
import net.tslat.effectslib.networking.packet.TELParticlePacket;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DefaultAnimations;

public class WoodGiantEntity
extends AoAMeleeMob<WoodGiantEntity> {
    public static final EntityDataHolder<Integer> STAGE = EntityDataHolder.register(WoodGiantEntity.class, EntityDataSerializers.INT, 0, WoodGiantEntity::getStage, WoodGiantEntity::setStage);
    private int lastMeleeHit = 0;
    private int stage = 0;

    public WoodGiantEntity(EntityType<? extends WoodGiantEntity> entityType, Level world) {
        super((EntityType<? extends AoAMeleeMob>)entityType, world);
    }

    @Override
    protected Brain.Provider<WoodGiantEntity> brainProvider() {
        return Brain.provider(List.of(MemoryModuleType.ATTACK_TARGET), (Collection)ImmutableList.of());
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, new TelegraphedMeleeAttackGoal<WoodGiantEntity>(this).preAttackTime(this.getPreAttackTime()).attackInterval(this.getCurrentSwingDuration()));
        this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        this.registerDataParams(builder, STAGE);
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn) {
        AttributeUtil.applyTransientModifier((LivingEntity)this, (Holder<Attribute>)Attributes.ARMOR, WoodGiantEntity.getArmourMod(this.getStage()));
        AttributeUtil.applyTransientModifier((LivingEntity)this, (Holder<Attribute>)Attributes.ARMOR_TOUGHNESS, WoodGiantEntity.getToughnessMod(this.getStage()));
        return super.finalizeSpawn(worldIn, difficultyIn, reason, spawnDataIn);
    }

    @Override
    protected SoundEvent getDeathSound() {
        return (SoundEvent)AoASounds.TREE_FALL.get();
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)AoASounds.WOODY_HIT.get();
    }

    @Override
    protected SoundEvent getStepSound(BlockPos pos, BlockState blockState) {
        return (SoundEvent)AoASounds.WOODY_THUMP.get();
    }

    public boolean isPushable() {
        return false;
    }

    @Override
    protected int getAttackSwingDuration() {
        return 11;
    }

    @Override
    protected int getPreAttackTime() {
        return 6;
    }

    public void onDamageTaken(DamageContainer damageContainer) {
        block6: {
            TELParticlePacket particlePacket;
            ServerLevel level;
            block7: {
                block9: {
                    LivingEntity attacker;
                    block8: {
                        ServerPlayer pl;
                        Level level2 = this.level();
                        if (!(level2 instanceof ServerLevel)) break block6;
                        level = (ServerLevel)level2;
                        if (!DamageUtil.isMeleeDamage(damageContainer.getSource())) break block6;
                        this.lastMeleeHit = this.tickCount;
                        Entity entity = damageContainer.getSource().getEntity();
                        if (!(entity instanceof LivingEntity)) break block6;
                        attacker = (LivingEntity)entity;
                        particlePacket = new TELParticlePacket();
                        ItemStack weapon = attacker.getItemInHand(InteractionHand.MAIN_HAND);
                        if (weapon.isCorrectToolForDrops(Blocks.OAK_LOG.defaultBlockState())) {
                            this.lastMeleeHit += 100;
                            particlePacket.particle(ParticleBuilder.forRandomPosInEntity((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.OAK_LOG.defaultBlockState()), (Entity)this).spawnNTimes(10));
                            if (this.getHealth() <= 0.0f && attacker instanceof ServerPlayer) {
                                pl = (ServerPlayer)attacker;
                                AdvancementUtil.grantCriterion(pl, AdventOfAscension.id("i_axed_you_a_question"), "tool_kill");
                            }
                        }
                        if (this.getStage() >= 3) break block7;
                        STAGE.set((Entity)this, this.getStage() + 1);
                        particlePacket.particle(ParticleBuilder.forRandomPosInEntity((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.OAK_LOG.defaultBlockState()), (Entity)this).spawnNTimes(5));
                        if (!(attacker instanceof ServerPlayer)) break block8;
                        pl = (ServerPlayer)attacker;
                        if (pl.getAbilities().invulnerable) break block9;
                    }
                    if (attacker instanceof ServerPlayer) {
                        ServerPlayer pl = (ServerPlayer)attacker;
                        new ScreenImageEffect(ScreenImageEffect.Type.BLOOD).duration(80).randomScale().coloured(255, 0, 0, 127).sendToPlayer(pl);
                    }
                    attacker.addEffect(new EffectBuilder(AoAMobEffects.BLEEDING, 600).hideParticles().build(), (Entity)this);
                }
                new SoundBuilder((SoundEvent)AoASounds.HEAVY_WOOD_SHATTER.get()).followEntity((Entity)this).isMonster().execute();
            }
            particlePacket.sendToAllNearbyPlayers(level, this.position(), 20.0);
        }
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("WoodStage")) {
            STAGE.set((Entity)this, compound.getInt("WoodStage"));
        }
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("WoodStage", STAGE.get((Entity)this).intValue());
    }

    @Override
    protected void customServerAiStep() {
        super.customServerAiStep();
        if (this.tickCount - this.lastMeleeHit > 600) {
            int stage = this.getStage();
            this.lastMeleeHit = this.tickCount;
            if (stage > 0 && stage <= 3) {
                STAGE.set((Entity)this, stage - 1);
                this.heal(20.0f);
            }
        }
    }

    private void setStage(int stage) {
        this.stage = stage;
        if (!this.level().isClientSide()) {
            int oldStage = this.getStage();
            AttributeUtil.applyTransientModifier((LivingEntity)this, (Holder<Attribute>)Attributes.ARMOR, WoodGiantEntity.getArmourMod(this.getStage()));
            AttributeUtil.applyTransientModifier((LivingEntity)this, (Holder<Attribute>)Attributes.ARMOR_TOUGHNESS, WoodGiantEntity.getToughnessMod(this.getStage()));
            if (oldStage < stage) {
                ParticleBuilder.forRandomPosInEntity((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.OAK_LOG.defaultBlockState()), (Entity)this).spawnNTimes(10).sendToAllNearbyPlayers((ServerLevel)this.level(), this.position(), 20.0);
            }
        }
    }

    public int getStage() {
        return this.stage;
    }

    private static AttributeModifier getArmourMod(int stage) {
        return new AttributeModifier(AdventOfAscension.id("wood_giant_stage"), (double)(35 - Math.max(0, stage + 1) * 10), AttributeModifier.Operation.ADD_VALUE);
    }

    private static AttributeModifier getToughnessMod(int stage) {
        return new AttributeModifier(AdventOfAscension.id("wood_giant_stage"), (double)(50 - Math.max(0, stage + 1) * 15), AttributeModifier.Operation.ADD_VALUE);
    }

    public static SpawnPlacements.SpawnPredicate<Mob> spawnRules() {
        return AoAEntitySpawnPlacements.SpawnBuilder.DEFAULT_DAY_MONSTER.spawnChance(0.06666667f);
    }

    public static AoAEntityStats.AttributeBuilder entityStats(EntityType<WoodGiantEntity> entityType) {
        return AoAEntityStats.AttributeBuilder.createMonster(entityType).health(140.0).moveSpeed(0.32).meleeStrength(11.0).knockbackResist(1.0).armour(10.0, 5.0).followRange(40.0).stepHeight(1.5);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{DefaultAnimations.genericWalkController((GeoAnimatable)this), DefaultAnimations.genericAttackAnimation((LivingEntity)this, (RawAnimation)DefaultAnimations.ATTACK_SLAM).transitionLength(0)});
    }
}

