/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.monster.overworld;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.Object2IntFunction;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.Silverfish;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.client.render.AoAAnimations;
import net.tslat.aoa3.common.registration.AoAAttributes;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.entity.AoAEntitySpawnPlacements;
import net.tslat.aoa3.common.registration.entity.AoAEntityStats;
import net.tslat.aoa3.common.registration.entity.AoAProjectiles;
import net.tslat.aoa3.content.entity.ai.mob.MultiTypeAttackGoal;
import net.tslat.aoa3.content.entity.ai.mob.TelegraphedMeleeAttackGoal;
import net.tslat.aoa3.content.entity.ai.mob.TelegraphedRangedAttackGoal;
import net.tslat.aoa3.content.entity.base.AoAMeleeMob;
import net.tslat.aoa3.content.entity.base.AoARangedAttacker;
import net.tslat.aoa3.content.entity.projectile.mob.BaseMobProjectile;
import net.tslat.aoa3.content.entity.projectile.mob.StoneGiantRockEntity;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.PositionAndMotionUtil;
import net.tslat.effectslib.api.particle.ParticleBuilder;
import net.tslat.effectslib.networking.packet.TELParticlePacket;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.constant.DefaultAnimations;

public class StoneGiantEntity
extends AoAMeleeMob<StoneGiantEntity>
implements RangedAttackMob,
AoARangedAttacker {
    public StoneGiantEntity(EntityType<? extends StoneGiantEntity> entityType, Level world) {
        super((EntityType<? extends AoAMeleeMob>)entityType, world);
    }

    @Override
    protected Brain.Provider<StoneGiantEntity> brainProvider() {
        return Brain.provider(List.of(MemoryModuleType.ATTACK_TARGET), (Collection)ImmutableList.of());
    }

    protected void registerGoals() {
        TelegraphedMeleeAttackGoal<StoneGiantEntity> meleeGoal = new TelegraphedMeleeAttackGoal<StoneGiantEntity>(this).preAttackTime(this.getPreAttackTime()).attackInterval(this.getCurrentSwingDuration()).ignoreLineOfSight();
        TelegraphedRangedAttackGoal<StoneGiantEntity> rangedGoal = new TelegraphedRangedAttackGoal<StoneGiantEntity>(this).windUpTime(32).attackFrequency(41, 50).moveSpeedMod(0.75f);
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new MultiTypeAttackGoal((Object2IntFunction<Goal>)((Object2IntFunction)currentGoal -> {
            LivingEntity target = this.getTarget();
            if (target == null) {
                return 0;
            }
            if (target.getY() > this.getEyeY()) {
                return 1;
            }
            if (this.distanceToSqr((Entity)target) > 100.0) {
                return 1;
            }
            return this.getNavigation().createPath((Entity)target, 0) == null ? 1 : 0;
        }), meleeGoal, rangedGoal).onChange(goal -> ATTACK_STATE.set((Entity)this, goal == meleeGoal ? 0 : 1)));
        this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    @Override
    protected SoundEvent getDeathSound() {
        return (SoundEvent)AoASounds.STONE_CRUMBLE.get();
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)AoASounds.ICE_HIT.get();
    }

    @Override
    protected SoundEvent getStepSound(BlockPos pos, BlockState blockState) {
        return (SoundEvent)AoASounds.ENTITY_GENERIC_HEAVY_STEP.get();
    }

    protected float getWaterSlowDown() {
        return 1.0f;
    }

    public boolean isPushable() {
        return false;
    }

    @Override
    protected int getAttackSwingDuration() {
        return ATTACK_STATE.is((Entity)this, 0) ? 13 : 41;
    }

    @Override
    protected int getPreAttackTime() {
        return ATTACK_STATE.is((Entity)this, 0) ? 7 : 32;
    }

    @Override
    public boolean hurt(DamageSource source, float amount) {
        Entity attacker = source.getEntity();
        if (attacker instanceof Silverfish) {
            if (!this.level().isClientSide()) {
                this.heal(this.level().getDifficulty().getId() * 7);
                ParticleBuilder.forPositions((ParticleOptions)ParticleTypes.HEART, (Vec3[])new Vec3[]{attacker.position()}).sendToAllNearbyPlayers((ServerLevel)this.level(), attacker.position(), 50.0);
                this.playSound(SoundEvents.SILVERFISH_AMBIENT);
                attacker.discard();
            }
            return false;
        }
        boolean success = super.hurt(source, amount);
        if (success && amount > 1.0f && !this.level().isClientSide() && !this.isNoAi()) {
            this.level().addFreshEntity((Entity)StoneGiantEntity.makeSilverfish(this, attacker));
        }
        return success;
    }

    public void performRangedAttack(LivingEntity target, float distanceFactor) {
        StoneGiantRockEntity projectile = new StoneGiantRockEntity((EntityType<? extends ThrowableProjectile>)((EntityType)AoAProjectiles.STONE_GIANT_ROCK.get()), this.level(), this, BaseMobProjectile.Type.PHYSICAL);
        projectile.setYRot(this.getYHeadRot());
        PositionAndMotionUtil.moveRelativeToFacing((Entity)projectile, -1.0, 0.0, 1.5);
        PositionAndMotionUtil.moveTowards((Entity)projectile, target.getEyePosition(), 1.6, 4 - this.level().getDifficulty().getId());
        projectile.setDeltaMovement(PositionAndMotionUtil.accountForGravity(projectile.position(), projectile.getDeltaMovement(), target.position(), projectile.getGravity()));
        PositionAndMotionUtil.faceTowardsMotion((Entity)projectile);
        this.level().addFreshEntity((Entity)projectile);
    }

    @Override
    public void doRangedAttackEntity(BaseMobProjectile projectile, Entity target) {
        DamageUtil.doProjectileAttack((Entity)this, (Entity)projectile, target, (float)this.getAttributeValue((Holder)AoAAttributes.RANGED_ATTACK_DAMAGE));
        new TELParticlePacket(new ParticleBuilder[]{ParticleBuilder.forRandomPosInEntity((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.STONE.defaultBlockState()), (Entity)projectile).spawnNTimes(3), ParticleBuilder.forRandomPosInEntity((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.DIRT.defaultBlockState()), (Entity)projectile).spawnNTimes(3)}).sendToAllNearbyPlayers((ServerLevel)this.level(), this.position(), 20.0);
        projectile.playSound((SoundEvent)AoASounds.ROCK_SMASH.get());
    }

    @Override
    public void doRangedAttackBlock(BaseMobProjectile projectile, BlockState blockHit, BlockPos pos, Direction sideHit) {
        new TELParticlePacket(new ParticleBuilder[]{ParticleBuilder.forRandomPosInEntity((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.STONE.defaultBlockState()), (Entity)projectile).spawnNTimes(3), ParticleBuilder.forRandomPosInEntity((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.DIRT.defaultBlockState()), (Entity)projectile).spawnNTimes(3)}).sendToAllNearbyPlayers((ServerLevel)this.level(), this.position(), 20.0);
        projectile.playSound((SoundEvent)AoASounds.ROCK_SMASH.get());
    }

    public void doProjectileImpactEffect(BaseMobProjectile projectile, Entity target) {
    }

    private static Silverfish makeSilverfish(final StoneGiantEntity stoneGiant, @Nullable Entity target) {
        Player pl;
        Silverfish silverfish = new Silverfish(EntityType.SILVERFISH, stoneGiant.level()){

            protected void customServerAiStep() {
                super.customServerAiStep();
                if (this.tickCount > 200 && stoneGiant != null && stoneGiant.isAlive() && stoneGiant.getHealth() < stoneGiant.getMaxHealth()) {
                    this.setTarget((LivingEntity)stoneGiant);
                }
            }

            protected boolean shouldDropLoot() {
                return false;
            }
        };
        silverfish.setPos(stoneGiant.position());
        if (!(!(target instanceof LivingEntity) || target instanceof Player && (pl = (Player)target).isCreative())) {
            silverfish.setTarget((LivingEntity)target);
        }
        return silverfish;
    }

    public static SpawnPlacements.SpawnPredicate<Mob> spawnRules() {
        return AoAEntitySpawnPlacements.SpawnBuilder.DEFAULT_DAY_MONSTER.spawnChance(0.06666667f);
    }

    public static AoAEntityStats.AttributeBuilder entityStats(EntityType<StoneGiantEntity> entityType) {
        return AoAEntityStats.AttributeBuilder.createMonster(entityType).health(150.0).moveSpeed(0.31).meleeStrength(11.5).projectileDamage(10.0).knockbackResist(1.0).armour(13.0, 12.0).followRange(40.0).stepHeight(1.5);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{DefaultAnimations.genericWalkController((GeoAnimatable)this), AoAAnimations.dynamicAttackController(this, state -> ATTACK_STATE.is((Entity)this, 0) ? DefaultAnimations.ATTACK_SLAM : DefaultAnimations.ATTACK_THROW)});
    }
}

