/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.monster.overworld;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.entity.AoAEntitySpawnPlacements;
import net.tslat.aoa3.common.registration.entity.AoAEntityStats;
import net.tslat.aoa3.content.entity.base.AoAMeleeMob;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DefaultAnimations;

public class SasquatchEntity
extends AoAMeleeMob<SasquatchEntity> {
    public SasquatchEntity(EntityType<? extends SasquatchEntity> entityType, Level world) {
        super((EntityType<? extends AoAMeleeMob>)entityType, world);
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return (SoundEvent)AoASounds.ENTITY_YETI_AMBIENT.get();
    }

    @Override
    protected SoundEvent getDeathSound() {
        return (SoundEvent)AoASounds.ENTITY_YETI_DEATH.get();
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)AoASounds.ENTITY_YETI_HURT.get();
    }

    @Override
    protected int getPreAttackTime() {
        return 6;
    }

    @Override
    protected int getAttackSwingDuration() {
        return 13;
    }

    public static SpawnPlacements.SpawnPredicate<Mob> spawnRules() {
        return AoAEntitySpawnPlacements.SpawnBuilder.DEFAULT_DAY_MONSTER.noLowerThanY(55);
    }

    public static AoAEntityStats.AttributeBuilder entityStats(EntityType<SasquatchEntity> entityType) {
        return AoAEntityStats.AttributeBuilder.createMonster(entityType).health(25.0).moveSpeed(0.2875).meleeStrength(5.0).knockbackResist(0.1).followRange(12.0).aggroRange(12.0);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{DefaultAnimations.genericWalkIdleController((GeoAnimatable)this), DefaultAnimations.genericAttackAnimation((LivingEntity)this, (RawAnimation)DefaultAnimations.ATTACK_SWING).transitionLength(0)});
    }
}

