/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.monster.overworld;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.util.RandomPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.client.render.AoAAnimations;
import net.tslat.aoa3.common.particleoption.EntityTrackingParticleOptions;
import net.tslat.aoa3.common.registration.AoAParticleTypes;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.entity.AoAEntitySpawnPlacements;
import net.tslat.aoa3.common.registration.entity.AoAEntityStats;
import net.tslat.aoa3.content.entity.ai.ExtendedGoal;
import net.tslat.aoa3.content.entity.ai.mob.ExtendedMeleeAttackGoal;
import net.tslat.aoa3.content.entity.base.AoAMeleeMob;
import net.tslat.aoa3.content.entity.misc.SandGiantPitTrapEntity;
import net.tslat.aoa3.content.entity.misc.SandGiantSpikeTrapEntity;
import net.tslat.aoa3.library.builder.EntityPredicate;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.effectslib.api.particle.ParticleBuilder;
import net.tslat.smartbrainlib.util.RandomUtil;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DefaultAnimations;

public class SandGiantEntity
extends AoAMeleeMob<SandGiantEntity> {
    public SandGiantEntity(EntityType<? extends SandGiantEntity> entityType, Level world) {
        super((EntityType<? extends AoAMeleeMob>)entityType, world);
    }

    @Override
    protected Brain.Provider<SandGiantEntity> brainProvider() {
        return Brain.provider(List.of(MemoryModuleType.ATTACK_TARGET), (Collection)ImmutableList.of());
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, new TrapChaseGoal<SandGiantEntity>(this, pos -> RandomUtil.fiftyFifty() ? new SandGiantPitTrapEntity(this.level(), (Vec3)pos) : new SandGiantSpikeTrapEntity(this.level(), (Vec3)pos)).attackEvenIfMidair().spawnExtraTrapsOnStart(20).spawnFrequency(10).maxRuntime((IntProvider)UniformInt.of((int)160, (int)240)).cooldown((IntProvider)UniformInt.of((int)300, (int)500)).chargeUpTime(15).onStart(goal -> ATTACK_STATE.set((Entity)this, 1)).onStop(goal -> ATTACK_STATE.set((Entity)this, 0)));
        this.goalSelector.addGoal(3, new ExtendedMeleeAttackGoal<SandGiantEntity>(this).attackInterval((IntProvider)ConstantInt.of((int)this.getCurrentSwingDuration())).actionTelegraphTicks(this.getPreAttackTime()).maxRuntime((IntProvider)UniformInt.of((int)500, (int)700)));
        this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    @Override
    protected SoundEvent getDeathSound() {
        return (SoundEvent)AoASounds.DENSE_SAND_POUR.get();
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)AoASounds.SANDY_HIT.get();
    }

    @Override
    protected SoundEvent getStepSound(BlockPos pos, BlockState blockState) {
        return (SoundEvent)AoASounds.SANDY_THUD.get();
    }

    public boolean isPushable() {
        return false;
    }

    @Override
    protected int getAttackSwingDuration() {
        return 11;
    }

    @Override
    protected int getPreAttackTime() {
        return 6;
    }

    @Override
    protected void customServerAiStep() {
        super.customServerAiStep();
        if (this.tickCount % 30 == 0 && ATTACK_STATE.is((Entity)this, 0) && EntityUtil.getHealthPercent((LivingEntity)this) < 0.5f) {
            this.spawnTrap();
        }
    }

    private void spawnTrap() {
        if (this.getTarget() == null) {
            return;
        }
        BlockPos.MutableBlockPos pos = this.getTarget().blockPosition().mutable();
        BlockState block = this.level().getBlockState((BlockPos)pos);
        if (block.isAir()) {
            int x = 10;
            while (x-- >= 0 && pos.getY() > this.level().getMinBuildHeight() && (block = this.level().getBlockState((BlockPos)pos.move(Direction.DOWN))).isAir()) {
            }
            if (block.isAir()) {
                return;
            }
            this.level().addFreshEntity((Entity)(RandomUtil.fiftyFifty() ? new SandGiantPitTrapEntity(this.level(), Vec3.atBottomCenterOf((Vec3i)pos.move(Direction.UP))) : new SandGiantSpikeTrapEntity(this.level(), Vec3.atBottomCenterOf((Vec3i)pos.move(Direction.UP)))));
        }
    }

    public static SpawnPlacements.SpawnPredicate<Mob> spawnRules() {
        return AoAEntitySpawnPlacements.SpawnBuilder.DEFAULT_DAY_MONSTER.spawnChance(0.06666667f);
    }

    public static AoAEntityStats.AttributeBuilder entityStats(EntityType<SandGiantEntity> entityType) {
        return AoAEntityStats.AttributeBuilder.createMonster(entityType).health(145.0).moveSpeed(0.31).meleeStrength(10.5).knockbackResist(1.0).followRange(40.0).stepHeight(1.5);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{DefaultAnimations.genericWalkController((GeoAnimatable)this), DefaultAnimations.genericAttackAnimation((LivingEntity)this, (RawAnimation)DefaultAnimations.ATTACK_SLAM).transitionLength(0), AoAAnimations.genericHeldPoseController(this, AoAAnimations.ATTACK_CHARGE, AoAAnimations.ATTACK_CHARGE_END, entity -> ATTACK_STATE.is((Entity)entity, 1))});
    }

    private static class TrapChaseGoal<T extends Mob>
    extends ExtendedGoal<T> {
        private final Function<Vec3, Entity> trapFactory;
        protected int trapSpawnFrequency = 20;
        protected int initialTrapSpawns = 0;
        protected boolean onlyIfOnGround = true;
        private int nextSpawnTime = 0;

        TrapChaseGoal(T entity, Function<Vec3, Entity> trapFactory) {
            super(entity);
            this.trapFactory = trapFactory;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public TrapChaseGoal<T> spawnFrequency(int ticks) {
            this.trapSpawnFrequency = ticks;
            return this;
        }

        public TrapChaseGoal<T> spawnExtraTrapsOnStart(int amount) {
            this.initialTrapSpawns = amount;
            return this;
        }

        public TrapChaseGoal<T> attackEvenIfMidair() {
            this.onlyIfOnGround = false;
            return this;
        }

        @Override
        public boolean canUse() {
            if (!super.canUse()) {
                return false;
            }
            if (this.entity.level().getDifficulty() == Difficulty.PEACEFUL) {
                return false;
            }
            LivingEntity target = this.entity.getTarget();
            return EntityPredicate.TARGETABLE_ENTITIES.test((Entity)target);
        }

        @Override
        public boolean canContinueToUse() {
            if (!super.canContinueToUse()) {
                return false;
            }
            return EntityPredicate.TARGETABLE_ENTITIES.test((Entity)this.entity.getTarget());
        }

        @Override
        public void start() {
            super.start();
            this.entity.getNavigation().stop();
            this.entity.setAggressive(true);
        }

        @Override
        public void stop() {
            super.stop();
            this.entity.setAggressive(false);
        }

        @Override
        public void tick() {
            block10: {
                block8: {
                    LivingEntity target;
                    block9: {
                        super.tick();
                        if (!this.hasChargedUp()) break block8;
                        target = this.entity.getTarget();
                        Vec3 center = this.entity.position();
                        ObjectArrayList positions = new ObjectArrayList(90);
                        float angle = 0.0f;
                        while ((double)angle < Math.PI * 2) {
                            positions.add(center.add((double)(Mth.cos((float)angle) * 4.0f), 0.0, (double)(Mth.sin((float)angle) * 4.0f)));
                            angle += 0.06981318f;
                        }
                        ParticleBuilder.forPositions((ParticleOptions)EntityTrackingParticleOptions.fromEntity(AoAParticleTypes.SANDSTORM, (Entity)this.entity), (Vec3[])positions.toArray(new Vec3[0])).scaleMod(0.5f).velocity(0.0, 0.25, 0.0).sendToAllPlayersTrackingEntity((ServerLevel)this.entity.level(), (Entity)this.entity);
                        if (this.entity.tickCount % 20 == 0 && (this.taskExpiresAt == Integer.MAX_VALUE || this.runningTime + 20 < this.taskExpiresAt)) {
                            this.entity.playSound((SoundEvent)AoASounds.SAND_WIND.get(), 1.0f, 0.5f);
                        }
                        if (!this.onlyIfOnGround && !target.onGround()) {
                            this.resetActionTelegraph();
                            return;
                        }
                        if (this.entity.tickCount < this.nextSpawnTime) {
                            return;
                        }
                        if (this.isTelegraphingAction()) break block9;
                        this.startTelegraphingNextAction();
                        break block10;
                    }
                    if (!this.hasActionTelegraphFinished()) break block10;
                    Entity trap = this.trapFactory.apply(target.position());
                    if (trap != null) {
                        this.entity.level().addFreshEntity(trap);
                    }
                    this.nextSpawnTime = this.entity.tickCount + this.trapSpawnFrequency;
                    this.startTelegraphingNextAction();
                    break block10;
                }
                if (this.chargeUpTime - 1 == this.runningTime) {
                    for (int i = 0; i < this.initialTrapSpawns; ++i) {
                        Entity trap;
                        BlockPos.MutableBlockPos pos = RandomPos.generateRandomDirection((RandomSource)RandomUtil.RANDOM, (int)5, (int)5).offset((Vec3i)this.entity.getTarget().blockPosition()).mutable();
                        BlockState block = this.entity.level().getBlockState((BlockPos)pos);
                        if (!block.isAir()) continue;
                        int x = 10;
                        while (x-- >= 0 && pos.getY() > this.entity.level().getMinBuildHeight() && (block = this.entity.level().getBlockState((BlockPos)pos.move(Direction.DOWN))).isAir()) {
                        }
                        if (block.isAir() || (trap = this.trapFactory.apply(Vec3.atBottomCenterOf((Vec3i)pos.move(Direction.UP)))) == null) continue;
                        this.entity.level().addFreshEntity(trap);
                    }
                }
            }
        }
    }
}

