/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.monster.overworld;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.entity.AoAEntitySpawnPlacements;
import net.tslat.aoa3.common.registration.entity.AoAEntityStats;
import net.tslat.aoa3.common.registration.entity.AoAMonsters;
import net.tslat.aoa3.content.entity.ai.mob.TelegraphedMeleeAttackGoal;
import net.tslat.aoa3.content.entity.base.AoAMeleeMob;
import net.tslat.aoa3.content.entity.monster.overworld.BushBabyEntity;
import net.tslat.aoa3.library.builder.EntityPredicate;
import net.tslat.aoa3.util.EntitySpawningUtil;
import net.tslat.effectslib.api.util.EffectBuilder;
import net.tslat.smartbrainlib.util.BrainUtils;
import net.tslat.smartbrainlib.util.EntityRetrievalUtil;
import net.tslat.smartbrainlib.util.RandomUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DefaultAnimations;

public class LeafyGiantEntity
extends AoAMeleeMob<LeafyGiantEntity> {
    private int nextBushBaby = RandomUtil.randomNumberBetween((int)150, (int)500);

    public LeafyGiantEntity(EntityType<? extends LeafyGiantEntity> entityType, Level world) {
        super((EntityType<? extends AoAMeleeMob>)entityType, world);
    }

    @Override
    protected Brain.Provider<LeafyGiantEntity> brainProvider() {
        return Brain.provider(List.of(MemoryModuleType.ATTACK_TARGET), (Collection)ImmutableList.of());
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, new TelegraphedMeleeAttackGoal<LeafyGiantEntity>(this).preAttackTime(this.getPreAttackTime()).attackInterval(this.getCurrentSwingDuration()));
        this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 12.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    @Override
    protected SoundEvent getDeathSound() {
        return (SoundEvent)AoASounds.BRANCHES_BREAKING.get();
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)AoASounds.LEAFY_THUD.get();
    }

    @Override
    @Nullable
    protected SoundEvent getStepSound(BlockPos pos, BlockState blockState) {
        return (SoundEvent)AoASounds.HEAVY_FOLIAGE_THUMP.get();
    }

    @Override
    protected float nextStep() {
        return this.moveDist + 1.5f;
    }

    public boolean isPushable() {
        return false;
    }

    @Override
    protected int getAttackSwingDuration() {
        return 11;
    }

    @Override
    protected int getPreAttackTime() {
        return 6;
    }

    @Override
    public boolean hurt(DamageSource source, float amount) {
        double preAttackHealth = this.getHealth();
        double halfHealth = (double)this.getMaxHealth() * 0.5;
        boolean success = super.hurt(source, amount);
        if (success && (double)this.getHealth() <= halfHealth && preAttackHealth > halfHealth) {
            this.setInvulnerable(true);
            LeafyGiantEntity target = this.getTarget() != null ? this.getTarget() : this;
            for (int i = 0; i < 10; ++i) {
                this.spawnBushBaby((LivingEntity)target);
            }
        }
        return success;
    }

    @Override
    protected void customServerAiStep() {
        if (this.isInvulnerable() && this.tickCount % 30 == 0) {
            List bushBabies = EntityRetrievalUtil.getEntities((Entity)this, (double)40.0, new EntityPredicate().isAlive().is((EntityType)AoAMonsters.BUSH_BABY.get()));
            if (bushBabies.isEmpty()) {
                this.setInvulnerable(false);
            } else {
                bushBabies.forEach(bushBaby -> bushBaby.addEffect(new EffectBuilder(MobEffects.GLOWING, 35).isAmbient().build()));
            }
        }
        if (this.nextBushBaby <= this.tickCount) {
            LivingEntity target = this.getTarget();
            if (target == null) {
                return;
            }
            this.nextBushBaby = this.tickCount + RandomUtil.randomNumberBetween((int)150, (int)500);
            if (EntityRetrievalUtil.getEntities((Entity)this, (double)10.0, new EntityPredicate((Entity)this).isAlive().is((EntityType)AoAMonsters.BUSH_BABY.get())).size() < 5) {
                this.spawnBushBaby(target);
            }
        }
    }

    protected void spawnBushBaby(@NotNull LivingEntity target) {
        if (this.level().isClientSide()) {
            return;
        }
        BushBabyEntity bushBaby = (BushBabyEntity)EntitySpawningUtil.spawnEntity((ServerLevel)this.level(), (EntityType)AoAMonsters.BUSH_BABY.get(), (Vec3i)BlockPos.containing((double)this.getX(), (double)this.getBoundingBox().maxY, (double)this.getZ()), MobSpawnType.MOB_SUMMONED);
        if (bushBaby == null) {
            return;
        }
        bushBaby.setDeltaMovement(Mth.clamp((double)((target.getX() - this.getX()) * (double)0.2f), (double)-0.85, (double)0.5), 0.7, Mth.clamp((double)((target.getZ() - this.getZ()) * (double)0.2f), (double)-0.85, (double)0.85));
        BrainUtils.setTargetOfEntity((LivingEntity)bushBaby, (LivingEntity)target);
        bushBaby.fallDistance = -10.0f;
        if (this.isOnFire()) {
            bushBaby.igniteForSeconds(this.getRemainingFireTicks() / 20);
        }
        if (this.getHealth() < 0.5f * this.getMaxHealth()) {
            this.setInvulnerable(true);
            bushBaby.addEffect(new EffectBuilder(MobEffects.GLOWING, 35).isAmbient().build());
        }
    }

    @Override
    protected void onAttack(Entity target) {
        if (this.isOnFire()) {
            target.igniteForSeconds((float)(this.getRemainingFireTicks() / 20));
        }
    }

    public static SpawnPlacements.SpawnPredicate<Mob> spawnRules() {
        return AoAEntitySpawnPlacements.SpawnBuilder.DEFAULT_DAY_MONSTER.spawnChance(0.06666667f);
    }

    public static AoAEntityStats.AttributeBuilder entityStats(EntityType<LeafyGiantEntity> entityType) {
        return AoAEntityStats.AttributeBuilder.createMonster(entityType).health(135.0).moveSpeed(0.32).meleeStrength(9.0).knockbackResist(1.0).followRange(40.0).stepHeight(1.5);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{DefaultAnimations.genericWalkController((GeoAnimatable)this), DefaultAnimations.genericAttackAnimation((LivingEntity)this, (RawAnimation)DefaultAnimations.ATTACK_SLAM).transitionLength(0)});
    }
}

