/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.monster.overworld;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.common.registration.AoAAttributes;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.entity.AoAEntitySpawnPlacements;
import net.tslat.aoa3.common.registration.entity.AoAEntityStats;
import net.tslat.aoa3.content.entity.ai.movehelper.UnderwaterWalkingMovementController;
import net.tslat.aoa3.content.entity.base.AoAEntityPart;
import net.tslat.aoa3.content.entity.base.AoAMeleeMob;
import net.tslat.aoa3.content.entity.brain.sensor.AggroBasedNearbyPlayersSensor;
import net.tslat.aoa3.util.AttributeUtil;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.FirstApplicableBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.OneRandomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.attack.AnimatableMeleeAttack;
import net.tslat.smartbrainlib.api.core.behaviour.custom.look.LookAtTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.WalkOrRunToWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SeekRandomNearbyPosition;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.TargetOrRetaliate;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.HurtBySensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyLivingEntitySensor;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DefaultAnimations;

public class ChomperEntity
extends AoAMeleeMob<ChomperEntity> {
    public ChomperEntity(EntityType<? extends ChomperEntity> entityType, Level world) {
        super((EntityType<? extends AoAMeleeMob>)entityType, world);
        this.moveControl = new UnderwaterWalkingMovementController((PathfinderMob)this);
        this.setParts(new AoAEntityPart<ChomperEntity>(this, this.getBbWidth(), 0.65f, 0.0f, 0.2f, this.getBbWidth()).setDamageMultiplier(1.25f), new AoAEntityPart<ChomperEntity>(this, this.getBbWidth(), 0.4375f, 0.0f, 0.225f, -this.getBbWidth()).setDamageMultiplier(0.9f), new AoAEntityPart<ChomperEntity>(this, 0.4375f, 0.3125f, 0.0f, 0.25f, -this.getBbWidth() * 1.775f).setDamageMultiplier(0.75f));
    }

    @Override
    protected void customServerAiStep() {
        super.customServerAiStep();
        if (this.tickCount % 100 == 0) {
            if (!this.level().isDay()) {
                AttributeUtil.applyTransientModifier((LivingEntity)this, AoAAttributes.AGGRO_RANGE, AoAAttributes.NIGHT_AGGRO_MODIFIER);
            } else {
                AttributeUtil.removeModifier((LivingEntity)this, AoAAttributes.AGGRO_RANGE, AoAAttributes.NIGHT_AGGRO_MODIFIER);
            }
        }
    }

    @Override
    public List<ExtendedSensor<? extends ChomperEntity>> getSensors() {
        return ObjectArrayList.of((Object[])new ExtendedSensor[]{new AggroBasedNearbyPlayersSensor(), new NearbyLivingEntitySensor().setPredicate((target, entity) -> {
            OwnableEntity tamedEntity;
            EntityDimensions entitySize = target.getDimensions(Pose.STANDING);
            if (entitySize.width() <= 0.5f && entitySize.height() <= 0.75f) {
                return true;
            }
            return target instanceof OwnableEntity && (tamedEntity = (OwnableEntity)target).getOwnerUUID() != null;
        }).setScanRate(entity -> 40), new HurtBySensor()});
    }

    @Override
    public BrainActivityGroup<ChomperEntity> getCoreTasks() {
        return BrainActivityGroup.coreTasks((Behavior[])new Behavior[]{new LookAtTarget(), new WalkOrRunToWalkTarget()});
    }

    @Override
    public BrainActivityGroup<ChomperEntity> getIdleTasks() {
        return BrainActivityGroup.idleTasks((Behavior[])new Behavior[]{new TargetOrRetaliate().useMemory(MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER).attackablePredicate(target -> DamageUtil.isAttackable(target) && !this.isAlliedTo((Entity)target)), new OneRandomBehaviour(new ExtendedBehaviour[]{new FirstApplicableBehaviour(new ExtendedBehaviour[]{new SeekRandomNearbyPosition().speedModifier(0.8f).validPositions((entity, state) -> state.getFluidState().is(FluidTags.WATER)).startCondition(entity -> entity.level().isDay() && !entity.isInWater()), new SetRandomWalkTarget().speedModifier(0.7f)}), new Idle().runFor(entity -> entity.getRandom().nextInt(30, 60))})});
    }

    @Override
    public BrainActivityGroup<ChomperEntity> getFightTasks() {
        return BrainActivityGroup.fightTasks((Behavior[])new Behavior[]{new InvalidateAttackTarget().invalidateIf((entity, target) -> !DamageUtil.isAttackable(target) || this.distanceToSqr(target.position()) > Math.pow(this.getAttributeValue(Attributes.FOLLOW_RANGE), 2.0)), new SetWalkTargetToAttackTarget().speedMod((entity, target) -> Float.valueOf(1.05f)), new AnimatableMeleeAttack(this.getPreAttackTime()).attackInterval(entity -> this.getAttackSwingDuration() + 2)});
    }

    protected float getWaterSlowDown() {
        return 1.0f;
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return EntityUtil.isEntityMoving((Entity)this) ? null : (SoundEvent)AoASounds.ENTITY_CHOMPER_AMBIENT.get();
    }

    @Override
    protected int getAttackSwingDuration() {
        return 12;
    }

    @Override
    protected int getPreAttackTime() {
        return 5;
    }

    public static SpawnPlacements.SpawnPredicate<Mob> spawnRules() {
        return AoAEntitySpawnPlacements.SpawnBuilder.DEFAULT_DAY_NIGHT_MONSTER.difficultyBasedSpawnChance(0.1f);
    }

    public static AoAEntityStats.AttributeBuilder entityStats(EntityType<ChomperEntity> entityType) {
        return AoAEntityStats.AttributeBuilder.createMonster(entityType).health(30.0).moveSpeed(0.3).meleeStrength(7.0).knockbackResist(0.3).followRange(14.0).aggroRange(8.0);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{DefaultAnimations.genericWalkRunIdleController((Entity)this), DefaultAnimations.genericAttackAnimation((LivingEntity)this, (RawAnimation)DefaultAnimations.ATTACK_BITE).transitionLength(0)});
    }
}

