/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.monster.overworld;

import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.entity.AoAEntitySpawnPlacements;
import net.tslat.aoa3.common.registration.entity.AoAEntityStats;
import net.tslat.aoa3.content.entity.base.AoARangedMob;
import net.tslat.aoa3.content.entity.projectile.mob.BaseMobProjectile;
import net.tslat.aoa3.content.entity.projectile.mob.BombCarrierDynamiteEntity;
import net.tslat.aoa3.library.builder.SoundBuilder;
import net.tslat.aoa3.util.PositionAndMotionUtil;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DefaultAnimations;

public class BombCarrierEntity
extends AoARangedMob<BombCarrierEntity> {
    public BombCarrierEntity(EntityType<? extends BombCarrierEntity> entityType, Level world) {
        super((EntityType<? extends AoARangedMob>)entityType, world);
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return (SoundEvent)AoASounds.ENTITY_GOBLIN_AMBIENT.get();
    }

    @Override
    protected SoundEvent getDeathSound() {
        return (SoundEvent)AoASounds.ENTITY_GOBLIN_DEATH.get();
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)AoASounds.ENTITY_GOBLIN_HURT.get();
    }

    @Override
    protected int getPreAttackTime() {
        return 20;
    }

    @Override
    protected int getAttackSwingDuration() {
        return 52;
    }

    @Override
    @Nullable
    protected SoundEvent getShootSound() {
        return null;
    }

    @Override
    protected BaseMobProjectile getNewProjectileInstance() {
        return null;
    }

    @Override
    public void performRangedAttack(LivingEntity target, float distanceFactor) {
        BombCarrierDynamiteEntity projectile = new BombCarrierDynamiteEntity(this.level(), this.position(), this);
        projectile.setYRot(this.getYHeadRot());
        PositionAndMotionUtil.moveRelativeToFacing((Entity)projectile, -0.2f, 0.0, 0.6f);
        PositionAndMotionUtil.moveTowards((Entity)projectile, target.getEyePosition(), 0.65, 4 - this.level().getDifficulty().getId());
        projectile.setDeltaMovement(PositionAndMotionUtil.accountForGravity(projectile.position(), projectile.getDeltaMovement(), target.position(), projectile.getGravity()));
        PositionAndMotionUtil.faceTowardsMotion((Entity)projectile);
        this.level().addFreshEntity((Entity)projectile);
    }

    public static SpawnPlacements.SpawnPredicate<Mob> spawnRules() {
        return AoAEntitySpawnPlacements.SpawnBuilder.DEFAULT_DAY_MONSTER.noLowerThanY(55).spawnChance(0.2f);
    }

    public static AoAEntityStats.AttributeBuilder entityStats(EntityType<BombCarrierEntity> entityType) {
        return AoAEntityStats.AttributeBuilder.createMonster(entityType).health(23.0).moveSpeed(0.3).projectileDamage(2.0).followRange(12.0).aggroRange(8.0);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{DefaultAnimations.genericWalkIdleController((GeoAnimatable)this), DefaultAnimations.genericAttackAnimation((LivingEntity)this, (RawAnimation)DefaultAnimations.ATTACK_THROW).transitionLength(0).setSoundKeyframeHandler(event -> new SoundBuilder((Holder<SoundEvent>)AoASounds.LIGHT_FUSE).followEntity((Entity)this).category(SoundSource.HOSTILE).execute())});
    }
}

