/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.monster.nether;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.PathType;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.fluids.FluidType;
import net.tslat.aoa3.common.networking.AoANetworking;
import net.tslat.aoa3.common.networking.packets.AoASoundBuilderPacket;
import net.tslat.aoa3.common.registration.AoAExplosions;
import net.tslat.aoa3.common.registration.AoAParticleTypes;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.entity.AoAEntitySpawnPlacements;
import net.tslat.aoa3.common.registration.entity.AoAEntityStats;
import net.tslat.aoa3.content.entity.base.AoAMeleeMob;
import net.tslat.aoa3.content.entity.brain.sensor.AggroBasedNearbyPlayersSensor;
import net.tslat.aoa3.library.builder.SoundBuilder;
import net.tslat.aoa3.library.object.explosion.StandardExplosion;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.effectslib.api.particle.ParticleBuilder;
import net.tslat.effectslib.networking.packet.TELParticlePacket;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.behaviour.custom.attack.ConditionlessAttack;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.HurtBySensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyLivingEntitySensor;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DefaultAnimations;

public class LittleBamEntity
extends AoAMeleeMob<LittleBamEntity> {
    public LittleBamEntity(EntityType<? extends LittleBamEntity> entityType, Level world) {
        super((EntityType<? extends AoAMeleeMob>)entityType, world);
        this.setPathfindingMalus(PathType.LAVA, 4.0f);
        this.setPathfindingMalus(PathType.DANGER_FIRE, 0.0f);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, 0.0f);
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return SoundEvents.PIGLIN_AMBIENT;
    }

    @Override
    @Nullable
    protected SoundEvent getDeathSound() {
        return SoundEvents.PIGLIN_DEATH;
    }

    @Override
    @Nullable
    protected SoundEvent getHurtSound(DamageSource source) {
        return SoundEvents.PIGLIN_HURT;
    }

    public float getVoicePitch() {
        return 2.0f;
    }

    @Override
    public List<ExtendedSensor<? extends LittleBamEntity>> getSensors() {
        return ObjectArrayList.of((Object[])new ExtendedSensor[]{new AggroBasedNearbyPlayersSensor().setPredicate((player, entity) -> !PiglinAi.isWearingGold((LivingEntity)player)), new NearbyLivingEntitySensor().setPredicate((target, entity) -> {
            OwnableEntity tamedEntity;
            return target instanceof OwnableEntity && (tamedEntity = (OwnableEntity)target).getOwnerUUID() != null;
        }).setScanRate(entity -> 40), new HurtBySensor()});
    }

    @Override
    public BrainActivityGroup<LittleBamEntity> getFightTasks() {
        return BrainActivityGroup.fightTasks((Behavior[])new Behavior[]{new InvalidateAttackTarget().invalidateIf((entity, target) -> !DamageUtil.isAttackable(target) || this.distanceToSqr(target.position()) > Math.pow(this.getAttributeValue(Attributes.FOLLOW_RANGE), 2.0)), new SetWalkTargetToAttackTarget(), new ConditionlessAttack(this.getAttackSwingDuration()).attack(mob -> {
            new StandardExplosion(AoAExplosions.LITTLE_BAM_OVERLOAD, (ServerLevel)this.level(), (Entity)this, this.getX(0.5), this.getY(1.0), this.getZ(0.5)).explode();
            this.discard();
        }).requiresTarget().startCondition(entity -> {
            LivingEntity target = BrainUtils.getTargetOfEntity((LivingEntity)entity);
            return target != null && entity.getSensing().hasLineOfSight((Entity)target) && entity.isWithinMeleeAttackRange(target);
        }).whenStarting(entity -> {
            this.setImmobile(true);
            TELParticlePacket packet = new TELParticlePacket();
            double targetX = this.getX(0.5);
            double targetY = this.getY(1.25);
            double targetZ = this.getZ(0.5);
            for (int i = 0; i < 10; ++i) {
                double x = this.getRandomX(0.5);
                double y = this.getRandomY();
                double z = this.getRandomZ(0.5);
                float colourMod = entity.level().random.nextFloat() * 0.7f + 0.3f;
                packet.particle(ParticleBuilder.forPosition((ParticleOptions)((ParticleOptions)AoAParticleTypes.GENERIC_DUST.get()), (double)x, (double)y, (double)z).scaleMod(0.25f).lifespan(Mth.ceil((float)(25.0f * (this.random.nextFloat() * 0.8f + 0.2f)))).colourOverride(colourMod * 124.0f / 255.0f, 0.0f, 0.0f, 1.0f).velocity((x - targetX) * 2.0, (y - targetY) * 2.0, (z - targetZ) * 2.0));
            }
            packet.sendToAllNearbyPlayers((ServerLevel)this.level(), this.position(), 64.0);
            AoANetworking.sendToAllPlayersTrackingEntity(new AoASoundBuilderPacket(new SoundBuilder((SoundEvent)AoASounds.ENTITY_LITTLE_BAM_CHARGE.get()).followEntity((Entity)this)), (Entity)this);
        })});
    }

    public boolean canSwimInFluidType(FluidType type) {
        return type == NeoForgeMod.LAVA_TYPE.value() || super.canSwimInFluidType(type);
    }

    @Override
    protected int getAttackSwingDuration() {
        return 61;
    }

    public static SpawnPlacements.SpawnPredicate<Mob> spawnRules() {
        return AoAEntitySpawnPlacements.SpawnBuilder.DEFAULT.noPeacefulSpawn().spawnChance(0.5f).noSpawnOn(Blocks.NETHER_WART_BLOCK).ifValidSpawnBlock();
    }

    public static AoAEntityStats.AttributeBuilder entityStats(EntityType<LittleBamEntity> entityType) {
        return AoAEntityStats.AttributeBuilder.createMonster(entityType).health(10.0).moveSpeed(0.32).followRange(14.0).aggroRange(8.0);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{DefaultAnimations.genericWalkIdleController((GeoAnimatable)this), DefaultAnimations.genericAttackAnimation((LivingEntity)this, (RawAnimation)DefaultAnimations.ATTACK_POWERUP).transitionLength(0)});
    }
}

