/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.monster.nether;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.entity.AoAEntitySpawnPlacements;
import net.tslat.aoa3.common.registration.entity.AoAEntityStats;
import net.tslat.aoa3.content.entity.base.AoAMeleeMob;
import net.tslat.aoa3.scheduling.AoAScheduler;
import net.tslat.effectslib.api.particle.ParticleBuilder;
import net.tslat.effectslib.networking.packet.TELParticlePacket;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.behaviour.custom.attack.AnimatableMeleeAttack;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;
import net.tslat.smartbrainlib.util.BrainUtils;
import net.tslat.smartbrainlib.util.RandomUtil;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DefaultAnimations;

public class InfernalEntity
extends AoAMeleeMob<InfernalEntity> {
    public InfernalEntity(EntityType<? extends InfernalEntity> entityType, Level world) {
        super((EntityType<? extends AoAMeleeMob>)entityType, world);
        this.setPathfindingMalus(PathType.LAVA, 4.0f);
        this.setPathfindingMalus(PathType.DANGER_FIRE, 0.0f);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, 0.0f);
        this.setPathfindingMalus(PathType.WATER_BORDER, 8.0f);
        this.setPathfindingMalus(PathType.WATER, -1.0f);
    }

    @Override
    public BrainActivityGroup<InfernalEntity> getFightTasks() {
        return BrainActivityGroup.fightTasks((Behavior[])new Behavior[]{new InvalidateAttackTarget().invalidateIf((entity, target) -> {
            Player pl;
            return target instanceof Player && ((pl = (Player)target).isCreative() || pl.isSpectator()) || this.distanceToSqr(target.position()) > Math.pow(this.getAttributeValue(Attributes.FOLLOW_RANGE), 2.0);
        }), new SetWalkTargetToAttackTarget(), new AnimatableMeleeAttack(this.getPreAttackTime()).attackInterval(entity -> this.getAttackSwingDuration() + 2).whenActivating(entity -> {
            LivingEntity target = BrainUtils.getTargetOfEntity((LivingEntity)entity);
            BlockPos pos = (target == null ? entity : target).blockPosition();
            BlockState state = this.level().getBlockState(pos);
            if (state.isAir()) {
                pos = pos.below();
                state = this.level().getBlockState(pos);
            }
            BlockPos finalPos = pos;
            ParticleBuilder.forPositions((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, state), () -> new Vec3((double)((float)finalPos.getX() + RandomUtil.randomValueUpTo((float)1.0f)), (double)((float)finalPos.getY() + 1.1f), (double)((float)finalPos.getZ() + RandomUtil.randomValueUpTo((float)1.0f))), (int)3).velocity(0.0, 0.5, 0.0).sendToAllPlayersTrackingBlock((ServerLevel)entity.level(), finalPos);
            entity.playSound((SoundEvent)AoASounds.ROCK_SMASH.get(), 1.0f, 0.2f);
            this.doSlam(finalPos, 0.75f);
        })});
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return SoundEvents.LAVA_AMBIENT;
    }

    @Override
    @Nullable
    protected SoundEvent getDeathSound() {
        return (SoundEvent)AoASounds.ENTITY_INFERNAL_HURT.get();
    }

    @Override
    @Nullable
    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)AoASounds.ENTITY_INFERNAL_HURT.get();
    }

    @Override
    protected float getStepWeight() {
        return 2.0f;
    }

    @Override
    protected float nextStep() {
        return this.moveDist + 0.6f;
    }

    @Override
    protected int getAttackSwingDuration() {
        return 22;
    }

    @Override
    protected int getPreAttackTime() {
        return 10;
    }

    private void doSlam(BlockPos fromPos, float chance) {
        TELParticlePacket packet = new TELParticlePacket();
        for (Direction dir : Direction.values()) {
            if (!RandomUtil.percentChance((float)chance)) continue;
            BlockPos pos = fromPos.offset(dir.getNormal());
            if (this.level().getBlockState(pos).getBlock() != Blocks.NETHERRACK) continue;
            int tickTime = Math.max(1, 1 - pos.distManhattan((Vec3i)fromPos));
            packet.particle(ParticleBuilder.forPosition((ParticleOptions)ParticleTypes.FLAME, (double)((float)pos.getX() + RandomUtil.randomValueUpTo((float)1.0f)), (double)((double)pos.getY() + 1.1), (double)((float)pos.getZ() + RandomUtil.randomValueUpTo((float)1.0f))));
            this.level().setBlock(pos, Blocks.MAGMA_BLOCK.defaultBlockState(), 3);
            AoAScheduler.scheduleSyncronisedTask(() -> this.doSlam(pos, chance * 0.8f), tickTime);
            AoAScheduler.scheduleSyncronisedTask(() -> {
                if (this.level().getBlockState(pos).getBlock() == Blocks.MAGMA_BLOCK) {
                    this.level().setBlock(pos, Blocks.NETHERRACK.defaultBlockState(), 3);
                }
            }, tickTime + 100);
        }
        if (!packet.isEmpty()) {
            packet.sendToAllPlayersTrackingEntity((ServerLevel)this.level(), (Entity)this);
        }
    }

    public static SpawnPlacements.SpawnPredicate<Mob> spawnRules() {
        return AoAEntitySpawnPlacements.SpawnBuilder.DEFAULT.noPeacefulSpawn().spawnChance(0.1f).noSpawnOn(Blocks.NETHER_WART_BLOCK).ifValidSpawnBlock();
    }

    public static AoAEntityStats.AttributeBuilder entityStats(EntityType<InfernalEntity> entityType) {
        return AoAEntityStats.AttributeBuilder.createMonster(entityType).health(100.0).armour(15.0, 10.0).moveSpeed(0.23).meleeStrength(14.0).aggroRange(16.0).knockbackResist(1.0).followRange(24.0);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(DefaultAnimations.genericLivingController((GeoAnimatable)this));
        controllers.add(DefaultAnimations.genericWalkIdleController((GeoAnimatable)this));
        controllers.add(DefaultAnimations.genericAttackAnimation((LivingEntity)this, (RawAnimation)DefaultAnimations.ATTACK_STRIKE).transitionLength(0));
    }
}

