/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.monster.nether;

import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.common.damagesource.DamageContainer;
import net.neoforged.neoforge.fluids.FluidType;
import net.tslat.aoa3.common.particleoption.EntityTrackingParticleOptions;
import net.tslat.aoa3.common.registration.AoAAttributes;
import net.tslat.aoa3.common.registration.AoAParticleTypes;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.entity.AoADamageTypes;
import net.tslat.aoa3.common.registration.entity.AoAEntitySpawnPlacements;
import net.tslat.aoa3.common.registration.entity.AoAEntityStats;
import net.tslat.aoa3.common.registration.entity.AoAMobEffects;
import net.tslat.aoa3.content.entity.base.AoARangedMob;
import net.tslat.aoa3.content.entity.projectile.mob.BaseMobProjectile;
import net.tslat.aoa3.scheduling.AoAScheduler;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.effectslib.api.particle.ParticleBuilder;
import net.tslat.effectslib.api.util.EffectBuilder;
import net.tslat.effectslib.networking.packet.TELParticlePacket;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.behaviour.custom.attack.AnimatableRangedAttack;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.StayWithinDistanceOfAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;
import net.tslat.smartbrainlib.util.BrainUtils;
import net.tslat.smartbrainlib.util.RandomUtil;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DefaultAnimations;

public class FlamewalkerEntity
extends AoARangedMob<FlamewalkerEntity> {
    public FlamewalkerEntity(EntityType<? extends FlamewalkerEntity> entityType, Level world) {
        super((EntityType<? extends AoARangedMob>)entityType, world);
        this.setPathfindingMalus(PathType.LAVA, 4.0f);
        this.setPathfindingMalus(PathType.DANGER_FIRE, 0.0f);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, 0.0f);
        this.setPathfindingMalus(PathType.WATER_BORDER, 8.0f);
        this.setPathfindingMalus(PathType.WATER, -1.0f);
    }

    @Override
    public BrainActivityGroup<FlamewalkerEntity> getFightTasks() {
        return BrainActivityGroup.fightTasks((Behavior[])new Behavior[]{new InvalidateAttackTarget(), new StayWithinDistanceOfAttackTarget(), new FlameWalkerAttack(this.getPreAttackTime()).attackRadius((float)this.getAttributeValue(Attributes.FOLLOW_RANGE) * 0.75f).attackInterval(FlamewalkerEntity::getAttackSwingDuration)});
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return (SoundEvent)AoASounds.ENTITY_FLAMEWALKER_AMBIENT.get();
    }

    @Override
    @Nullable
    protected SoundEvent getDeathSound() {
        return (SoundEvent)AoASounds.ENTITY_FLAMEWALKER_DEATH.get();
    }

    @Override
    @Nullable
    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)AoASounds.ENTITY_FLAMEWALKER_HURT.get();
    }

    @Override
    @Nullable
    protected SoundEvent getShootSound() {
        return null;
    }

    public boolean canSwimInFluidType(FluidType type) {
        return type == NeoForgeMod.LAVA_TYPE.value();
    }

    @Override
    protected int getAttackSwingDuration() {
        return 32;
    }

    @Override
    protected int getPreAttackTime() {
        return 16;
    }

    @Override
    public void performRangedAttack(LivingEntity target, float distanceFactor) {
    }

    @Override
    protected BaseMobProjectile getNewProjectileInstance() {
        return null;
    }

    public void onDamageTaken(DamageContainer damageContainer) {
        Entity entity;
        if (DamageUtil.isMeleeDamage(damageContainer.getSource()) && (entity = damageContainer.getSource().getEntity()) instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            attacker.igniteForSeconds(3.0f);
            if (DamageUtil.safelyDealDamage(DamageUtil.entityDamage(AoADamageTypes.MOB_FIRE_RECOIL, (Entity)this), (Entity)attacker, 3.0f) && this.rand().oneInNChance(15)) {
                EntityUtil.applyPotions((Entity)attacker, new EffectBuilder(AoAMobEffects.BURNED, 600));
            }
        }
    }

    @Override
    public void doRangedAttackEntity(@Nullable BaseMobProjectile projectile, Entity target) {
        if (target.getRemainingFireTicks() < 200) {
            target.igniteForSeconds((float)((int)Math.ceil((float)Math.max(0, target.getRemainingFireTicks()) / 20.0f) + 1));
        }
        if (DamageUtil.safelyDealDamage(DamageUtil.positionedEntityDamage(AoADamageTypes.MOB_FLAMETHROWER, (Entity)this, this.position()), target, (float)this.getAttributeValue((Holder)AoAAttributes.RANGED_ATTACK_DAMAGE)) && this.rand().oneInNChance(10)) {
            EntityUtil.applyPotions(target, new EffectBuilder(AoAMobEffects.BURNED, 600));
        }
    }

    public boolean isSensitiveToWater() {
        return true;
    }

    public static SpawnPlacements.SpawnPredicate<Mob> spawnRules() {
        return AoAEntitySpawnPlacements.SpawnBuilder.DEFAULT.noPeacefulSpawn().noSpawnOn(Blocks.NETHER_WART_BLOCK).ifValidSpawnBlock();
    }

    public static AoAEntityStats.AttributeBuilder entityStats(EntityType<FlamewalkerEntity> entityType) {
        return AoAEntityStats.AttributeBuilder.createMonster(entityType).health(45.0).moveSpeed(0.3).projectileDamage(7.0).followRange(64.0).aggroRange(16.0);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{DefaultAnimations.genericLivingController((GeoAnimatable)this), DefaultAnimations.genericWalkIdleController((GeoAnimatable)this), DefaultAnimations.genericAttackAnimation((LivingEntity)this, (RawAnimation)DefaultAnimations.ATTACK_STRIKE).transitionLength(0)});
    }

    private static class FlameWalkerAttack
    extends AnimatableRangedAttack<FlamewalkerEntity> {
        private Vec3 targetingPosition = null;

        public FlameWalkerAttack(int delayTicks) {
            super(delayTicks);
        }

        protected void start(FlamewalkerEntity entity) {
            super.start((LivingEntity)entity);
            this.targetingPosition = this.target.position().add((double)(this.target.getBbWidth() * 0.5f), 0.0, (double)(this.target.getBbWidth() * 0.5f));
            ParticleBuilder.forPositions((ParticleOptions)ParticleTypes.SMALL_FLAME, () -> new Vec3(this.targetingPosition.x + entity.rand().randomValueBetween(-1.0, 1.0), this.targetingPosition.y + (double)0.1f, this.targetingPosition.z + entity.rand().randomValueBetween(-1.0, 1.0)), (int)10).sendToAllPlayersTrackingEntity((ServerLevel)entity.level(), (Entity)entity);
            entity.level().playSound(null, this.targetingPosition.x, this.targetingPosition.y, this.targetingPosition.z, (SoundEvent)AoASounds.ENTITY_FLAMEWALKER_FLARE.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
        }

        protected void doDelayedAction(FlamewalkerEntity entity) {
            if (this.target == null) {
                return;
            }
            if (!BrainUtils.canSee((LivingEntity)entity, (LivingEntity)this.target) || entity.distanceToSqr((Entity)this.target) > (double)this.attackRadius) {
                return;
            }
            int tick = 1;
            while (tick < 12) {
                int thisTick = tick++;
                Vec3 targetPos = this.targetingPosition;
                RandomUtil.EasyRandom random = entity.rand();
                AoAScheduler.scheduleSyncronisedTask(() -> {
                    TELParticlePacket packet = new TELParticlePacket(45);
                    for (int i = 0; i < 8; ++i) {
                        if (thisTick == 1) {
                            packet.particle(ParticleBuilder.forPositions((ParticleOptions)EntityTrackingParticleOptions.fromEntity(AoAParticleTypes.BURNING_FLAME, (Entity)entity), (Vec3[])new Vec3[]{targetPos.add(random.randomScaledGaussianValue((double)0.8f), random.randomValueBetween(-0.5, 0.0), random.randomScaledGaussianValue((double)0.8f))}).scaleMod((float)random.randomValueBetween(1.0, 3.0)).lifespan(Mth.ceil((double)(5.0 / random.randomValueBetween((double)0.2f, 1.0)))).velocity(random.randomScaledGaussianValue((double)0.05f), 0.5, random.randomScaledGaussianValue((double)0.05f)));
                        }
                        packet.particle(ParticleBuilder.forPositions((ParticleOptions)ParticleTypes.SMOKE, (Vec3[])new Vec3[]{targetPos.add(random.randomScaledGaussianValue(1.0), random.randomValueBetween(-0.5, 0.0), random.randomScaledGaussianValue(1.0))}).velocity(random.randomScaledGaussianValue((double)0.05f), 0.5, random.randomScaledGaussianValue((double)0.05f)));
                        packet.particle(ParticleBuilder.forPositions((ParticleOptions)EntityTrackingParticleOptions.ambient(AoAParticleTypes.BURNING_FLAME), (Vec3[])new Vec3[]{targetPos.add(random.randomScaledGaussianValue(0.5), random.randomValueBetween(-0.5, 0.0), random.randomScaledGaussianValue(0.5))}).scaleMod((float)random.randomValueBetween(0.5, 1.5)).velocity(random.randomScaledGaussianValue((double)0.05f), 0.5, random.randomScaledGaussianValue((double)0.05f)));
                    }
                    packet.sendToAllPlayersTrackingEntity((ServerLevel)entity.level(), (Entity)entity);
                }, thisTick);
            }
            BrainUtils.setForgettableMemory((LivingEntity)entity, (MemoryModuleType)MemoryModuleType.ATTACK_COOLING_DOWN, (Object)true, (int)((Integer)this.attackIntervalSupplier.apply(entity)));
        }

        protected void stop(FlamewalkerEntity entity) {
            super.stop((LivingEntity)entity);
            this.targetingPosition = null;
        }
    }
}

