/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.monster.nether;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.common.particleoption.EntityTrackingParticleOptions;
import net.tslat.aoa3.common.registration.AoAAttributes;
import net.tslat.aoa3.common.registration.AoAParticleTypes;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.entity.AoADamageTypes;
import net.tslat.aoa3.common.registration.entity.AoAEntitySpawnPlacements;
import net.tslat.aoa3.common.registration.entity.AoAEntityStats;
import net.tslat.aoa3.content.entity.base.AoAEntityPart;
import net.tslat.aoa3.content.entity.base.AoAMeleeMob;
import net.tslat.aoa3.content.entity.base.AoARangedAttacker;
import net.tslat.aoa3.content.entity.projectile.mob.BaseMobProjectile;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.effectslib.api.particle.ParticleBuilder;
import net.tslat.effectslib.networking.packet.TELParticlePacket;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.FirstApplicableBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.attack.AnimatableMeleeAttack;
import net.tslat.smartbrainlib.api.core.behaviour.custom.attack.ConditionlessHeldAttack;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;
import net.tslat.smartbrainlib.util.BrainUtils;
import net.tslat.smartbrainlib.util.RandomUtil;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DefaultAnimations;

public class EmbrakeEntity
extends AoAMeleeMob<EmbrakeEntity>
implements AoARangedAttacker {
    private static final RawAnimation BREATH_ATTACK = RawAnimation.begin().thenPlay("attack.breath.start").thenPlay("attack.breath.hold");
    private static final RawAnimation BREATH_ATTACK_END = RawAnimation.begin().thenPlay("attack.breath.end");

    public EmbrakeEntity(EntityType<? extends EmbrakeEntity> entityType, Level world) {
        super((EntityType<? extends AoAMeleeMob>)entityType, world);
        this.setParts(new AoAEntityPart<EmbrakeEntity>(this, this.getBbWidth(), this.getBbHeight(), 0.0f, 0.0f, this.getBbWidth()).setDamageMultiplier(1.25f), new AoAEntityPart<EmbrakeEntity>(this, this.getBbWidth(), this.getBbHeight(), 0.0f, 0.0f, -this.getBbWidth()), new AoAEntityPart<EmbrakeEntity>(this, this.getBbWidth() * 0.75f, this.getBbHeight() * 0.75f, 0.0f, 0.0f, -this.getBbWidth() * 1.875f).setDamageMultiplier(0.75f));
    }

    @Override
    public BrainActivityGroup<EmbrakeEntity> getFightTasks() {
        return BrainActivityGroup.fightTasks((Behavior[])new Behavior[]{new InvalidateAttackTarget().invalidateIf((entity, target) -> !DamageUtil.isAttackable(target) || this.distanceToSqr(target.position()) > Math.pow(this.getAttributeValue(Attributes.FOLLOW_RANGE), 2.0)), new FirstApplicableBehaviour(new ExtendedBehaviour[]{new AnimatableMeleeAttack(this.getPreAttackTime()).attackInterval(entity -> this.getAttackSwingDuration() + 2), new FirstApplicableBehaviour(new ExtendedBehaviour[]{new BreathAttack(), new SetWalkTargetToAttackTarget().closeEnoughDist((entity, target) -> 4)})})});
    }

    public void performRangedAttack(LivingEntity target, float distanceFactor) {
    }

    @Override
    public void doRangedAttackEntity(@Nullable BaseMobProjectile projectile, Entity target) {
        DamageUtil.safelyDealDamage(DamageUtil.positionedEntityDamage(AoADamageTypes.MOB_FLAMETHROWER, (Entity)this, this.position()), target, (float)this.getAttributeValue((Holder)AoAAttributes.RANGED_ATTACK_DAMAGE));
        if (RandomUtil.oneInNChance((int)5) && target.getRemainingFireTicks() < 200) {
            target.igniteForSeconds((float)((int)Math.ceil((float)Math.max(0, target.getRemainingFireTicks()) / 20.0f) + 1));
        }
    }

    @Override
    public void doRangedAttackBlock(@Nullable BaseMobProjectile projectile, BlockState blockHit, BlockPos pos, Direction sideHit) {
    }

    public int getMaxHeadYRot() {
        return 30;
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return (SoundEvent)AoASounds.LARGE_LIZARD_HISS.get();
    }

    @Override
    protected SoundEvent getDeathSound() {
        return (SoundEvent)AoASounds.ENTITY_EMBRAKE_DEATH.get();
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)AoASounds.ENTITY_EMBRAKE_HURT.get();
    }

    @Override
    protected float getStepWeight() {
        return 2.0f;
    }

    @Override
    protected boolean isQuadruped() {
        return true;
    }

    @Override
    protected int getPreAttackTime() {
        return 7;
    }

    @Override
    protected int getAttackSwingDuration() {
        return 10;
    }

    public static SpawnPlacements.SpawnPredicate<Mob> spawnRules() {
        return AoAEntitySpawnPlacements.SpawnBuilder.DEFAULT.noPeacefulSpawn().spawnChance(0.5f).noSpawnOn(Blocks.NETHER_WART_BLOCK).ifValidSpawnBlock();
    }

    public static AoAEntityStats.AttributeBuilder entityStats(EntityType<EmbrakeEntity> entityType) {
        return AoAEntityStats.AttributeBuilder.createMonster(entityType).health(40.0).moveSpeed(0.25).meleeStrength(7.0).projectileDamage(2.0).knockbackResist(0.6).followRange(16.0).aggroRange(10.0);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{DefaultAnimations.genericWalkIdleController((GeoAnimatable)this), DefaultAnimations.genericAttackAnimation((LivingEntity)this, (RawAnimation)DefaultAnimations.ATTACK_BITE).transitionLength(0).triggerableAnim("breath_start", BREATH_ATTACK).triggerableAnim("breath_stop", BREATH_ATTACK_END)});
    }

    private static class BreathAttack
    extends ConditionlessHeldAttack<EmbrakeEntity> {
        public BreathAttack() {
            this.onTick(entity -> {
                if (this.getRunningTime() <= 15) {
                    return true;
                }
                Vec3 position = entity.position();
                Vec3 direction = position.add(Vec3.directionFromRotation((float)0.0f, (float)entity.yBodyRot));
                double baseX = direction.x;
                double baseY = entity.getEyeY() - (double)0.3f;
                double baseZ = direction.z;
                TELParticlePacket packet = new TELParticlePacket(11);
                packet.particle(ParticleBuilder.forPosition((ParticleOptions)ParticleTypes.SMOKE, (double)baseX, (double)baseY, (double)baseZ));
                for (int i = 0; i < 5; ++i) {
                    Vec3 velocity = this.target.position().subtract(position.x + RandomUtil.randomScaledGaussianValue((double)0.5), position.y + RandomUtil.randomScaledGaussianValue((double)0.5) - 0.3, position.z + RandomUtil.randomScaledGaussianValue((double)0.5)).normalize().scale(0.75);
                    packet.particle(ParticleBuilder.forPosition((ParticleOptions)EntityTrackingParticleOptions.fromEntity(AoAParticleTypes.BURNING_FLAME, (Entity)entity), (double)baseX, (double)baseY, (double)baseZ).scaleMod(0.3f).lifespan(Mth.ceil((float)(3.0f / (((EmbrakeEntity)entity).random.nextFloat() * 0.8f + 0.2f)))).colourOverride(0.0f, 0.0f, 0.0f, 0.0f).velocity(velocity));
                    packet.particle(ParticleBuilder.forPosition((ParticleOptions)ParticleTypes.SMALL_FLAME, (double)baseX, (double)baseY, (double)baseZ).velocity(velocity));
                }
                packet.sendToAllNearbyPlayers((ServerLevel)entity.level(), entity.getEyePosition(), 64.0);
                if (this.getRunningTime() % 9 == 0 || this.getRunningTime() % 19 == 0) {
                    entity.playSound((SoundEvent)AoASounds.FLAMETHROWER.get(), 2.0f, 1.0f);
                }
                return true;
            });
            this.requiresTarget();
            this.startCondition(entity -> {
                double aggroRange;
                LivingEntity target = (LivingEntity)BrainUtils.getMemory((LivingEntity)entity, (MemoryModuleType)MemoryModuleType.ATTACK_TARGET);
                if (target == null) {
                    return false;
                }
                double dist = target.distanceToSqr((Entity)entity);
                return dist <= (aggroRange = entity.getAttributeValue((Holder)AoAAttributes.AGGRO_RANGE)) * aggroRange && !entity.isWithinMeleeAttackRange(target) && BrainUtils.canSee((LivingEntity)entity, (LivingEntity)target);
            });
            this.stopIf(entity -> {
                double distanceCutoff;
                LivingEntity target = (LivingEntity)BrainUtils.getMemory((LivingEntity)entity, (MemoryModuleType)MemoryModuleType.ATTACK_TARGET);
                if (target == null) {
                    return true;
                }
                double dist = target.distanceToSqr((Entity)entity);
                return dist > (distanceCutoff = entity.getAttributeValue(Attributes.FOLLOW_RANGE) * 0.75) * distanceCutoff || entity.isWithinMeleeAttackRange(target) || !BrainUtils.canSee((LivingEntity)entity, (LivingEntity)target);
            });
            this.cooldownFor(entity -> 10);
            this.whenStarting(entity -> {
                entity.triggerAnim("Attack", "breath_start");
                entity.setImmobile(true);
            });
            this.whenStopping(entity -> {
                entity.triggerAnim("Attack", "breath_stop");
                entity.setImmobile(false);
            });
        }
    }
}

