/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.misc;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.Tags;
import net.tslat.aoa3.common.registration.entity.AoAMiscEntities;
import net.tslat.aoa3.content.entity.misc.HaulingFishingBobberEntity;
import net.tslat.aoa3.util.WorldUtil;
import net.tslat.smartbrainlib.util.EntityRetrievalUtil;

public class ThermalFishingBobberEntity
extends HaulingFishingBobberEntity {
    public ThermalFishingBobberEntity(ServerPlayer player, Level world, ItemStack rod) {
        super(player, world, rod);
    }

    public ThermalFishingBobberEntity(Player player, Level world, ItemStack rod, float luck, float lure) {
        super(player, world, rod, luck, lure);
    }

    public ThermalFishingBobberEntity(EntityType<? extends ThermalFishingBobberEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    public TagKey<Fluid> getApplicableFluid() {
        return FluidTags.LAVA;
    }

    @Override
    public EntityType<?> getType() {
        return (EntityType)AoAMiscEntities.THERMAL_BOBBER.get();
    }

    @Override
    protected void calculateFishingLureBonus() {
        this.fishingBonusMod = 1.0f;
        Holder biome = this.level().getBiome(this.blockPosition());
        float temperature = ((Biome)biome.value()).getTemperature(this.blockPosition());
        if (temperature > 2.0f) {
            this.fishingBonusMod *= 1.25f;
        } else if (temperature < 1.5f) {
            this.fishingBonusMod *= 0.8f;
        }
        this.fishingBonusMod = ((Biome)biome.value()).getPrecipitationAt(this.blockPosition()) == Biome.Precipitation.NONE ? (this.fishingBonusMod *= 1.1f) : (this.fishingBonusMod *= 0.9f);
        if (this.level().isRainingAt(this.blockPosition())) {
            this.fishingBonusMod *= 0.75f;
        }
        this.fishingBonusMod *= this.fishingBonusModForBiome((Holder<Biome>)biome);
        int nearbyFluidBlocks = WorldUtil.getBlocksWithinAABB(this.level(), this.getBoundingBox().inflate(2.0, 1.0, 2.0), (state, pos) -> state.getFluidState().is(this.getApplicableFluid()) && state.getFluidState().isSource()).size();
        if (nearbyFluidBlocks <= 50) {
            this.fishingBonusMod *= 0.5f;
            if (nearbyFluidBlocks < 15) {
                this.fishingBonusMod *= 0.5f;
            }
        }
        this.fishingBonusMod *= 1.0f + (float)nearbyFluidBlocks * 0.0035f;
        this.fishingBonusMod += 0.25f * this.lureReduction;
        if (!EntityRetrievalUtil.getPlayers((Level)this.level(), (AABB)this.getBoundingBox().inflate(5.0)).isEmpty()) {
            this.fishingBonusMod *= 0.2f;
        }
    }

    @Override
    protected void doBobbing(FluidState fluidState) {
        if (this.state == HaulingFishingBobberEntity.State.IN_FLUID) {
            BlockPos pos = this.blockPosition();
            float fluidHeight = fluidState.getHeight((BlockGetter)this.level(), pos);
            Vec3 vector3d = this.getDeltaMovement();
            double fluidAdjustedHeight = this.getY() + vector3d.y - (double)pos.getY() - (double)fluidHeight + 0.1;
            if (Math.abs(fluidAdjustedHeight) < 0.01) {
                fluidAdjustedHeight += Math.signum(fluidAdjustedHeight) * 0.1;
            }
            this.setDeltaMovement(vector3d.x * 0.9, vector3d.y - fluidAdjustedHeight * (double)this.random.nextFloat() * 0.05, vector3d.z * 0.9);
        }
    }

    @Override
    protected float fishingBonusModForBiome(Holder<Biome> biome) {
        for (TagKey tag : biome.tags().toList()) {
            if (tag == BiomeTags.IS_OCEAN || tag == BiomeTags.IS_RIVER || tag == Tags.Biomes.IS_SWAMP) {
                return 0.5f;
            }
            if (tag != Tags.Biomes.IS_DEAD && tag != Tags.Biomes.IS_DRY && tag != Tags.Biomes.IS_HOT) continue;
            return 1.25f;
        }
        return 1.0f;
    }
}

