/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.misc;

import com.google.common.base.Suppliers;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.common.registration.AoAParticleTypes;
import net.tslat.aoa3.common.registration.AoARegistries;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.entity.AoAEntityDataSerializers;
import net.tslat.aoa3.common.registration.entity.AoAEntitySpawnPlacements;
import net.tslat.aoa3.common.registration.entity.AoAMiscEntities;
import net.tslat.aoa3.common.registration.entity.variant.PixonVariant;
import net.tslat.aoa3.common.registration.item.AoATools;
import net.tslat.aoa3.common.toast.ItemRequirementToastData;
import net.tslat.aoa3.library.builder.SoundBuilder;
import net.tslat.aoa3.util.InventoryUtil;
import net.tslat.aoa3.util.LootUtil;
import net.tslat.aoa3.util.MathUtil;
import net.tslat.effectslib.api.particle.ParticleBuilder;
import net.tslat.effectslib.networking.packet.TELParticlePacket;
import net.tslat.smartbrainlib.util.EntityRetrievalUtil;
import org.jetbrains.annotations.Nullable;

public class PixonEntity
extends Entity {
    private static final EntityDataAccessor<PixonVariant> VARIANT = SynchedEntityData.defineId(PixonEntity.class, (EntityDataSerializer)((EntityDataSerializer)AoAEntityDataSerializers.PIXON_VARIANT.get()));
    private static final EntityDataAccessor<Float> MAGNITUDE = SynchedEntityData.defineId(PixonEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    protected PixonVariant variant = (PixonVariant)PixonVariant.AMBIENT.get();
    protected float magnitude = 1.0f;
    protected Object2IntArrayMap<UUID> itemDeficitAlertedPlayers;

    public PixonEntity(EntityType<? extends PixonEntity> pEntityType, Level level) {
        super(pEntityType, level);
    }

    public PixonEntity(Level level, PixonVariant variant) {
        this((EntityType<? extends PixonEntity>)((EntityType)AoAMiscEntities.PIXON.get()), level);
        this.setVariant(variant);
    }

    public void setMagnitude(float magnitude) {
        this.magnitude = magnitude;
    }

    public float getMagnitude() {
        return this.magnitude;
    }

    public void setVariant(PixonVariant variant) {
        this.variant = variant;
    }

    public PixonVariant getVariant() {
        return this.variant;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(MAGNITUDE, (Object)Float.valueOf(1.0f));
        builder.define(VARIANT, (Object)((PixonVariant)PixonVariant.AMBIENT.get()));
    }

    public CompoundTag saveWithoutId(CompoundTag data) {
        data = super.saveWithoutId(data);
        data.putInt("Age", this.tickCount);
        return data;
    }

    public void load(CompoundTag data) {
        super.load(data);
        if (data.contains("Age", 3)) {
            this.tickCount = data.getInt("Age");
        }
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
        if (key.equals(MAGNITUDE)) {
            this.magnitude = ((Float)this.getEntityData().get(MAGNITUDE)).floatValue();
        }
        if (key.equals(VARIANT)) {
            this.variant = (PixonVariant)this.getEntityData().get(VARIANT);
        }
    }

    public void finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, @Nullable PixonVariant variant) {
        this.getEntityData().set(VARIANT, (Object)(variant != null ? variant : PixonVariant.getVariantForSpawn(world.getLevel(), difficulty, this, (Supplier<Holder<Biome>>)Suppliers.memoize(() -> this.level().getBiome(this.blockPosition())))));
        this.getEntityData().set(MAGNITUDE, (Object)Float.valueOf(Math.max(1.0f, this.random.nextFloat() * this.random.nextFloat() * 25.0f)));
    }

    public static boolean canSurviveAt(Level level, Vec3 position) {
        BlockPos pos = BlockPos.containing((Position)position);
        return level.getBlockState(pos.below()).isSolid() && !level.getBlockState(pos).isSuffocating((BlockGetter)level, pos);
    }

    public void tick() {
        super.tick();
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            if ((float)this.tickCount >= 12000.0f + (this.magnitude - 1.0f) * 6000.0f) {
                this.discard();
                return;
            }
            if ((double)((int)this.getY()) != this.getY()) {
                this.setPos(this.getX(), (int)this.getY(), this.getZ());
            } else if (!PixonEntity.canSurviveAt((Level)level2, this.position())) {
                this.discard();
            }
            List siphoningPlayers = EntityRetrievalUtil.getPlayers((Entity)this, (double)(2.0f + this.magnitude * 0.05f), LivingEntity::isAlive);
            for (Player player : siphoningPlayers) {
                ServerPlayer pl = (ServerPlayer)player;
                if (pl.getUseItem().getItem() != AoATools.ATTUNING_BOWL.get()) {
                    this.checkForPlayerAttuningBowl(pl);
                    continue;
                }
                float scaling = Math.min(25.0f, this.magnitude);
                if (!(this.random.nextFloat() < scaling / 250.0f)) continue;
                InventoryUtil.giveItemsTo(pl, LootUtil.generateLoot(this.variant.lootTable().location(), new LootParams.Builder(level2).withParameter(LootContextParams.THIS_ENTITY, (Object)this).withParameter(LootContextParams.ORIGIN, (Object)this.position()).withParameter(LootContextParams.DAMAGE_SOURCE, (Object)level2.damageSources().playerAttack((Player)pl)).withParameter(LootContextParams.ATTACKING_ENTITY, (Object)pl).withParameter(LootContextParams.DIRECT_ATTACKING_ENTITY, (Object)pl).withParameter(LootContextParams.LAST_DAMAGE_PLAYER, (Object)pl).create(LootContextParamSets.ENTITY)));
                if (this.magnitude > 1.0f) {
                    this.getEntityData().set(MAGNITUDE, (Object)Float.valueOf(Math.max(1.0f, this.magnitude -= 0.5f)));
                }
                this.tickCount += 500;
                TELParticlePacket packet = new TELParticlePacket();
                for (int i = 0; i < 50; ++i) {
                    packet.particle(ParticleBuilder.forRandomPosInSphere((ParticleOptions)ParticleTypes.FIREWORK, (Vec3)this.position().add(0.0, (double)0.35f, 0.0), (double)0.65f).colourOverride(this.random.nextFloat() < 0.25f ? this.variant.secondaryColour() : this.variant.primaryColour()).ignoreDistanceAndLimits());
                }
                packet.sendToAllPlayersTrackingEntity(level2, (Entity)this);
            }
        } else if (this.variant != null) {
            float size = Math.min(Math.min(2.0f, this.magnitude), this.random.nextFloat() * this.random.nextFloat() * this.magnitude / 2.0f);
            ParticleBuilder.forRandomPosInEntity((ParticleOptions)((ParticleOptions)AoAParticleTypes.ORB.get()), (Entity)this).velocity(this.random.nextGaussian() * (double)0.05f * (double)(1.0f / size), (double)Math.min(1.5f, this.magnitude * 0.1f), this.random.nextGaussian() * (double)0.05f * (double)(1.0f / size)).colourOverride(this.random.nextFloat() < 0.25f ? this.variant.secondaryColour() : this.variant.primaryColour()).cutoffDistance(256.0).scaleMod(size).lifespan(100).spawnParticles(this.level());
            ParticleBuilder.forRandomPosInSphere((ParticleOptions)ParticleTypes.ASH, (Vec3)this.position(), (double)Math.min(20.0f, this.magnitude)).colourOverride((this.random.nextFloat() < 0.25f ? this.variant.secondaryColour() : this.variant.primaryColour()) | 0xFF000000).velocity(this.random.nextGaussian() * (double)0.1f * (double)(1.0f / size), (double)(this.random.nextFloat() * 0.5f + 0.25f), this.random.nextGaussian() * (double)0.1f * (double)(1.0f / size)).spawnParticles(this.level());
            for (Vec3 ringPos : MathUtil.inLateralCircle(this.position(), 0.5, this.random.nextIntBetweenInclusive(1, 12))) {
                ParticleBuilder.forPositions((ParticleOptions)((ParticleOptions)AoAParticleTypes.ORB.get()), (Vec3[])new Vec3[]{ringPos}).velocity(this.position().vectorTo(ringPos).normalize().scale((double)0.1f).add(this.random.nextGaussian() * (double)0.05f * (double)(1.0f / size), (double)Math.min(1.5f, this.magnitude * 0.05f), this.random.nextGaussian() * (double)0.05f * (double)(1.0f / size))).colourOverride(this.random.nextFloat() < 0.25f ? this.variant.secondaryColour() : this.variant.primaryColour()).scaleMod(size).lifespan(100).spawnParticles(this.level());
            }
            if (this.tickCount % 25 == 0) {
                new SoundBuilder((Holder<SoundEvent>)AoASounds.ENTITY_PIXON_AMBIENT).followEntity(this).radius(16.0f).execute();
            }
        }
    }

    private void checkForPlayerAttuningBowl(ServerPlayer pl) {
        UUID uuid = pl.getUUID();
        if (!(this.itemDeficitAlertedPlayers != null && this.itemDeficitAlertedPlayers.containsKey((Object)uuid) && pl.tickCount - this.itemDeficitAlertedPlayers.getInt((Object)uuid) <= 100 || InventoryUtil.hasItem((Player)pl, AoATools.ATTUNING_BOWL))) {
            if (this.itemDeficitAlertedPlayers == null) {
                this.itemDeficitAlertedPlayers = new Object2IntArrayMap(1);
            }
            this.itemDeficitAlertedPlayers.put((Object)uuid, pl.tickCount);
            ItemRequirementToastData.sendToastPopupTo(pl, (Item)AoATools.ATTUNING_BOWL.get());
        }
    }

    public boolean isPushable() {
        return false;
    }

    public boolean canBeCollidedWith() {
        return false;
    }

    public boolean isPickable() {
        return false;
    }

    public boolean canChangeDimensions(Level from, Level to) {
        return false;
    }

    protected void readAdditionalSaveData(CompoundTag data) {
        if (data.contains("Variant", 8)) {
            this.getEntityData().set(VARIANT, (Object)AoARegistries.PIXON_VARIANTS.getEntry(ResourceLocation.tryParse((String)data.getString("Variant"))));
        }
        if (data.contains("Magnitude")) {
            this.getEntityData().set(MAGNITUDE, (Object)Float.valueOf(data.contains("Magnitude") ? data.getFloat("Magnitude") : 1.0f));
        }
    }

    protected void addAdditionalSaveData(CompoundTag data) {
        data.putString("Variant", AoARegistries.PIXON_VARIANTS.getKey(this.variant).toString());
        data.putFloat("Magnitude", this.magnitude);
    }

    public static SpawnPlacements.SpawnPredicate<Entity> spawnRules() {
        return AoAEntitySpawnPlacements.SpawnBuilder.DEFAULT;
    }
}

