/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.misc;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.fluids.FluidType;
import net.tslat.aoa3.common.registration.entity.AoAMiscEntities;
import net.tslat.aoa3.content.item.tool.misc.HaulingRod;
import net.tslat.aoa3.content.skill.hauling.HaulingSpawnPool;
import net.tslat.aoa3.event.custom.AoAEvents;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.InventoryUtil;
import net.tslat.aoa3.util.WorldUtil;
import net.tslat.smartbrainlib.util.EntityRetrievalUtil;
import net.tslat.smartbrainlib.util.RandomUtil;
import org.jetbrains.annotations.Nullable;

public class HaulingFishingBobberEntity
extends FishingHook {
    protected static final EntityDataAccessor<Integer> STATE = SynchedEntityData.defineId(HaulingFishingBobberEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    protected final ItemStack rod;
    protected float luck;
    protected float lureReduction;
    protected float fishingBonusMod = 1.0f;
    protected int timeUntilFishSpawn = -1;
    protected Entity hookedEntity = null;
    protected Entity spawnedFish = null;
    protected long hookTime = 0L;
    protected double lastFishDist = 0.0;
    protected State state = State.MIDAIR;

    public HaulingFishingBobberEntity(EntityType<? extends HaulingFishingBobberEntity> entityType, Level level) {
        super(entityType, level);
        this.rod = null;
        this.xo = this.getX();
        this.yo = this.getY();
        this.zo = this.getZ();
        this.luck = 0.0f;
        this.lureReduction = 0.0f;
        this.getEntityData().set(DATA_HOOKED_ENTITY, (Object)-1);
    }

    public HaulingFishingBobberEntity(ServerPlayer player, Level world, ItemStack rod) {
        this((Player)player, world, rod, 0.0f, 0.0f);
        this.luck = this.calculateLuck(player, rod);
        this.lureReduction = this.calculateLureTimeReduction(player, rod);
    }

    public HaulingFishingBobberEntity(Player player, Level world, ItemStack rod, float luck, float lureReduction) {
        super(player, world, 0, 0);
        this.rod = rod;
        this.luck = luck;
        this.lureReduction = lureReduction;
        this.setOwner((Entity)player);
        float castStrength = this.getCastStrength();
        this.setDeltaMovement(this.getDeltaMovement().multiply((double)castStrength, (double)castStrength, (double)castStrength));
        this.getEntityData().set(DATA_HOOKED_ENTITY, (Object)-1);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(STATE, (Object)0);
    }

    protected float calculateLuck(ServerPlayer player, ItemStack rod) {
        float luck = player.getLuck();
        luck = rod.getItem() instanceof HaulingRod ? (luck += (float)((HaulingRod)rod.getItem()).getLuckMod(player, rod)) : (luck += (float)EnchantmentHelper.getFishingLuckBonus((ServerLevel)player.serverLevel(), (ItemStack)rod, (Entity)player));
        return luck;
    }

    protected float calculateLureTimeReduction(ServerPlayer player, ItemStack rod) {
        if (rod.getItem() instanceof HaulingRod) {
            return ((HaulingRod)rod.getItem()).getLureMod(player, rod);
        }
        return EnchantmentHelper.getFishingTimeReduction((ServerLevel)player.serverLevel(), (ItemStack)rod, (Entity)player);
    }

    protected int minLureTime() {
        return 40;
    }

    protected int maxLureTime() {
        return 700;
    }

    public State getState() {
        return this.state;
    }

    public float getLuck() {
        return this.luck;
    }

    public ItemStack getRod() {
        return this.rod;
    }

    protected void calculateFishingLureBonus() {
        this.fishingBonusMod = 1.0f;
        Holder biome = this.level().getBiome(this.blockPosition());
        float temperature = ((Biome)biome.value()).getTemperature(this.blockPosition());
        if (temperature < 0.15f) {
            this.fishingBonusMod *= 0.9f;
        } else if (temperature > 1.5f) {
            this.fishingBonusMod *= 0.8f;
        }
        if (((Biome)biome.value()).getPrecipitationAt(this.blockPosition()) == Biome.Precipitation.RAIN) {
            this.fishingBonusMod *= 1.1f;
        }
        if (this.level().isRainingAt(this.blockPosition())) {
            this.fishingBonusMod *= 1.1f;
        }
        this.fishingBonusMod *= this.fishingBonusModForBiome((Holder<Biome>)biome);
        int nearbyFluidBlocks = WorldUtil.getBlocksWithinAABB(this.level(), this.getBoundingBox().inflate(3.0, 2.0, 3.0), (state, pos) -> state.getFluidState().is(this.getApplicableFluid()) && state.getFluidState().isSource()).size();
        if (nearbyFluidBlocks <= 50) {
            this.fishingBonusMod *= 0.5f;
            if (nearbyFluidBlocks < 15) {
                this.fishingBonusMod *= 0.5f;
            }
        }
        this.fishingBonusMod *= 1.0f + (float)nearbyFluidBlocks * 0.0025f;
        this.fishingBonusMod += 0.25f * this.lureReduction / 5.0f;
        this.fishingBonusMod *= 1.0f - (float)Math.min(5, EntityRetrievalUtil.getPlayers((Level)this.level(), (AABB)this.getBoundingBox().inflate(5.0)).size()) * 0.1f;
    }

    protected float fishingBonusModForBiome(Holder<Biome> biome) {
        for (TagKey tag : biome.tags().toList()) {
            if (tag == BiomeTags.IS_OCEAN || tag == BiomeTags.IS_RIVER || tag == Tags.Biomes.IS_SWAMP) {
                return 1.25f;
            }
            if (tag != Tags.Biomes.IS_DEAD && tag != Tags.Biomes.IS_DRY && tag != Tags.Biomes.IS_HOT) continue;
            return 0.5f;
        }
        return 1.0f;
    }

    public void tick() {
        this.handleSuperTick();
        Player player = this.getPlayerOwner();
        if (!this.level().isClientSide() && !this.checkStillValid(player)) {
            this.discard();
            return;
        }
        if (this.isInLava() && this.getApplicableFluid() != FluidTags.LAVA) {
            this.discard();
            return;
        }
        if (!this.level().isClientSide()) {
            this.updateState();
        }
        if (this.hookedEntity == null) {
            this.checkIfCollided();
        }
        if (!this.level().isClientSide() && this.position().distanceToSqr(player.position()) > Math.pow(this.getMaxCastDistance() * 2.0f, 2.0)) {
            this.discard();
            return;
        }
        BlockPos pos = this.blockPosition();
        FluidState fluidState = this.level().getFluidState(pos);
        if (this.state == State.HOOKED_FISH || this.state == State.HOOKED_IN_ENTITY) {
            if (this.hookedEntity != null) {
                this.setPos(this.hookedEntity.getX(), this.hookedEntity.getY(0.8) - 0.1, this.hookedEntity.getZ());
                if (this.state == State.HOOKED_FISH) {
                    if (!this.level().isClientSide() && this.hookTime-- <= 0L) {
                        this.stopFishing();
                    } else {
                        if (EntityUtil.isEntityMoving((Entity)player)) {
                            this.hookTime -= 2L;
                        }
                        if (this.hookedEntity instanceof PathfinderMob) {
                            Vec3 targetPos;
                            PathfinderMob creature;
                            if (!this.level().isClientSide() && (creature = (PathfinderMob)this.hookedEntity).getNavigation().isDone() && (targetPos = DefaultRandomPos.getPosAway((PathfinderMob)creature, (int)30, (int)5, (Vec3)player.position())) != null) {
                                creature.getNavigation().moveTo(creature.getNavigation().createPath(BlockPos.containing((Position)targetPos), 0), 5.0);
                            }
                        } else if (this.hookedEntity.onGround()) {
                            this.stopFishing();
                        } else {
                            this.hookedEntity.setDeltaMovement(this.hookedEntity.getDeltaMovement().subtract(0.0, 0.008, 0.0));
                        }
                    }
                }
            }
            return;
        }
        if (!this.level().isClientSide()) {
            if (this.timeUntilFishSpawn >= 0) {
                if (this.timeUntilFishSpawn-- == 0) {
                    this.spawnFish((ServerPlayer)player);
                }
            } else if (this.state == State.IN_FLUID) {
                if (this.spawnedFish != null && this.spawnedFish.isAlive()) {
                    Entity targetPos = this.spawnedFish;
                    if (targetPos instanceof PathfinderMob) {
                        PathfinderMob creature = (PathfinderMob)targetPos;
                        targetPos = this.blockPosition();
                        PathNavigation navigator = creature.getNavigation();
                        float dist = (float)creature.distanceToSqr((Entity)this);
                        if (this.lastFishDist - (double)dist < 0.2 || dist <= 5.0f) {
                            EntityUtil.pullEntityIn((Entity)this, (Entity)creature, 0.025f, false);
                            if (dist <= 5.0f) {
                                navigator.stop();
                            }
                        } else if (!creature.isPathFinding() || !navigator.getTargetPos().equals((Object)targetPos)) {
                            navigator.moveTo(navigator.createPath((BlockPos)targetPos, 0), 0.5);
                        }
                        this.lastFishDist = dist;
                    }
                } else {
                    this.startFishing();
                }
            }
        }
        this.doBobbing(fluidState);
        if (this.state == State.STUCK || this.state == State.MIDAIR) {
            this.setDeltaMovement(this.getDeltaMovement().subtract(0.0, 0.03, 0.0));
        }
        if (this.state == State.IN_FLUID) {
            this.setDeltaMovement(this.getDeltaMovement().scale(0.92));
        }
        this.move(MoverType.SELF, this.getDeltaMovement());
        this.updateRotation();
        this.reapplyPosition();
    }

    protected void doBobbing(FluidState fluidState) {
        if (this.state == State.IN_FLUID) {
            BlockPos pos = this.blockPosition();
            float fluidHeight = fluidState.getHeight((BlockGetter)this.level(), pos);
            Vec3 vector3d = this.getDeltaMovement();
            double fluidAdjustedHeight = this.getY() + vector3d.y - (double)pos.getY() - (double)fluidHeight + 0.1;
            if (Math.abs(fluidAdjustedHeight) < 0.01) {
                fluidAdjustedHeight += Math.signum(fluidAdjustedHeight) * 0.1;
            }
            this.setDeltaMovement(vector3d.x * 0.9, vector3d.y - fluidAdjustedHeight * (double)this.random.nextFloat() * 0.2, vector3d.z * 0.9);
        }
    }

    public boolean save(CompoundTag tag) {
        if (this.spawnedFish != null && this.spawnedFish.isAlive()) {
            this.spawnedFish.remove(Entity.RemovalReason.DISCARDED);
        }
        return super.save(tag);
    }

    protected void updateState() {
        FluidState fluidState;
        State fromState = this.getState();
        if (this.onGround() || this.horizontalCollision) {
            this.state = State.STUCK;
        } else if (this.state == State.STUCK) {
            this.state = State.MIDAIR;
        }
        if (this.hookedEntity != null && this.hookedEntity.isAlive()) {
            this.state = this.hookedEntity == this.spawnedFish ? State.HOOKED_FISH : State.HOOKED_IN_ENTITY;
        } else if (this.state == State.HOOKED_FISH || this.state == State.HOOKED_IN_ENTITY) {
            this.state = State.MIDAIR;
        }
        if (this.state == State.IN_FLUID && this.spawnedFish != null && this.spawnedFish.distanceToSqr((Entity)this) < 0.25) {
            this.state = State.HOOKED_FISH;
        }
        if ((fluidState = this.level().getFluidState(this.blockPosition())).is(this.getApplicableFluid())) {
            if (this.state == State.MIDAIR) {
                this.state = State.IN_FLUID;
            }
        } else if (this.state == State.IN_FLUID) {
            this.state = State.MIDAIR;
        }
        if (this.getState() != fromState) {
            this.onStateChange(fromState, this.getState());
        }
    }

    protected void onStateChange(State fromState, State toState) {
        if (fromState == State.IN_FLUID) {
            if (this.hookedEntity == null && this.spawnedFish == null) {
                this.stopFishing();
            } else if (toState == State.HOOKED_FISH) {
                this.hookedEntity = this.spawnedFish;
                this.hookTime = 1200L;
            }
        }
        if (toState == State.HOOKED_IN_ENTITY || toState == State.HOOKED_FISH || toState == State.STUCK) {
            this.setDeltaMovement(Vec3.ZERO);
            if (toState == State.STUCK) {
                this.stopFishing();
            } else {
                this.updateHookedEntity();
            }
        } else if (toState == State.IN_FLUID) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(0.3, 0.2, 0.3));
            this.startFishing();
        }
        if (fromState == State.IN_FLUID && this.hookedEntity == null && this.spawnedFish == null) {
            this.stopFishing();
        }
        if (fromState == State.HOOKED_FISH || fromState == State.HOOKED_IN_ENTITY) {
            this.updateHookedEntity();
        }
        this.getEntityData().set(STATE, (Object)this.state.value());
    }

    protected void startFishing() {
        this.stopFishing();
        this.calculateFishingLureBonus();
        int minTime = this.minLureTime();
        int maxTime = this.maxLureTime();
        if (this.fishingBonusMod < 0.9f) {
            minTime = (int)((float)minTime / (this.fishingBonusMod / 2.0f));
            maxTime = (int)((float)maxTime / (this.fishingBonusMod / 3.0f));
        } else {
            maxTime = (int)((float)maxTime / this.fishingBonusMod);
        }
        if (minTime < 1) {
            minTime = 1;
        }
        if (maxTime < 1) {
            maxTime = 1;
        }
        this.timeUntilFishSpawn = RandomUtil.randomNumberBetween((int)minTime, (int)Math.max(minTime + 50, maxTime));
    }

    protected void stopFishing() {
        this.timeUntilFishSpawn = -1;
        this.hookTime = 0L;
        this.lastFishDist = 0.0;
        if (this.hookedEntity != null) {
            if (this.hookedEntity == this.spawnedFish) {
                this.hookedEntity.discard();
            }
            this.hookedEntity = null;
        }
        if (this.spawnedFish != null) {
            this.spawnedFish.discard();
            this.spawnedFish = null;
        }
        if (!this.isRemoved()) {
            this.updateHookedEntity();
        }
    }

    protected void spawnFish(ServerPlayer player) {
        boolean isLava = Fluids.LAVA.is(this.getApplicableFluid());
        Optional<HaulingSpawnPool> pool = HaulingSpawnPool.getPoolForLocation(this.level(), this.blockPosition(), isLava ? (FluidType)NeoForgeMod.LAVA_TYPE.value() : (FluidType)NeoForgeMod.WATER_TYPE.value());
        Optional<Entity> entry = pool.flatMap(pool2 -> pool2.getEntry(player, this.getLuck()));
        AoAEvents.fireCheckHaulingEntitySpawn(pool.orElse(null), entry.map(haulingEntity -> haulingEntity.apply(this.level(), isLava)).orElse(null), player, this).ifPresent(entity -> {
            if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                BlockPos pos = RandomUtil.getRandomPositionWithinRange((BlockPos)this.blockPosition(), (int)10, (int)10, (int)10, (int)2, (int)2, (int)2, (boolean)false, (Level)this.level(), (int)5, (state, statePos) -> state.getFluidState().getType() == Fluids.WATER);
                mob.setPos((double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f));
                mob.getNavigation().createPath(this.blockPosition(), 0);
                this.level().addFreshEntity((Entity)mob);
            } else {
                entity.setPos(this.getX(), this.getY() - (double)entity.getBbHeight(), this.getZ());
                this.level().addFreshEntity(entity);
            }
            this.spawnedFish = entity;
        });
    }

    protected void checkIfCollided() {
        HitResult rayTrace = ProjectileUtil.getHitResultOnMoveVector((Entity)this, this::canHitEntity);
        if (rayTrace.getType() != HitResult.Type.MISS && !EventHooks.onProjectileImpact((Projectile)this, (HitResult)rayTrace)) {
            this.onHit(rayTrace);
        }
    }

    protected boolean canHitEntity(Entity entity) {
        if (entity.isSpectator() || !entity.isAlive()) {
            return false;
        }
        if (entity instanceof ItemEntity) {
            return true;
        }
        if (!entity.isPickable()) {
            return false;
        }
        Entity owner = this.getOwner();
        return owner == null || !owner.isPassengerOfSameVehicle(entity);
    }

    private void handleSuperTick() {
        if (!this.leftOwner) {
            this.leftOwner = this.checkLeftOwner();
        }
        if (!this.level().isClientSide()) {
            this.setSharedFlag(6, this.hasGlowingTag());
        }
        this.baseTick();
    }

    protected boolean checkStillValid(Player owner) {
        if (!this.isAlive()) {
            return false;
        }
        if (owner == null || !owner.isAlive()) {
            return false;
        }
        if (this.rod == null || this.rod.getItem() == Items.AIR) {
            return false;
        }
        float maxCastDistance = this.getMaxCastDistance();
        if (owner.distanceToSqr((Entity)this) > (double)(maxCastDistance * maxCastDistance)) {
            return false;
        }
        return InventoryUtil.isHoldingItem(owner, (ItemLike)this.rod.getItem());
    }

    protected void onHitEntity(EntityHitResult rayTrace) {
        if (!this.level().isClientSide()) {
            this.hookedEntity = rayTrace.getEntity();
            this.updateHookedEntity();
        }
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> param) {
        if (param.equals((Object)DATA_HOOKED_ENTITY)) {
            int id = (Integer)this.getEntityData().get(DATA_HOOKED_ENTITY);
            this.hookedEntity = id == -1 ? null : this.level().getEntity(id);
        } else if (param.equals(STATE)) {
            this.state = State.byValue((Integer)this.getEntityData().get(STATE));
        } else if (param.equals((Object)DATA_POSE)) {
            this.refreshDimensions();
        }
    }

    protected void updateHookedEntity() {
        if (!this.level().isClientSide()) {
            this.getEntityData().set(DATA_HOOKED_ENTITY, (Object)(this.hookedEntity == null ? -1 : this.hookedEntity.getId()));
        }
    }

    public EntityType<?> getType() {
        return (EntityType)AoAMiscEntities.REINFORCED_BOBBER.get();
    }

    public EntityDimensions getDimensions(Pose pose) {
        return this.getType().getDimensions();
    }

    protected float getMaxCastDistance() {
        return 32.0f;
    }

    protected float getCastStrength() {
        return 1.0f;
    }

    public TagKey<Fluid> getApplicableFluid() {
        return FluidTags.WATER;
    }

    public void handleEntityEvent(byte p_70103_1_) {
    }

    @Nullable
    public Entity getHookedIn() {
        return this.hookedEntity;
    }

    public void remove(Entity.RemovalReason pReason) {
        super.remove(pReason);
        this.stopFishing();
    }

    public static enum State {
        MIDAIR(0),
        HOOKED_FISH(1),
        HOOKED_IN_ENTITY(2),
        IN_FLUID(3),
        STUCK(4);

        private final int value;

        private State(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }

        public static State byValue(int value) {
            return switch (value) {
                case 0 -> MIDAIR;
                case 1 -> HOOKED_FISH;
                case 2 -> HOOKED_IN_ENTITY;
                case 3 -> IN_FLUID;
                default -> STUCK;
            };
        }
    }
}

