/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.misc;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.Tags;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.common.registration.custom.AoASkills;
import net.tslat.aoa3.common.registration.entity.AoAMiscEntities;
import net.tslat.aoa3.common.registration.item.AoATools;
import net.tslat.aoa3.library.object.EntityDataHolder;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.InventoryUtil;
import net.tslat.aoa3.util.PlayerUtil;
import net.tslat.smartbrainlib.util.EntityRetrievalUtil;
import net.tslat.smartbrainlib.util.RandomUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FishingCageEntity
extends Entity
implements OwnableEntity {
    public static final EntityDataHolder<ItemStack> CAUGHT_STACK_1 = EntityDataHolder.register(FishingCageEntity.class, EntityDataSerializers.ITEM_STACK, ItemStack.EMPTY, cage -> cage.loot[0], (cage, stack) -> {
        cage.loot[0] = stack;
    });
    public static final EntityDataHolder<ItemStack> CAUGHT_STACK_2 = EntityDataHolder.register(FishingCageEntity.class, EntityDataSerializers.ITEM_STACK, ItemStack.EMPTY, cage -> cage.loot[1], (cage, stack) -> {
        cage.loot[1] = stack;
    });
    public static final EntityDataHolder<ItemStack> CAUGHT_STACK_3 = EntityDataHolder.register(FishingCageEntity.class, EntityDataSerializers.ITEM_STACK, ItemStack.EMPTY, cage -> cage.loot[2], (cage, stack) -> {
        cage.loot[2] = stack;
    });
    public static final ResourceKey<LootTable> FISHING_CAGE_LOOT_TABLE = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)AdventOfAscension.id("misc/fishing_cage_catches"));
    private UUID ownerUUID = null;
    private int damage;
    private final ItemStack[] loot = new ItemStack[]{ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY};

    public FishingCageEntity(Level world, Player player, ItemStack stack) {
        this((EntityType<? extends Entity>)((EntityType)AoAMiscEntities.FISHING_CAGE.get()), world);
        this.setPos(player.getX(), player.getY() + (double)player.getEyeHeight(), player.getZ());
        this.setRot(player.getYRot(), player.getXRot());
        this.setDeltaMovement(EntityUtil.getDirectionForFacing((Entity)player).multiply(0.75, 0.75, 0.75));
        this.ownerUUID = player.getUUID();
        this.damage = stack.getDamageValue();
    }

    public FishingCageEntity(EntityType<? extends Entity> entityType, Level world) {
        super(entityType, world);
        this.blocksBuilding = true;
    }

    @Nullable
    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        if (player instanceof ServerPlayer) {
            ServerPlayer pl = (ServerPlayer)player;
            if (this.ownerUUID == null || pl.getUUID().equals(this.ownerUUID)) {
                int damage = this.damage + 1;
                ItemStack fishingCage = new ItemStack((ItemLike)AoATools.FISHING_CAGE.get());
                if (damage < fishingCage.getMaxDamage()) {
                    fishingCage.setDamageValue(damage);
                    if (!pl.getAbilities().instabuild) {
                        InventoryUtil.giveItemTo(pl, fishingCage);
                    }
                }
                if (this.hasCatches()) {
                    AoASkill.Instance hauling = PlayerUtil.getAdventPlayer(pl).getSkill((AoASkill)AoASkills.HAULING.get());
                    if (hauling.canGainXp(true)) {
                        float xp = PlayerUtil.getTimeBasedXpForLevel(hauling.getLevel(true), 1000.0f) * (float)Math.min(4, this.loot.length);
                        hauling.adjustXp(xp, false, false);
                    }
                    for (ItemStack drop : this.loot) {
                        if (drop.is(ItemTags.FISHES)) {
                            pl.awardStat(Stats.FISH_CAUGHT, 1);
                        }
                        InventoryUtil.giveItemTo(pl, drop);
                    }
                }
                pl.awardStat(Stats.ITEM_USED.get((Object)((Item)AoATools.FISHING_CAGE.get())));
                this.discard();
                return InteractionResult.SUCCESS;
            }
        }
        return this.level().isClientSide() ? InteractionResult.SUCCESS : InteractionResult.FAIL;
    }

    public boolean canChangeDimensions(Level from, Level to) {
        return false;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        CAUGHT_STACK_1.defineDefault(builder);
        CAUGHT_STACK_2.defineDefault(builder);
        CAUGHT_STACK_3.defineDefault(builder);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
        if (!CAUGHT_STACK_1.checkSync(this, key) && !CAUGHT_STACK_2.checkSync(this, key)) {
            CAUGHT_STACK_3.checkSync(this, key);
        }
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        if (this.ownerUUID != null) {
            compound.putUUID("OwnerUUID", this.ownerUUID);
        }
        compound.putInt("Damage", this.damage);
        ListTag lootList = new ListTag();
        for (int i = 0; i < 3; ++i) {
            if (this.loot[i].isEmpty()) continue;
            lootList.add((Object)this.loot[i].save((HolderLookup.Provider)this.registryAccess()));
        }
        if (!lootList.isEmpty()) {
            compound.put("loot", (Tag)lootList);
        }
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        if (compound.hasUUID("OwnerUUID")) {
            this.ownerUUID = compound.getUUID("OwnerUUID");
        }
        if (compound.contains("Damage", 3)) {
            this.damage = compound.getInt("Damage");
        }
        if (compound.contains("loot")) {
            ListTag lootList = compound.getList("loot", 10);
            if (lootList.size() > 2) {
                CAUGHT_STACK_3.set(this, ItemStack.parseOptional((HolderLookup.Provider)this.level().registryAccess(), (CompoundTag)lootList.getCompound(2)));
            }
            if (lootList.size() > 1) {
                CAUGHT_STACK_2.set(this, ItemStack.parseOptional((HolderLookup.Provider)this.level().registryAccess(), (CompoundTag)lootList.getCompound(1)));
            }
            CAUGHT_STACK_1.set(this, ItemStack.parseOptional((HolderLookup.Provider)this.level().registryAccess(), (CompoundTag)lootList.getCompound(0)));
        }
    }

    @NotNull
    public ItemStack[] getLoot() {
        return this.loot;
    }

    public boolean isPushable() {
        return true;
    }

    public boolean isPushedByFluid() {
        return false;
    }

    public boolean isPickable() {
        return true;
    }

    public boolean canBeCollidedWith() {
        return this.tickCount > 1;
    }

    @Nullable
    public ItemStack getPickResult() {
        return ((Item)AoATools.FISHING_CAGE.get()).getDefaultInstance();
    }

    public boolean isInvulnerableTo(DamageSource source) {
        return !source.is(Tags.DamageTypes.IS_TECHNICAL);
    }

    protected void doFishingCheckTick() {
        if (this.level().isClientSide() || this.ownerUUID == null) {
            return;
        }
        if (!CAUGHT_STACK_3.is(this, ItemStack.EMPTY)) {
            return;
        }
        if (!this.onGround() || !this.isInWater()) {
            return;
        }
        if (RandomUtil.oneInNChance((int)5000)) {
            FluidState fluid = this.level().getFluidState(this.blockPosition());
            Fluid fluid2 = fluid.getType();
            if (!(fluid2 instanceof FlowingFluid)) {
                if (!RandomUtil.oneInNChance((int)10)) {
                    return;
                }
            } else {
                FlowingFluid flowingFluid = (FlowingFluid)fluid2;
                if (flowingFluid.getFlow((BlockGetter)this.level(), this.blockPosition(), fluid).lengthSqr() == 0.0 && !RandomUtil.fiftyFifty()) {
                    return;
                }
            }
            if (!RandomUtil.oneInNChance((int)Math.max(1, EntityRetrievalUtil.getEntities((Entity)this, (double)5.0, entity -> entity instanceof FishingCageEntity).size()))) {
                return;
            }
            Player owner = this.level().getPlayerByUUID(this.ownerUUID);
            if (owner != null) {
                LootParams.Builder lootContext = new LootParams.Builder((ServerLevel)this.level()).withParameter(LootContextParams.ORIGIN, (Object)this.position()).withParameter(LootContextParams.TOOL, (Object)new ItemStack((ItemLike)AoATools.FISHING_CAGE.get())).withParameter(LootContextParams.THIS_ENTITY, (Object)this).withParameter(LootContextParams.ATTACKING_ENTITY, (Object)owner).withLuck(2.0f + owner.getLuck());
                LootTable lootTable = this.level().getServer().reloadableRegistries().getLootTable(FISHING_CAGE_LOOT_TABLE);
                ObjectArrayList loot = lootTable.getRandomItems(lootContext.create(LootContextParamSets.FISHING));
                for (int i = 0; i < 3 && i < loot.size(); ++i) {
                    if (CAUGHT_STACK_1.is(this, ItemStack.EMPTY)) {
                        CAUGHT_STACK_1.set(this, (ItemStack)loot.get(i));
                        continue;
                    }
                    if (CAUGHT_STACK_2.is(this, ItemStack.EMPTY)) {
                        CAUGHT_STACK_2.set(this, (ItemStack)loot.get(i));
                        continue;
                    }
                    CAUGHT_STACK_3.set(this, (ItemStack)loot.get(i));
                }
            }
        }
    }

    public void tick() {
        boolean wasInWater = this.isInWater();
        this.baseTick();
        this.doFishingCheckTick();
        Vec3 velocity = this.getDeltaMovement();
        double gravity = 0.08;
        if (this.isInWater()) {
            double yPos = this.getY();
            if (!wasInWater) {
                this.setDeltaMovement(velocity.multiply((double)0.1f, (double)0.1f, (double)0.1f));
            }
            if (velocity.y() < (double)-0.023f) {
                this.level().addParticle((ParticleOptions)ParticleTypes.BUBBLE, this.getX() + this.random.nextGaussian() * (double)this.getBbWidth() * 0.5, this.getY(), this.getZ() + this.random.nextGaussian() * (double)this.getBbWidth() * 0.5, 0.0, 0.0, 0.0);
            }
            this.move(MoverType.SELF, this.getDeltaMovement());
            Vec3 motion = this.getDeltaMovement().multiply((double)0.8f, (double)0.8f, (double)0.8f);
            double yVelocity = velocity.y() <= 0.0 && Math.abs(motion.y() - 0.005) >= 0.003 && Math.abs(motion.y() - gravity / 16.0) < 0.003 ? -0.003 : motion.y() - gravity / 16.0;
            Vec3 newVelocity = new Vec3(motion.x(), yVelocity, motion.z());
            this.setDeltaMovement(newVelocity);
            if (this.horizontalCollision && this.isFree(newVelocity.x(), newVelocity.y() + (double)0.6f - this.getY() + yPos, newVelocity.z())) {
                this.setDeltaMovement(newVelocity.x(), 0.3f, newVelocity.z());
            }
        } else {
            BlockPos feetPos = this.getBlockPosBelowThatAffectsMyMovement();
            float blockSlipperiness = this.level().getBlockState(this.getBlockPosBelowThatAffectsMyMovement()).getFriction((LevelReader)this.level(), this.getBlockPosBelowThatAffectsMyMovement(), (Entity)this);
            float friction = this.onGround() ? blockSlipperiness * 0.91f : 0.91f;
            this.move(MoverType.SELF, this.getDeltaMovement());
            Vec3 newVelocity = this.getDeltaMovement();
            double newYVelocity = newVelocity.y();
            if (this.level().isClientSide && !this.level().hasChunkAt(feetPos)) {
                newYVelocity = this.getY() > 0.0 ? -0.1 : 0.0;
            } else if (!this.isNoGravity()) {
                newYVelocity -= gravity;
            }
            this.setDeltaMovement(newVelocity.x() * (double)friction, newYVelocity * (double)0.98f, newVelocity.z() * (double)friction);
        }
        this.setDeltaMovement(this.getDeltaMovement().multiply((double)0.98f, (double)0.98f, (double)0.98f));
        if (!this.level().isClientSide()) {
            this.setSharedFlag(6, this.hasGlowingTag());
        }
    }

    public void baseTick() {
        this.level().getProfiler().push("entityBaseTick");
        this.updateInWaterStateAndDoFluidPushing();
        if (!this.level().isClientSide()) {
            if (this.getY() < (double)(this.level().getMinBuildHeight() - 20)) {
                this.onBelowWorld();
            }
            if (this.isInLava()) {
                this.lavaHurt();
            }
            if (this.isAlive() && this.tickCount > 40 && this.onGround() && !this.isInWater()) {
                ItemStack fishingCage = new ItemStack((ItemLike)AoATools.FISHING_CAGE.get());
                if (this.hasCatches()) {
                    ++this.damage;
                }
                fishingCage.setDamageValue(this.damage);
                this.spawnAtLocation(fishingCage);
                this.discard();
            }
        }
        this.level().getProfiler().pop();
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        if (!this.level().isClientSide() && amount >= 1.0f) {
            this.markHurt();
            this.discard();
        }
        return true;
    }

    public void remove(Entity.RemovalReason reason) {
        if (!this.level().isClientSide() && this.hasCatches()) {
            for (ItemStack stack : this.loot) {
                this.spawnAtLocation(stack);
            }
        }
        super.remove(reason);
    }

    public boolean hasCatches() {
        return !CAUGHT_STACK_1.is(this, ItemStack.EMPTY);
    }
}

