/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.misc;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.tslat.effectslib.api.particle.ParticleBuilder;

public class FakeTntEntity
extends Entity {
    private static final EntityDataAccessor<Integer> FUSE_TIME = SynchedEntityData.defineId(FakeTntEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private boolean dealsDamage = false;

    public FakeTntEntity(EntityType<? extends FakeTntEntity> entityType, Level level) {
        super(entityType, level);
        this.blocksBuilding = true;
    }

    public FakeTntEntity(EntityType<? extends FakeTntEntity> entityType, Level level, double x, double y, double z) {
        this(entityType, level);
        this.setPos(x, y, z);
        double pulseFrequency = level.random.nextDouble() * 6.2831854820251465;
        this.setDeltaMovement(-Math.sin(pulseFrequency) * 0.02, 0.2f, -Math.cos(pulseFrequency) * 0.02);
        this.setFuse(80);
        this.xo = x;
        this.yo = y;
        this.zo = z;
    }

    public void setDealsDamage(boolean dealsDamage) {
        this.dealsDamage = dealsDamage;
    }

    public void setFuse(int life) {
        this.entityData.set(FUSE_TIME, (Object)life);
    }

    public int getFuse() {
        return (Integer)this.entityData.get(FUSE_TIME);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(FUSE_TIME, (Object)80);
    }

    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    public boolean isPickable() {
        return !this.isRemoved();
    }

    protected void readAdditionalSaveData(CompoundTag compoundTag) {
        if (compoundTag.contains("DealsDamage", 1)) {
            this.dealsDamage = compoundTag.getBoolean("DealsDamage");
        }
    }

    protected void addAdditionalSaveData(CompoundTag compoundTag) {
    }

    protected double getDefaultGravity() {
        return 0.04f;
    }

    public void tick() {
        if (!this.level().isClientSide && this.tickCount == 1) {
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.TNT_PRIMED, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        this.handlePortal();
        this.applyGravity();
        this.move(MoverType.SELF, this.getDeltaMovement());
        this.setDeltaMovement(this.getDeltaMovement().scale((double)0.98f));
        if (this.onGround()) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(0.7, -0.5, 0.7));
        }
        int fuseTick = this.getFuse();
        this.setFuse(--fuseTick);
        if (fuseTick <= 0) {
            this.discard();
            if (!this.level().isClientSide) {
                this.explode();
            }
        } else {
            this.updateInWaterStateAndDoFluidPushing();
            if (this.level().isClientSide) {
                this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, this.getX(), this.getY() + 0.5, this.getZ(), 0.0, 0.0, 0.0);
            }
        }
    }

    protected void explode() {
        if (this.dealsDamage) {
            this.level().explode((Entity)this, Explosion.getDefaultDamageSource((Level)this.level(), (Entity)this), null, this.getX(), this.getY(0.0625), this.getZ(), 4.0f, false, Level.ExplosionInteraction.NONE);
        } else if (this.level().isClientSide) {
            this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), (SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), SoundSource.BLOCKS, 4.0f, (1.0f + (this.level().random.nextFloat() - this.level().random.nextFloat()) * 0.2f) * 0.7f, false);
            ParticleBuilder.forPosition((ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, (double)this.getX(), (double)this.getY(), (double)this.getZ()).spawnParticles(this.level());
        }
    }
}

