/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.misc;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.fluids.FluidType;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.effectslib.api.util.EffectBuilder;
import net.tslat.smartbrainlib.util.EntityRetrievalUtil;
import org.jetbrains.annotations.Nullable;

public class EarthquakeBlockEntity
extends Entity {
    public static final EntityDataAccessor<BlockPos> BLOCK_ORIGIN = SynchedEntityData.defineId(EarthquakeBlockEntity.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_POS);
    private BlockState block = Blocks.AIR.defaultBlockState();
    private BlockPos blockOrigin = BlockPos.ZERO;
    @Nullable
    private LivingEntity owner = null;
    private float damage = 4.0f;

    public EarthquakeBlockEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
        this.noPhysics = true;
    }

    public EarthquakeBlockEntity(EntityType<?> entityType, Level level, BlockState block, BlockPos pos, @Nullable LivingEntity owner) {
        this(entityType, level);
        this.owner = owner;
        this.block = block;
        this.getEntityData().set(BLOCK_ORIGIN, (Object)pos);
    }

    public void setOwner(LivingEntity owner) {
        this.owner = owner;
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    public BlockState getBlock() {
        return this.block;
    }

    public BlockPos getBlockOrigin() {
        return this.blockOrigin;
    }

    @Nullable
    public LivingEntity getOwner() {
        return this.owner;
    }

    public float getDamage() {
        return this.damage;
    }

    public boolean isPushable() {
        return false;
    }

    public boolean isPushedByFluid() {
        return false;
    }

    public boolean canBeCollidedWith() {
        return true;
    }

    public void tick() {
        super.tick();
        if (!this.isNoGravity()) {
            double gravity = -0.08;
            FluidType submergedFluid = this.getEyeInFluidType();
            if (submergedFluid != NeoForgeMod.EMPTY_TYPE.value()) {
                gravity *= this.getFluidMotionScale(submergedFluid);
            }
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, gravity, 0.0));
        }
        if (this.getDeltaMovement().lengthSqr() != 0.0) {
            this.move(MoverType.SELF, this.getDeltaMovement());
            if (!this.level().isClientSide) {
                for (LivingEntity entity2 : EntityRetrievalUtil.getEntities((Level)this.level(), (AABB)this.getBoundingBox(), entity -> entity != this.owner && entity instanceof LivingEntity)) {
                    if (!entity2.hurt(DamageUtil.indirectEntityDamage((ResourceKey<DamageType>)DamageTypes.MOB_ATTACK_NO_AGGRO, (Entity)this.owner, this), this.damage)) continue;
                    EntityUtil.applyPotions((Entity)entity2, new EffectBuilder(MobEffects.MOVEMENT_SLOWDOWN, 60).level(3).isAmbient().hideParticles());
                }
            }
        }
        if (this.blockPosition().above().equals((Object)this.blockOrigin)) {
            this.discard();
        }
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity entity) {
        return new ClientboundAddEntityPacket((Entity)this, entity, Block.getId((BlockState)this.getBlock()));
    }

    public void recreateFromPacket(ClientboundAddEntityPacket packet) {
        super.recreateFromPacket(packet);
        this.block = Block.stateById((int)packet.getData());
        this.blocksBuilding = true;
        this.setPos(packet.getX(), packet.getY(), packet.getZ());
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(BLOCK_ORIGIN, (Object)BlockPos.ZERO);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
        if (key.equals(BLOCK_ORIGIN)) {
            this.blockOrigin = (BlockPos)this.getEntityData().get(BLOCK_ORIGIN);
        }
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
    }
}

