/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.brain.task.temp;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.ToIntFunction;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.entity.ai.util.HoverRandomPos;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.object.SquareRadius;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.jetbrains.annotations.Nullable;

public class SetRandomFlyingTarget<E extends PathfinderMob>
extends ExtendedBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT)});
    protected BiFunction<E, Vec3, Float> speedModifier = (entity, targetPos) -> Float.valueOf(1.0f);
    protected SquareRadius radius = new SquareRadius(10.0, 10.0);
    protected BiPredicate<E, Vec3> positionPredicate = (entity, pos) -> true;
    protected ToIntFunction<E> verticalWeight = entity -> -2;

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    public SetRandomFlyingTarget<E> setRadius(double radius) {
        return this.setRadius(radius, radius);
    }

    public SetRandomFlyingTarget<E> setRadius(double xz, double y) {
        this.radius = new SquareRadius(xz, y);
        return this;
    }

    public SetRandomFlyingTarget<E> speedModifier(float modifier) {
        return this.speedModifier((entity, targetPos) -> Float.valueOf(modifier));
    }

    public SetRandomFlyingTarget<E> speedModifier(BiFunction<E, Vec3, Float> function) {
        this.speedModifier = function;
        return this;
    }

    public SetRandomFlyingTarget<E> flightTargetPredicate(BiPredicate<E, Vec3> predicate) {
        this.positionPredicate = predicate;
        return this;
    }

    public SetRandomFlyingTarget<E> verticalWeight(ToIntFunction<E> function) {
        this.verticalWeight = function;
        return this;
    }

    protected void start(E entity) {
        Vec3 targetPos = this.getTargetPos(entity);
        if (!this.positionPredicate.test(entity, targetPos)) {
            targetPos = null;
        }
        if (targetPos == null) {
            BrainUtils.clearMemory(entity, (MemoryModuleType)MemoryModuleType.WALK_TARGET);
        } else {
            BrainUtils.setMemory(entity, (MemoryModuleType)MemoryModuleType.WALK_TARGET, (Object)new WalkTarget(targetPos, this.speedModifier.apply(entity, targetPos).floatValue(), 0));
        }
    }

    @Nullable
    protected Vec3 getTargetPos(E entity) {
        Vec3 entityFacing = entity.getViewVector(0.0f);
        Vec3 hoverPos = HoverRandomPos.getPos(entity, (int)((int)Math.ceil(this.radius.xzRadius())), (int)((int)Math.ceil(this.radius.yRadius())), (double)entityFacing.x, (double)entityFacing.z, (float)1.5707964f, (int)3, (int)1);
        if (hoverPos != null) {
            return hoverPos;
        }
        return AirAndWaterRandomPos.getPos(entity, (int)((int)Math.ceil(this.radius.xzRadius())), (int)((int)Math.ceil(this.radius.yRadius())), (int)this.verticalWeight.applyAsInt(entity), (double)entityFacing.x, (double)entityFacing.z, (double)1.5707963705062866);
    }
}

