/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.brain.task.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.PositionAndMotionUtil;
import net.tslat.effectslib.api.particle.ParticleBuilder;
import net.tslat.effectslib.networking.packet.TELParticlePacket;
import net.tslat.smartbrainlib.api.core.behaviour.custom.attack.ConditionlessAttack;
import net.tslat.smartbrainlib.object.SquareRadius;
import net.tslat.smartbrainlib.util.EntityRetrievalUtil;

public class GroundSlamAttack<E extends LivingEntity>
extends ConditionlessAttack<E> {
    protected SquareRadius radius = new SquareRadius(10.0, 10.0);
    protected boolean atTarget = false;

    public GroundSlamAttack(int delayTicks) {
        super(delayTicks);
        this.attack(this::doSlam);
    }

    public GroundSlamAttack<E> radius(int radius) {
        return this.radius(radius, radius);
    }

    public GroundSlamAttack<E> radius(double xz, double y) {
        this.radius = new SquareRadius(xz, y);
        return this;
    }

    public GroundSlamAttack<E> slamAtTarget() {
        this.requiresTarget();
        this.atTarget = true;
        return this;
    }

    protected void doSlam(E entity) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        TELParticlePacket packet = new TELParticlePacket();
        Level level = entity.level();
        RandomSource rand = entity.getRandom();
        Object originEntity = this.atTarget ? this.target : entity;
        int x = -((int)this.radius.xzRadius());
        while ((double)x < this.radius.xzRadius()) {
            int z = -((int)this.radius.xzRadius());
            while ((double)z < this.radius.xzRadius()) {
                Vec3 spawnPos = originEntity.position().add((double)x, 0.0, (double)z);
                PositionAndMotionUtil.getNearestOnGroundPosition(level, spawnPos).ifPresent(particlePos -> {
                    BlockState groundState = level.getBlockState((BlockPos)pos.set(spawnPos.x, spawnPos.y - 1.0, spawnPos.z));
                    if (groundState.blocksMotion()) {
                        packet.particle(ParticleBuilder.forPositions((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, groundState), (Vec3[])new Vec3[]{new Vec3(spawnPos.x + rand.nextGaussian(), spawnPos.y + 1.1, spawnPos.z + rand.nextGaussian())}).ignoreDistanceAndLimits().spawnNTimes(3));
                    }
                });
                ++z;
            }
            ++x;
        }
        packet.sendToAllPlayersTrackingEntity((ServerLevel)level, entity);
        for (LivingEntity target2 : EntityRetrievalUtil.getEntities(originEntity, (double)this.radius.xzRadius(), (double)this.radius.yRadius(), (double)this.radius.xzRadius(), LivingEntity.class, target -> DamageUtil.isAttackable(target) && target.onGround())) {
            entity.doHurtTarget((Entity)target2);
        }
    }
}

