/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.brain.task.custom;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.smartbrainlib.api.core.behaviour.DelayedBehaviour;
import net.tslat.smartbrainlib.registry.SBLMemoryTypes;
import net.tslat.smartbrainlib.util.BrainUtils;
import net.tslat.smartbrainlib.util.EntityRetrievalUtil;

public class ChargeAttack<E extends PathfinderMob>
extends DelayedBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryStatus.VALUE_PRESENT), Pair.of((Object)((MemoryModuleType)SBLMemoryTypes.SPECIAL_ATTACK_COOLDOWN.get()), (Object)MemoryStatus.VALUE_ABSENT), Pair.of((Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryStatus.REGISTERED)});
    protected float speedMod = 1.0f;
    private boolean targetWhenCharging = false;
    private Vec3 chargeVelocity;
    private long additionalTimeout = -1L;

    public ChargeAttack(int delayTicks) {
        super(delayTicks);
    }

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    public ChargeAttack<E> speedModifier(float speedMod) {
        this.speedMod = speedMod;
        return this;
    }

    public ChargeAttack<E> targetWhenCharging() {
        this.targetWhenCharging = true;
        return this;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, E entity) {
        return Math.abs(BrainUtils.getTargetOfEntity(entity).getY() - entity.getY()) < 2.0;
    }

    protected void start(E entity) {
        this.calculateTarget(entity);
        BrainUtils.clearMemories(entity, (MemoryModuleType[])new MemoryModuleType[]{MemoryModuleType.WALK_TARGET, MemoryModuleType.LOOK_TARGET, MemoryModuleType.PATH});
        entity.setDeltaMovement(0.0, entity.getDeltaMovement().y, 0.0);
    }

    public void calculateTarget(E entity) {
        LivingEntity target = BrainUtils.getTargetOfEntity(entity);
        if (target == null) {
            return;
        }
        double moveSpeed = Math.max((double)entity.getSpeed(), entity.getAttributeValue(Attributes.MOVEMENT_SPEED)) * 2.0;
        Vec3 targetPos = new Vec3(target.getX(0.5), 0.0, target.getZ(0.5));
        Vec3 entityPos = new Vec3(entity.getX(0.5), 0.0, entity.getZ(0.5));
        this.chargeVelocity = targetPos.subtract(entityPos).normalize().multiply(moveSpeed, 0.0, moveSpeed).subtract(0.0, entity.getAttributeValue(Attributes.GRAVITY), 0.0);
        this.additionalTimeout = this.delayFinishedAt + 1L + (long)Math.max(20, (int)(entityPos.distanceTo(targetPos) / (moveSpeed * 0.25)));
        entity.lookAt(EntityAnchorArgument.Anchor.FEET, targetPos);
    }

    protected boolean timedOut(long gameTime) {
        return gameTime > this.additionalTimeout && super.timedOut(gameTime);
    }

    protected boolean canStillUse(ServerLevel level, E entity, long gameTime) {
        return !((PathfinderMob)entity).horizontalCollision;
    }

    protected void tick(E entity) {
        if (this.delayFinishedAt <= entity.level().getGameTime()) {
            entity.setSharedFlag(3, true);
            entity.setDeltaMovement(this.chargeVelocity);
            entity.lookAt(EntityAnchorArgument.Anchor.FEET, entity.position().add(this.chargeVelocity));
            for (LivingEntity target2 : EntityRetrievalUtil.getEntities((Level)entity.level(), (AABB)entity.getBoundingBox().expandTowards(this.chargeVelocity), target -> {
                Player pl;
                return target != entity && target.isAlive() && target instanceof LivingEntity && (!(target instanceof Player) || !(pl = (Player)target).isCreative());
            })) {
                entity.doHurtTarget((Entity)target2);
                EntityUtil.pushEntityAway(entity, (Entity)target2, 1.5f);
            }
        }
    }

    protected void doDelayedAction(E entity) {
        if (this.targetWhenCharging) {
            this.calculateTarget(entity);
        }
    }

    protected void stop(E entity) {
        entity.setSharedFlag(3, false);
    }
}

