/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.brain.task;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.ItemLike;
import net.tslat.aoa3.common.registration.item.AoAWeapons;
import net.tslat.aoa3.content.item.weapon.gun.BaseGun;
import net.tslat.aoa3.util.AttributeUtil;
import net.tslat.smartbrainlib.util.RandomUtil;

public class CounterTargetWeaponTask
extends Behavior<Mob> {
    private final int minSwitchTime;
    private final int maxSwitchTime;
    private long nextSwitchTime = 0L;

    public CounterTargetWeaponTask() {
        this(10, 20);
    }

    public CounterTargetWeaponTask(int minSwitchTime, int maxSwitchTime) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryStatus.VALUE_PRESENT));
        this.minSwitchTime = minSwitchTime;
        this.maxSwitchTime = maxSwitchTime;
    }

    protected boolean checkExtraStartConditions(ServerLevel pLevel, Mob owner) {
        LivingEntity target = (LivingEntity)owner.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).get();
        if (!target.isAlive()) {
            return false;
        }
        return this.nextSwitchTime == 0L || this.nextSwitchTime < owner.level().getGameTime();
    }

    protected void start(ServerLevel pLevel, Mob owner, long pGameTime) {
        LivingEntity target = (LivingEntity)owner.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).get();
        switch (this.determineThreat((LivingEntity)owner, target).ordinal()) {
            case 1: {
                this.handleMeleeThreat((LivingEntity)owner, target);
                break;
            }
            case 2: {
                this.handleRangedThreat((LivingEntity)owner, target);
                break;
            }
            case 3: {
                this.handleShieldThreat((LivingEntity)owner, target);
                break;
            }
        }
        this.nextSwitchTime = RandomUtil.randomNumberBetween((int)this.minSwitchTime, (int)this.maxSwitchTime);
    }

    protected ThreatType determineThreat(LivingEntity owner, LivingEntity target) {
        ItemStack mainHandItem = target.getItemInHand(InteractionHand.MAIN_HAND);
        if (mainHandItem.getItem() instanceof ShieldItem || target.getItemInHand(InteractionHand.OFF_HAND).getItem() instanceof ShieldItem) {
            return ThreatType.SHIELD;
        }
        if (mainHandItem.getItem() instanceof SwordItem || AttributeUtil.getAttributeValue(target, (Holder<Attribute>)Attributes.ATTACK_DAMAGE) > 5.0) {
            if (!(owner.getItemInHand(InteractionHand.MAIN_HAND).getItem() instanceof SwordItem)) {
                return ThreatType.MELEE;
            }
            return ThreatType.NONE;
        }
        if (mainHandItem.getItem() instanceof BowItem || mainHandItem.getItem() instanceof BaseGun) {
            if (!(owner.getItemInHand(InteractionHand.OFF_HAND).getItem() instanceof ShieldItem)) {
                return ThreatType.RANGED;
            }
            return ThreatType.NONE;
        }
        return ThreatType.NONE;
    }

    protected void handleMeleeThreat(LivingEntity owner, LivingEntity target) {
        owner.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)AoAWeapons.HARVESTER_SWORD.get()));
        owner.setItemInHand(InteractionHand.OFF_HAND, ItemStack.EMPTY);
    }

    protected void handleRangedThreat(LivingEntity owner, LivingEntity target) {
        owner.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)AoAWeapons.HARVESTER_SWORD.get()));
        owner.setItemInHand(InteractionHand.OFF_HAND, new ItemStack((ItemLike)Items.SHIELD));
    }

    protected void handleShieldThreat(LivingEntity owner, LivingEntity target) {
        owner.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)AoAWeapons.HORIZON_MAUL.get()));
        owner.setItemInHand(InteractionHand.OFF_HAND, new ItemStack((ItemLike)Items.SHIELD));
    }

    private static enum ThreatType {
        NONE,
        MELEE,
        RANGED,
        SHIELD;

    }
}

