/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.boss.skeletron;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.common.registration.entity.AoAEntityStats;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.content.entity.base.AoAEntityPart;
import net.tslat.aoa3.content.entity.boss.AoABoss;
import net.tslat.aoa3.library.object.EntityDataHolder;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DefaultAnimations;

public class SkeletronEntity
extends AoABoss {
    public static final EntityDataHolder<Boolean> WOUNDED = EntityDataHolder.register(SkeletronEntity.class, EntityDataSerializers.BOOLEAN, false, entity -> entity.wounded, (entity, value) -> {
        entity.wounded = value;
    });
    private boolean wounded = false;

    public SkeletronEntity(EntityType<? extends SkeletronEntity> entityType, Level level) {
        super((EntityType<? extends AoABoss>)entityType, level);
        this.setParts(new AoAEntityPart<SkeletronEntity>(this, 0.875f, this.getBbHeight() - 0.625f, 0.0f, 0.5f, -this.getBbWidth() * 0.5f - 0.4375f), new AoAEntityPart<SkeletronEntity>(this, 0.5625f, 0.5625f, 0.0f, 0.4375f, -this.getBbWidth() * 1.35f).setDamageMultiplier(0.85f), new AoAEntityPart<SkeletronEntity>(this, 0.5625f, 0.5625f, 0.0f, 0.375f, -this.getBbWidth() * 1.75f).setDamageMultiplier(0.85f), new AoAEntityPart<SkeletronEntity>(this, 0.875f, this.getBbHeight() - 0.625f, 0.0f, 0.5f, this.getBbWidth() * 0.5f + 0.4375f), new AoAEntityPart<SkeletronEntity>(this, 0.6875f, 1.0f, 0.0f, 0.5f, this.getBbWidth() * 1.4f));
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        this.registerDataParams(builder, WOUNDED);
    }

    @Override
    @Nullable
    public SoundEvent getMusic() {
        return null;
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Wounded", WOUNDED.get((Entity)this).booleanValue());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Wounded", 1)) {
            WOUNDED.set((Entity)this, compound.getBoolean("Wounded"));
        }
    }

    protected void dropCustomDeathLoot(ServerLevel level, DamageSource damageSource, boolean killedByPlayer) {
        super.dropCustomDeathLoot(level, damageSource, killedByPlayer);
        if (WOUNDED.is((Entity)this, true)) {
            this.spawnAtLocation((ItemLike)AoAItems.WARPED_HORN.get());
        }
    }

    public static AoAEntityStats.AttributeBuilder entityStats(EntityType<SkeletronEntity> entityType) {
        return AoAEntityStats.AttributeBuilder.createMonster(entityType).health(275.0).moveSpeed(0.31).meleeStrength(15.0).knockbackResist(0.9).followRange(100.0).aggroRange(64.0).armour(10.0, 10.0).knockback(1.0).stepHeight(1.25);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "Walk/Run/Idle", 0, state -> {
            if (state.isMoving()) {
                if (this.isSprinting()) {
                    return state.setAndContinue(DefaultAnimations.RUN);
                }
                return state.setAndContinue(WOUNDED.is((Entity)this, true) ? RawAnimation.begin().thenLoop("move.walk.wounded") : DefaultAnimations.WALK);
            }
            return state.setAndContinue(WOUNDED.is((Entity)this, true) ? RawAnimation.begin().thenLoop("misc.idle.wounded") : DefaultAnimations.IDLE);
        }));
    }
}

