/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.boss.nethengeic_wither;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.fluids.FluidType;
import net.tslat.aoa3.common.particleoption.EntityTrackingParticleOptions;
import net.tslat.aoa3.common.registration.AoAAttributes;
import net.tslat.aoa3.common.registration.AoAExplosions;
import net.tslat.aoa3.common.registration.AoAParticleTypes;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.entity.AoABrainActivities;
import net.tslat.aoa3.common.registration.entity.AoABrainMemories;
import net.tslat.aoa3.common.registration.entity.AoADamageTypes;
import net.tslat.aoa3.common.registration.entity.AoAEntityStats;
import net.tslat.aoa3.common.registration.entity.AoAMobEffects;
import net.tslat.aoa3.content.entity.ai.movehelper.AirborneMoveControl;
import net.tslat.aoa3.content.entity.base.AoAMonster;
import net.tslat.aoa3.content.entity.base.AoARangedAttacker;
import net.tslat.aoa3.content.entity.boss.AoABoss;
import net.tslat.aoa3.content.entity.brain.sensor.AggroBasedNearbyPlayersSensor;
import net.tslat.aoa3.content.entity.projectile.mob.BaseMobProjectile;
import net.tslat.aoa3.content.entity.projectile.mob.FireballEntity;
import net.tslat.aoa3.library.object.EntityDataHolder;
import net.tslat.aoa3.library.object.explosion.StandardExplosion;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.PositionAndMotionUtil;
import net.tslat.effectslib.api.particle.ParticleBuilder;
import net.tslat.effectslib.networking.packet.TELParticlePacket;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.FirstApplicableBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.OneRandomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.attack.AnimatableRangedAttack;
import net.tslat.smartbrainlib.api.core.behaviour.custom.attack.ConditionlessHeldAttack;
import net.tslat.smartbrainlib.api.core.behaviour.custom.look.LookAtTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.CustomDelayedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.InvalidateMemory;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.StayWithinDistanceOfAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.StrafeTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.WalkOrRunToWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomHoverTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetAdditionalAttackTargets;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.TargetOrRetaliate;
import net.tslat.smartbrainlib.api.core.navigation.SmoothFlyingPathNavigation;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.HurtBySensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyLivingEntitySensor;
import net.tslat.smartbrainlib.registry.SBLMemoryTypes;
import net.tslat.smartbrainlib.util.BrainUtils;
import net.tslat.smartbrainlib.util.RandomUtil;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DefaultAnimations;

public class NethengeicWitherEntity
extends AoABoss
implements AoARangedAttacker {
    public static final EntityDataHolder<Boolean> FLAME_AURA = EntityDataHolder.register(NethengeicWitherEntity.class, EntityDataSerializers.BOOLEAN, false, entity -> entity.flameAura, (entity, value) -> {
        entity.flameAura = value;
    });
    public static final EntityDataHolder<Integer> SECOND_HEAD_TARGET = EntityDataHolder.register(NethengeicWitherEntity.class, EntityDataSerializers.INT, -1, entity -> entity.secondHeadTarget, (entity, value) -> {
        entity.secondHeadTarget = value;
    });
    public static final EntityDataHolder<Integer> THIRD_HEAD_TARGET = EntityDataHolder.register(NethengeicWitherEntity.class, EntityDataSerializers.INT, -1, entity -> entity.thirdHeadTarget, (entity, value) -> {
        entity.thirdHeadTarget = value;
    });
    private static final RawAnimation FLAMETHROWER_ANIM = RawAnimation.begin().thenLoop("attack.flamethrower.center");
    private static final RawAnimation CORE_SPIN_ANIM = RawAnimation.begin().thenLoop("attack.core.spin");
    private static final RawAnimation FIRE_BOMB_ANIM = RawAnimation.begin().thenLoop("attack.fire_bomb.idle");
    private static final int FIREBALL_STATE = 0;
    private static final int FLAMETHROWER_STATE = 1;
    private static final int FIRE_BOMB_STATE = 2;
    private boolean flameAura = false;
    private boolean doneFireBomb = false;
    private int secondHeadTarget = -1;
    private int thirdHeadTarget = -1;

    public NethengeicWitherEntity(EntityType<? extends NethengeicWitherEntity> entityType, Level level) {
        super((EntityType<? extends AoABoss>)entityType, level);
        this.moveControl = new AirborneMoveControl((Mob)this, 30, true);
        this.setNoGravity(true);
    }

    @Override
    protected void addSwingData(AoABoss.SwingData swings) {
        swings.put(0, new AoABoss.SwingData.Swing(10, 6, RawAnimation.begin()));
        swings.put(1, new AoABoss.SwingData.Swing(0, 0, RawAnimation.begin()));
        swings.put(2, new AoABoss.SwingData.Swing(0, 0, RawAnimation.begin()));
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        this.registerDataParams(builder, FLAME_AURA);
        this.registerDataParams(builder, SECOND_HEAD_TARGET);
        this.registerDataParams(builder, THIRD_HEAD_TARGET);
    }

    @Override
    protected PathNavigation createNavigation(Level level) {
        SmoothFlyingPathNavigation navigation = new SmoothFlyingPathNavigation((Mob)this, level);
        navigation.setCanOpenDoors(false);
        navigation.setCanFloat(true);
        navigation.setCanPassDoors(true);
        return navigation;
    }

    @Override
    @Nullable
    public SoundEvent getMusic() {
        return (SoundEvent)AoASounds.NETHENGEIC_WITHER_MUSIC.get();
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return SoundEvents.CAMPFIRE_CRACKLE;
    }

    @Override
    @Nullable
    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)AoASounds.ENTITY_NETHENGEIC_BEAST_HURT.get();
    }

    @Override
    @Nullable
    protected SoundEvent getDeathSound() {
        return (SoundEvent)AoASounds.ENTITY_NETHENGEIC_BEAST_DEATH.get();
    }

    @Override
    protected void playStepSound(BlockPos pos, BlockState blockState) {
    }

    public boolean canSwimInFluidType(FluidType type) {
        return type != NeoForgeMod.EMPTY_TYPE.value();
    }

    @Override
    public List<ExtendedSensor<? extends AoABoss>> getSensors() {
        return ObjectArrayList.of((Object[])new ExtendedSensor[]{new AggroBasedNearbyPlayersSensor(), new NearbyLivingEntitySensor().setScanRate(entity -> 40), new HurtBySensor()});
    }

    @Override
    public BrainActivityGroup<AoABoss> getCoreTasks() {
        return BrainActivityGroup.coreTasks((Behavior[])new Behavior[]{new LookAtTarget(), new WalkOrRunToWalkTarget()});
    }

    @Override
    public BrainActivityGroup<AoABoss> getIdleTasks() {
        return BrainActivityGroup.idleTasks((Behavior[])new Behavior[]{new TargetOrRetaliate().useMemory(MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER).attackablePredicate(target -> DamageUtil.isAttackable(target) && !this.isAlliedTo((Entity)target)), new SetRandomHoverTarget().speedModifier(0.9f)});
    }

    public BrainActivityGroup<AoABoss> getFightTasks() {
        return BrainActivityGroup.fightTasks((Behavior[])new Behavior[]{new InvalidateAttackTarget().invalidateIf((entity, target) -> !DamageUtil.isAttackable(target) || this.distanceToSqr(target.position()) > Math.pow(this.getAttributeValue(Attributes.FOLLOW_RANGE), 2.0)), new SetAdditionalAttackTargets().withMemories(new MemoryModuleType[]{(MemoryModuleType)AoABrainMemories.SECOND_ATTACK_TARGET.get(), (MemoryModuleType)AoABrainMemories.THIRD_ATTACK_TARGET.get()}).allowDuplicateTargeting().whenTargeting((owner, memory, target) -> {
            if (memory == AoABrainMemories.SECOND_ATTACK_TARGET.get()) {
                SECOND_HEAD_TARGET.set((Entity)owner, target.getId());
            } else {
                THIRD_HEAD_TARGET.set((Entity)owner, target.getId());
            }
        }), new SetWalkTargetToAttackTarget().speedMod((entity, target) -> Float.valueOf(1.25f)).startCondition(entity -> this.hasAura() && !ATTACK_STATE.is((Entity)entity, 2)).stopIf(entity -> !this.hasAura()), new StayWithinDistanceOfAttackTarget().startCondition(entity -> !this.hasAura()).stopIf(entity -> this.hasAura()), new StrafeTarget().startCondition(entity -> !this.hasAura()).stopIf(entity -> this.hasAura()), new FirstApplicableBehaviour(new ExtendedBehaviour[]{new FireBombAttack(), new FlamethrowerAttack(), new OneRandomBehaviour(new Pair[]{Pair.of((Object)new AnimatableRangedAttack(this.getSwingWarmupTicks(0)).attackInterval(entity -> this.rand().randomNumberBetween(this.getSwingDurationTicks(0), this.getSwingDurationTicks(0) * 2)).attackRadius((float)((int)this.getAttributeValue(Attributes.FOLLOW_RANGE))).whenStarting(entity -> this.triggerAnim("Middle Head", "fireball")).whenStopping(entity -> BrainUtils.setForgettableMemory((LivingEntity)((NethengeicWitherEntity)entity), (MemoryModuleType)((MemoryModuleType)SBLMemoryTypes.SPECIAL_ATTACK_COOLDOWN.get()), (Object)true, (int)21)), (Object)10), Pair.of((Object)new CustomDelayedBehaviour(20).whenActivating(entity -> this.toggleAura()).cooldownFor(entity -> entity.getRandom().nextIntBetweenInclusive(400, 800)).whenStarting(entity -> {
            this.triggerAnim("Middle Head", "fire_aura");
            entity.playSound((SoundEvent)AoASounds.ENTITY_NETHENGEIC_BEAST_FLAME_AURA_ACTIVATE.get(), 2.0f, 1.0f);
        }), (Object)1)}).startCondition(entity -> !BrainUtils.hasMemory((LivingEntity)entity, (MemoryModuleType)((MemoryModuleType)SBLMemoryTypes.SPECIAL_ATTACK_COOLDOWN.get())))})});
    }

    public Map<Activity, BrainActivityGroup<? extends AoABoss>> getAdditionalTasks() {
        return Map.of((Activity)AoABrainActivities.FIGHT_2.get(), new BrainActivityGroup((Activity)AoABrainActivities.FIGHT_2.get()).priority(11).behaviours(new Behavior[]{new InvalidateMemory((MemoryModuleType)AoABrainMemories.SECOND_ATTACK_TARGET.get()).invalidateIf((entity, target) -> {
            if (!DamageUtil.isAttackable(target) || target.distanceToSqr((Entity)entity) > Math.pow((int)this.getAttributeValue(Attributes.FOLLOW_RANGE), 2.0)) {
                SECOND_HEAD_TARGET.set((Entity)entity, -1);
                return true;
            }
            return false;
        }), new CustomDelayedBehaviour(this.getSwingWarmupTicks(0)).whenActivating(entity -> {
            LivingEntity target = (LivingEntity)BrainUtils.getMemory((LivingEntity)entity, (MemoryModuleType)((MemoryModuleType)AoABrainMemories.THIRD_ATTACK_TARGET.get()));
            if (target != null) {
                this.doFireball(PositionAndMotionUtil.moveRelativeToFacing(entity.getEyePosition(), entity.getYRot(), -1.25, 0.0, -0.25), target);
            }
        }).cooldownFor(entity -> this.rand().randomNumberBetween(this.getSwingDurationTicks(0) * (ATTACK_STATE.is((Entity)entity, 2) ? 6 : 3), this.getSwingDurationTicks(0) * (ATTACK_STATE.is((Entity)entity, 2) ? 10 : 5))).whenStarting(entity -> this.triggerAnim("Left Head", "fireball")).startCondition(entity -> BrainUtils.hasMemory((LivingEntity)entity, (MemoryModuleType)((MemoryModuleType)AoABrainMemories.SECOND_ATTACK_TARGET.get())))}).requireAndWipeMemoriesOnUse(new MemoryModuleType[]{(MemoryModuleType)AoABrainMemories.SECOND_ATTACK_TARGET.get()}), (Activity)AoABrainActivities.FIGHT_3.get(), new BrainActivityGroup((Activity)AoABrainActivities.FIGHT_3.get()).priority(12).behaviours(new Behavior[]{new InvalidateMemory((MemoryModuleType)AoABrainMemories.THIRD_ATTACK_TARGET.get()).invalidateIf((entity, target) -> {
            if (!DamageUtil.isAttackable(target) || target.distanceToSqr((Entity)entity) > Math.pow((int)this.getAttributeValue(Attributes.FOLLOW_RANGE), 2.0)) {
                THIRD_HEAD_TARGET.set((Entity)entity, -1);
                return true;
            }
            return false;
        }), new CustomDelayedBehaviour(this.getSwingWarmupTicks(0)).whenActivating(entity -> {
            LivingEntity target = (LivingEntity)BrainUtils.getMemory((LivingEntity)entity, (MemoryModuleType)((MemoryModuleType)AoABrainMemories.THIRD_ATTACK_TARGET.get()));
            if (target != null) {
                this.doFireball(PositionAndMotionUtil.moveRelativeToFacing(entity.getEyePosition(), entity.getYRot(), 1.25, -0.5, -0.25), target);
            }
        }).cooldownFor(entity -> this.rand().randomNumberBetween(this.getSwingDurationTicks(0) * (ATTACK_STATE.is((Entity)entity, 2) ? 6 : 3), this.getSwingDurationTicks(0) * (ATTACK_STATE.is((Entity)entity, 2) ? 10 : 5))).whenStarting(entity -> this.triggerAnim("Right Head", "fireball")).startCondition(entity -> BrainUtils.hasMemory((LivingEntity)entity, (MemoryModuleType)((MemoryModuleType)AoABrainMemories.THIRD_ATTACK_TARGET.get())))}).requireAndWipeMemoriesOnUse(new MemoryModuleType[]{(MemoryModuleType)AoABrainMemories.THIRD_ATTACK_TARGET.get()}));
    }

    public Set<Activity> getAlwaysRunningActivities() {
        return ImmutableSet.of((Object)Activity.CORE, (Object)((Activity)AoABrainActivities.FIGHT_2.get()), (Object)((Activity)AoABrainActivities.FIGHT_3.get()));
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (this.getHealth() / this.getMaxHealth() <= 0.5f) {
            this.doneFireBomb = true;
        }
    }

    private void doFireball(@Nullable Vec3 startPos, LivingEntity target) {
        FireballEntity projectile = new FireballEntity(this.level(), this, BaseMobProjectile.Type.PHYSICAL);
        if (startPos != null) {
            projectile.setPos(startPos);
        }
        projectile.setYRot(this.getYHeadRot());
        PositionAndMotionUtil.moveRelativeToFacing((Entity)projectile, 0.0, 1.0, 0.0);
        PositionAndMotionUtil.moveTowards((Entity)projectile, target.getEyePosition(), 1.6, 4 - this.level().getDifficulty().getId());
        projectile.setDeltaMovement(PositionAndMotionUtil.accountForGravity(projectile.position(), projectile.getDeltaMovement(), target.position(), projectile.getGravity()));
        PositionAndMotionUtil.faceTowardsMotion((Entity)projectile);
        this.playSound(SoundEvents.BLAZE_SHOOT, 1.0f, 1.0f);
        this.level().addFreshEntity((Entity)projectile);
    }

    public void performRangedAttack(LivingEntity target, float velocity) {
        this.doFireball(null, target);
    }

    @Override
    public void doRangedAttackEntity(@Nullable BaseMobProjectile projectile, Entity target) {
        if (projectile == null) {
            DamageUtil.safelyDealDamage(DamageUtil.positionedEntityDamage(AoADamageTypes.MOB_FLAMETHROWER, (Entity)this, this.position()), target, 1.0f);
            if (RandomUtil.oneInNChance((int)4) && target.getRemainingFireTicks() < 300) {
                target.igniteForSeconds((float)((int)Math.ceil((float)Math.max(0, target.getRemainingFireTicks()) / 20.0f) + 1));
            }
            if (RandomUtil.oneInNChance((int)4) && target instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)target;
                livingEntity.addEffect(new MobEffectInstance(MobEffects.WITHER, 100, 0));
            }
        } else {
            float dmg = (float)this.getAttributeValue((Holder)AoAAttributes.RANGED_ATTACK_DAMAGE);
            if (ATTACK_STATE.is((Entity)this, 2)) {
                dmg *= 1.5f;
            }
            if (DamageUtil.doProjectileAttack((Entity)this, (Entity)projectile, target, dmg)) {
                target.igniteForSeconds((float)((int)Math.ceil((float)Math.max(0, target.getRemainingFireTicks()) / 20.0f) + 3));
                if (target instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)target;
                    livingEntity.addEffect(new MobEffectInstance(AoAMobEffects.NETHENGEIC_CURSE, 200, this.level().getDifficulty().getId() - 1));
                }
            }
        }
    }

    @Override
    public void doRangedAttackBlock(@Nullable BaseMobProjectile projectile, BlockState blockHit, BlockPos pos, Direction sideHit) {
        if (projectile == null) {
            return;
        }
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            new StandardExplosion(AoAExplosions.NETHENGEIC_WITHER_FIREBALL, serverLevel, (Entity)projectile, (Entity)this).explode();
        }
    }

    @Override
    public boolean hurt(DamageSource source, float amount) {
        if (this.hasAura()) {
            if (DamageUtil.isMeleeDamage(source)) {
                Entity entity = source.getDirectEntity();
                if (entity instanceof LivingEntity) {
                    LivingEntity attacker = (LivingEntity)entity;
                    DamageUtil.safelyDealDamage(DamageUtil.entityDamage(AoADamageTypes.MOB_FIRE_RECOIL, (Entity)this), (Entity)attacker, 5.0f);
                    attacker.igniteForSeconds((float)((int)Math.ceil((float)Math.max(0, attacker.getRemainingFireTicks()) / 20.0f) + 2));
                    attacker.addEffect(new MobEffectInstance(AoAMobEffects.NETHENGEIC_CURSE, 200, 2));
                }
            } else if (DamageUtil.isEnergyDamage(source)) {
                this.heal(amount);
                return false;
            }
        }
        return super.hurt(source, amount);
    }

    public boolean canBeAffected(MobEffectInstance effect) {
        return effect.getEffect() != MobEffects.WITHER && effect.getEffect() != AoAMobEffects.NETHENGEIC_CURSE.get() && super.canBeAffected(effect);
    }

    protected void checkFallDamage(double pY, boolean pOnGround, BlockState pState, BlockPos pPos) {
    }

    protected void spawnSprintParticle() {
    }

    public boolean hasAura() {
        return FLAME_AURA.is((Entity)this, true);
    }

    public void toggleAura() {
        FLAME_AURA.set((Entity)this, FLAME_AURA.get((Entity)this) == false);
    }

    public void aiStep() {
        super.aiStep();
        if (this.level().isClientSide()) {
            if (this.hasAura()) {
                for (int i = 0; i < 3; ++i) {
                    double cos = Math.cos(this.getX() * RandomUtil.randomValueBetween((double)-1.0, (double)1.0));
                    double sin = Math.sin(this.getZ() * RandomUtil.randomValueBetween((double)-1.0, (double)1.0));
                    double startX = cos * (double)this.getBbWidth() + this.getX();
                    double startZ = sin * (double)this.getBbWidth() + this.getZ();
                    double startY = this.getRandomY();
                    ParticleBuilder.forPosition((ParticleOptions)EntityTrackingParticleOptions.fromEntity(AoAParticleTypes.FIRE_AURA, (Entity)this), (double)startX, (double)startY, (double)startZ).scaleMod(0.25f).colourOverride(1.0f, 1.0f, 1.0f, 0.75f).velocity(RandomUtil.fiftyFifty() ? -1.0 : 1.0, RandomUtil.fiftyFifty() ? -1.0 : 1.0, RandomUtil.fiftyFifty() ? -1.0 : 1.0).spawnParticles(this.level());
                }
            }
            ParticleBuilder.forPosition((ParticleOptions)ParticleTypes.FLAME, (double)(this.getX() + RandomUtil.randomValueBetween((double)-0.2f, (double)0.2f)), (double)(this.getEyeY() - 1.0 + RandomUtil.randomValueBetween((double)-0.2f, (double)0.2f)), (double)(this.getZ() + RandomUtil.randomValueBetween((double)-0.2f, (double)0.2f))).spawnParticles(this.level());
            if (this.getRandom().nextInt(10) == 0) {
                ParticleBuilder.forPosition((ParticleOptions)ParticleTypes.SMOKE, (double)this.getX(), (double)(this.getEyeY() - 1.0), (double)this.getZ()).spawnParticles(this.level());
                if (this.getDeltaMovement().horizontalDistanceSqr() == 0.0) {
                    ParticleBuilder.forPosition((ParticleOptions)ParticleTypes.DRIPPING_LAVA, (double)this.getX(), (double)(this.getEyeY() - 1.0), (double)this.getZ()).spawnParticles(this.level());
                }
            }
        } else if (this.hasAura() && BrainUtils.getTargetOfEntity((LivingEntity)this) == null) {
            this.toggleAura();
        }
    }

    public static AoAEntityStats.AttributeBuilder entityStats(EntityType<NethengeicWitherEntity> entityType) {
        return AoAEntityStats.AttributeBuilder.createMonster(entityType).health(420.0).moveSpeed(0.31).flyingSpeed(0.6).projectileDamage(6.0).knockbackResist(1.0).followRange(100.0).aggroRange(64.0).knockback(1.0);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "living", 0, state -> {
            if (ATTACK_STATE.is((Entity)this, 2)) {
                state.getController().setAnimationSpeed(1.0);
                return state.setAndContinue(CORE_SPIN_ANIM);
            }
            state.getController().setAnimationSpeed((double)(1.0f + (1.0f - this.getHealth() / this.getMaxHealth()) * 5.0f));
            state.getController().setAnimation(DefaultAnimations.LIVING);
            return PlayState.CONTINUE;
        }));
        controllers.add(new AnimationController((GeoAnimatable)this, "Walk/Idle", 0, state -> {
            if (ATTACK_STATE.is((Entity)this, 2)) {
                return state.setAndContinue(FIRE_BOMB_ANIM);
            }
            return state.setAndContinue(state.isMoving() ? DefaultAnimations.WALK : DefaultAnimations.IDLE);
        }));
        controllers.add(new AnimationController((GeoAnimatable)this, "Middle Head", 0, state -> {
            if (ATTACK_STATE.is((Entity)this, 1)) {
                state.setAndContinue(FLAMETHROWER_ANIM);
            }
            return PlayState.STOP;
        }).triggerableAnim("fireball", RawAnimation.begin().thenPlay("attack.fireball.center")).triggerableAnim("fire_aura", RawAnimation.begin().thenPlay("misc.fire_aura")));
        controllers.add(new AnimationController((GeoAnimatable)this, "Left Head", 0, state -> PlayState.STOP).triggerableAnim("fireball", RawAnimation.begin().thenPlay("attack.fireball.left")));
        controllers.add(new AnimationController((GeoAnimatable)this, "Right Head", 0, state -> PlayState.STOP).triggerableAnim("fireball", RawAnimation.begin().thenPlay("attack.fireball.right")));
    }

    private static class FireBombAttack
    extends ConditionlessHeldAttack<NethengeicWitherEntity> {
        private final List<FireballEntity> fireballs = new ObjectArrayList();

        public FireBombAttack() {
            this.runFor(entity -> 280);
            this.onTick(entity -> {
                if (this.runningTime >= 20 && !entity.hasAura()) {
                    entity.toggleAura();
                }
                entity.setDeltaMovement(this.target.position().subtract(entity.position()).normalize().multiply(0.0, 0.5, 0.0).add(0.0, Math.cos(entity.tickCount) * (double)0.05f, 0.0));
                if (this.runningTime % 20 == 0) {
                    if (!this.fireballs.isEmpty()) {
                        for (FireballEntity fireball : this.fireballs) {
                            Vec3 angle = fireball.position().subtract(entity.position()).multiply(1.0, 0.0, 1.0).normalize();
                            fireball.setYRot((float)Math.atan2(angle.z, angle.y));
                            PositionAndMotionUtil.moveTowards((Entity)fireball, fireball.position().add(angle.multiply(10.0, 10.0, 10.0)), 1.4, 4 - entity.level().getDifficulty().getId());
                            PositionAndMotionUtil.faceTowardsMotion((Entity)fireball);
                        }
                        entity.playSound(SoundEvents.BLAZE_SHOOT, 1.0f, 1.0f);
                        this.fireballs.clear();
                    }
                    for (double angle = RandomUtil.randomValueBetween((double)-45.0, (double)45.0) * 0.01745329238474369; angle <= 6.2831854820251465; angle += 0.7853981852531433) {
                        for (double offsetY = -2.0; offsetY <= 2.0; offsetY += 1.0) {
                            FireballEntity projectile = new FireballEntity(entity.level(), (AoARangedAttacker)entity, BaseMobProjectile.Type.PHYSICAL);
                            double xAngle = Math.cos(angle);
                            double zAngle = Math.sin(angle);
                            projectile.setPos(entity.position().add(2.0 * xAngle, (double)(entity.getBbHeight() / 2.0f) + offsetY, 2.0 * zAngle));
                            projectile.setDeltaMovement(0.0, -0.01f, 0.0);
                            entity.level().addFreshEntity((Entity)projectile);
                            this.fireballs.add(projectile);
                        }
                    }
                }
                return true;
            });
            this.startCondition(entity -> {
                if (entity.doneFireBomb || entity.getHealth() > entity.getMaxHealth() / 2.0f || entity.hasAura()) {
                    return false;
                }
                LivingEntity target = (LivingEntity)BrainUtils.getMemory((LivingEntity)entity, (MemoryModuleType)MemoryModuleType.ATTACK_TARGET);
                return target != null && target.isAlive();
            });
            this.stopIf(entity -> {
                this.target = (LivingEntity)BrainUtils.getMemory((LivingEntity)entity, (MemoryModuleType)MemoryModuleType.ATTACK_TARGET);
                return this.target == null;
            });
            this.whenStarting(entity -> {
                entity.triggerAnim("Middle Head", "fire_aura");
                entity.getNavigation().stop();
                entity.setXxa(0.0f);
                entity.setYya(0.0f);
                entity.setZza(0.0f);
                entity.setDeltaMovement(Vec3.ZERO);
                BrainUtils.clearMemory((LivingEntity)entity, (MemoryModuleType)MemoryModuleType.PATH);
                AoAMonster.ATTACK_STATE.set((Entity)entity, 2);
            });
            this.whenStopping(entity -> {
                entity.doneFireBomb = true;
                AoAMonster.ATTACK_STATE.set((Entity)entity, 0);
                entity.triggerAnim("Middle Head", "fire_aura");
                BrainUtils.setForgettableMemory((LivingEntity)entity, (MemoryModuleType)((MemoryModuleType)SBLMemoryTypes.SPECIAL_ATTACK_COOLDOWN.get()), (Object)true, (int)25);
                if (!this.fireballs.isEmpty()) {
                    for (FireballEntity fireball : this.fireballs) {
                        Vec3 angle = fireball.position().subtract(entity.position()).normalize();
                        fireball.setYRot((float)Math.atan2(angle.z, angle.y));
                        PositionAndMotionUtil.moveTowards((Entity)fireball, fireball.position().add(angle.multiply(10.0, 10.0, 10.0)), 1.2, 4 - entity.level().getDifficulty().getId());
                        PositionAndMotionUtil.faceTowardsMotion((Entity)fireball);
                    }
                    entity.playSound(SoundEvents.BLAZE_SHOOT, 1.0f, 1.0f);
                    this.fireballs.clear();
                }
                if (entity.hasAura()) {
                    entity.toggleAura();
                }
            });
        }
    }

    private static class FlamethrowerAttack
    extends ConditionlessHeldAttack<NethengeicWitherEntity> {
        public FlamethrowerAttack() {
            this.runFor(entity -> RandomUtil.randomNumberBetween((int)160, (int)240));
            this.requiresTarget();
            this.onTick(entity -> {
                Vec3 position = PositionAndMotionUtil.moveRelativeToFacing(entity.getEyePosition(), entity.getYRot(), 0.0, 1.0, 0.0);
                double baseX = position.x;
                double baseY = position.y;
                double baseZ = position.z;
                TELParticlePacket packet = new TELParticlePacket(new ParticleBuilder[]{ParticleBuilder.forPosition((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)baseX, (double)baseY, (double)baseZ)});
                for (int i = 0; i < 5; ++i) {
                    Vec3 velocity = this.target.getEyePosition().subtract(baseX + RandomUtil.randomScaledGaussianValue((double)0.5), baseY + RandomUtil.randomScaledGaussianValue((double)0.5), baseZ + RandomUtil.randomScaledGaussianValue((double)0.5)).normalize().scale(0.75);
                    packet.particle(ParticleBuilder.forPosition((ParticleOptions)EntityTrackingParticleOptions.fromEntity(AoAParticleTypes.BURNING_FLAME, (Entity)entity), (double)baseX, (double)baseY, (double)baseZ).colourOverride(0.0f, 0.0f, 0.0f, 0.0f).scaleMod(0.35f).velocity(velocity));
                    packet.particle(ParticleBuilder.forPosition((ParticleOptions)(RandomUtil.fiftyFifty() ? ParticleTypes.SMALL_FLAME : ParticleTypes.SQUID_INK), (double)baseX, (double)baseY, (double)baseZ).velocity(velocity));
                }
                packet.sendToAllNearbyPlayers((ServerLevel)entity.level(), EntityUtil.getEntityCenter((Entity)entity), 64.0);
                if (this.getRunningTime() % 9 == 0 || this.getRunningTime() % 19 == 0) {
                    entity.playSound((SoundEvent)AoASounds.FLAMETHROWER.get(), 2.0f, 1.0f);
                }
                return true;
            });
            this.startCondition(entity -> {
                if (!entity.hasAura()) {
                    return false;
                }
                LivingEntity target = (LivingEntity)BrainUtils.getMemory((LivingEntity)entity, (MemoryModuleType)MemoryModuleType.ATTACK_TARGET);
                return target != null && target.isAlive();
            });
            this.stopIf(entity -> {
                LivingEntity target = (LivingEntity)BrainUtils.getMemory((LivingEntity)entity, (MemoryModuleType)MemoryModuleType.ATTACK_TARGET);
                return target == null || !target.isAlive();
            });
            this.whenStarting(entity -> AoAMonster.ATTACK_STATE.set((Entity)entity, 1));
            this.whenStopping(entity -> {
                AoAMonster.ATTACK_STATE.set((Entity)entity, 0);
                if (entity.hasAura()) {
                    entity.toggleAura();
                }
                BrainUtils.setForgettableMemory((LivingEntity)entity, (MemoryModuleType)((MemoryModuleType)SBLMemoryTypes.SPECIAL_ATTACK_COOLDOWN.get()), (Object)true, (int)30);
            });
        }
    }
}

