/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.base;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.common.registration.AoAAttributes;
import net.tslat.aoa3.content.entity.ai.movehelper.RoamingSwimmingMovementController;
import net.tslat.aoa3.content.entity.base.AoARangedAttacker;
import net.tslat.aoa3.content.entity.projectile.mob.BaseMobProjectile;
import net.tslat.aoa3.util.DamageUtil;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class AoAWaterRangedMob
extends WaterAnimal
implements RangedAttackMob,
AoARangedAttacker,
Enemy,
GeoEntity {
    protected static final EntityDataAccessor<Boolean> INVULNERABLE = SynchedEntityData.defineId(AoAWaterRangedMob.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    protected AoAWaterRangedMob(EntityType<? extends WaterAnimal> entityType, Level world) {
        super(entityType, world);
        this.moveControl = new RoamingSwimmingMovementController((PathfinderMob)this);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(2, (Goal)new RangedAttackGoal((RangedAttackMob)this, 1.0, 20, 40, 32.0f));
        this.goalSelector.addGoal(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(6, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 30));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(INVULNERABLE, (Object)false);
    }

    protected PathNavigation createNavigation(Level world) {
        return new WaterBoundPathNavigation((Mob)this, world);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData) {
        this.xpReward = reason == MobSpawnType.MOB_SUMMONED ? 0 : (int)(5.0 + (this.getAttributeValue(Attributes.MAX_HEALTH) + this.getAttributeValue(Attributes.ARMOR) * 1.75 + this.getAttributeValue((Holder)AoAAttributes.RANGED_ATTACK_DAMAGE) * 2.0) / 10.0);
        return super.finalizeSpawn(world, difficulty, reason, spawnData);
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return null;
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource source) {
        return null;
    }

    protected void playStepSound(BlockPos pos, BlockState groundBlock) {
    }

    @Nullable
    protected abstract SoundEvent getShootSound();

    protected abstract BaseMobProjectile getNewProjectileInstance();

    protected void onAttack(Entity target) {
    }

    protected void onHit(DamageSource source, float amount) {
    }

    public void setInvulnerable(boolean isInvulnerable) {
        super.setInvulnerable(isInvulnerable);
        this.getEntityData().set(INVULNERABLE, (Object)isInvulnerable);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
        if (key.equals(INVULNERABLE)) {
            this.setInvulnerable((Boolean)this.getEntityData().get(INVULNERABLE));
        }
    }

    public void load(CompoundTag compound) {
        super.load(compound);
        this.setInvulnerable(this.isInvulnerable());
    }

    public boolean doHurtTarget(Entity target) {
        if (super.doHurtTarget(target)) {
            this.onAttack(target);
            return true;
        }
        return false;
    }

    public boolean hurt(DamageSource source, float amount) {
        if (super.hurt(source, amount)) {
            this.onHit(source, amount);
            return true;
        }
        return false;
    }

    protected boolean shouldDropLoot() {
        return super.shouldDropLoot() && this.xpReward > 0;
    }

    public boolean checkSpawnRules(LevelAccessor level, MobSpawnType spawnReason) {
        return true;
    }

    @Override
    public void doRangedAttackEntity(BaseMobProjectile projectile, Entity target) {
        boolean success;
        switch (projectile.getProjectileType()) {
            default: {
                throw new MatchException(null, null);
            }
            case MAGIC: {
                boolean bl = DamageUtil.doMagicProjectileAttack((Entity)this, (Entity)projectile, target, (float)this.getAttributeValue((Holder)AoAAttributes.RANGED_ATTACK_DAMAGE));
                break;
            }
            case GUN: {
                boolean bl = DamageUtil.doGunAttack((Entity)this, (Entity)projectile, target, source -> Float.valueOf((float)this.getAttributeValue((Holder)AoAAttributes.RANGED_ATTACK_DAMAGE)));
                break;
            }
            case PHYSICAL: {
                boolean bl = DamageUtil.doProjectileAttack((Entity)this, (Entity)projectile, target, (float)this.getAttributeValue((Holder)AoAAttributes.RANGED_ATTACK_DAMAGE));
                break;
            }
            case ENERGY: {
                boolean bl = success = DamageUtil.doEnergyProjectileAttack((Entity)this, (Entity)projectile, target, (float)this.getAttributeValue((Holder)AoAAttributes.RANGED_ATTACK_DAMAGE));
            }
        }
        if (success) {
            this.doProjectileImpactEffect(projectile, target);
        }
    }

    @Override
    public void doRangedAttackBlock(BaseMobProjectile projectile, BlockState blockHit, BlockPos pos, Direction sideHit) {
    }

    public void doProjectileImpactEffect(BaseMobProjectile projectile, Entity target) {
    }

    public void performRangedAttack(LivingEntity target, float distanceFactor) {
        BaseMobProjectile projectile = this.getNewProjectileInstance();
        double distanceFactorX = target.getX() - this.getX();
        double distanceFactorY = target.getBoundingBox().minY + (double)(target.getBbHeight() / 3.0f) - projectile.getY();
        double distanceFactorZ = target.getZ() - this.getZ();
        double hyp = Math.sqrt(distanceFactorX * distanceFactorX + distanceFactorZ * distanceFactorZ) + 0.2;
        if (this.getShootSound() != null) {
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), this.getShootSound(), SoundSource.HOSTILE, 1.0f, 1.0f);
        }
        projectile.shoot(distanceFactorX, distanceFactorY + hyp * (double)0.2f, distanceFactorZ, 1.6f, 4 - this.level().getDifficulty().getId());
        this.level().addFreshEntity((Entity)projectile);
    }

    public void aiStep() {
        this.updateSwingTime();
        super.aiStep();
    }

    public void travel(Vec3 motion) {
        if (this.isEffectiveAi() && this.isInWater()) {
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
            if (this.getTarget() == null) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.001, 0.0));
            }
        } else {
            super.travel(motion);
        }
    }

    protected boolean shouldDespawnInPeaceful() {
        return true;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }
}

