/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.base;

import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.tslat.aoa3.content.entity.base.AoAWaterMonster;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.MathUtil;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.behaviour.custom.attack.AnimatableMeleeAttack;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;

public abstract class AoAWaterMeleeMob<T extends AoAWaterMeleeMob<T>>
extends AoAWaterMonster<T> {
    protected double attackReach = (double)this.getBbWidth() * 1.75 + (double)(this.getAttackVectorPositionOffset() * 0.3f) + (double)this.getEyeHeight() / 3.6 * 0.25;

    protected AoAWaterMeleeMob(EntityType<? extends AoAWaterMeleeMob> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    public int calculateKillXp() {
        return !this.hasDrops ? 0 : (int)(8.0 + (this.getAttributeValue(Attributes.MAX_HEALTH) + this.getAttributeValue(Attributes.ARMOR) * 1.75 + this.getAttributeValue(Attributes.ARMOR_TOUGHNESS) * 1.5 + this.getAttributeValue(Attributes.ATTACK_DAMAGE) * 2.0) / 10.0);
    }

    public BrainActivityGroup<? extends T> getFightTasks() {
        return BrainActivityGroup.fightTasks((Behavior[])new Behavior[]{new InvalidateAttackTarget().invalidateIf((entity, target) -> !DamageUtil.isAttackable(target) || this.distanceToSqr(target.position()) > Math.pow(this.getAttributeValue(Attributes.FOLLOW_RANGE), 2.0)), new SetWalkTargetToAttackTarget(), new AnimatableMeleeAttack(this.getPreAttackTime()).attackInterval(entity -> this.getAttackSwingDuration() + 2)});
    }

    protected float getAttackVectorPositionOffset() {
        return 0.0f;
    }

    protected double getAttackReach() {
        return this.attackReach;
    }

    public boolean isWithinMeleeAttackRange(LivingEntity target) {
        AABB hitBounds = this.getAttackBoundingBox();
        if (!hitBounds.intersects(target.getHitbox())) {
            return false;
        }
        double reach = Math.max(hitBounds.getXsize(), hitBounds.getZsize()) / 2.0;
        return hitBounds.getCenter().distanceToSqr(target.position()) <= reach * reach;
    }

    protected AABB getAttackBoundingBox() {
        AABB boundingBox = this.getBoundingBox();
        double attackPositionOffset = (double)this.getAttackVectorPositionOffset() - boundingBox.getXsize();
        double reach = this.getAttackReach();
        if (this.getVehicle() != null) {
            AABB vehicleBounds = this.getVehicle().getBoundingBox();
            boundingBox = new AABB(Math.min(boundingBox.minX, vehicleBounds.minX), boundingBox.minY, Math.min(boundingBox.minZ, vehicleBounds.minZ), Math.max(boundingBox.maxX, vehicleBounds.maxX), boundingBox.maxY, Math.max(boundingBox.maxZ, vehicleBounds.maxZ));
        }
        if (attackPositionOffset > 0.0) {
            boundingBox.move(MathUtil.getBodyForward((LivingEntity)this).scale(attackPositionOffset));
        }
        return boundingBox.inflate(reach, 0.0, reach);
    }
}

