/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.base;

import com.mojang.serialization.Dynamic;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.neoforge.common.CommonHooks;
import net.tslat.aoa3.common.registration.entity.AoAProfessions;
import net.tslat.aoa3.content.entity.ai.trader.TraderFaceCustomerGoal;
import net.tslat.aoa3.content.entity.ai.trader.TraderPlayerTradeGoal;
import net.tslat.aoa3.content.entity.ai.trader.TraderRestockGoal;
import net.tslat.aoa3.util.WorldUtil;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class AoATrader
extends Villager
implements GeoEntity {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public AoATrader(EntityType<? extends AoATrader> entityType, Level world) {
        super(entityType, world);
        ((GroundPathNavigation)this.getNavigation()).setCanOpenDoors(true);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Monster.class, 8.0f, 0.8, 1.2));
        this.goalSelector.addGoal(1, (Goal)new TraderPlayerTradeGoal(this));
        this.goalSelector.addGoal(1, (Goal)new TraderFaceCustomerGoal(this));
        this.goalSelector.addGoal(2, (Goal)new OpenDoorGoal((Mob)this, true));
        this.goalSelector.addGoal(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.goalSelector.addGoal(3, (Goal)new TraderRestockGoal(this));
        this.goalSelector.addGoal(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.5));
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData) {
        SpawnGroupData data = super.finalizeSpawn(world, difficulty, reason, spawnData);
        this.setVillagerData(this.getVillagerData().setProfession((VillagerProfession)AoAProfessions.WANDERER.get()));
        return data;
    }

    public Brain<?> makeBrain(Dynamic<?> dynamic) {
        return this.brainProvider().makeBrain(dynamic);
    }

    public void refreshBrain(ServerLevel world) {
    }

    protected void ageBoundaryReached() {
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (itemStack.getItem() != Items.VILLAGER_SPAWN_EGG && this.isAlive() && !this.isTrading() && !this.isBaby()) {
            if (hand == InteractionHand.MAIN_HAND) {
                player.awardStat(Stats.TALKED_TO_VILLAGER);
            }
            if (!this.level().isClientSide && !this.getOffers().isEmpty()) {
                this.updateSpecialPrices(player);
                this.setTradingPlayer(player);
                this.openTradingScreen(player, this.getDisplayName(), this.getVillagerData().getLevel());
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        return InteractionResult.PASS;
    }

    protected void updateSpecialPrices(Player player) {
        int reputation = this.getPlayerReputation(player);
        if (reputation != 0) {
            for (MerchantOffer offer : this.getOffers()) {
                offer.addToSpecialPriceDiff(-Mth.floor((float)((float)reputation * offer.getPriceMultiplier())));
            }
        }
    }

    protected void updateTrades() {
        int professionLevel;
        VillagerTrades.ItemListing[] currentLevelOffers;
        Int2ObjectMap<VillagerTrades.ItemListing[]> trades = this.getTradesMap();
        if (trades != null && !trades.isEmpty() && (currentLevelOffers = (VillagerTrades.ItemListing[])trades.get(professionLevel = this.getVillagerData().getLevel())) != null) {
            this.addOffersFromItemListings(this.getOffers(), currentLevelOffers, this.getMaxTradesToUnlock(professionLevel));
        }
    }

    protected Component getTypeName() {
        return this.getType().getDescription();
    }

    public int getMaxTradesToUnlock(int newProfessionLevel) {
        return 2;
    }

    protected boolean isOverworldNPC() {
        return false;
    }

    public boolean canPickUpLoot() {
        return false;
    }

    public int getMaxSpawnClusterSize() {
        return 1;
    }

    public SoundEvent getNotifyTradeSound() {
        return null;
    }

    protected void rewardTradeXp(MerchantOffer offer) {
        int xp = 3 + this.random.nextInt(4);
        this.villagerXp += offer.getXp();
        this.lastTradedPlayer = this.getTradingPlayer();
        if (this.shouldIncreaseLevel()) {
            this.updateMerchantTimer = 40;
            this.increaseProfessionLevelOnUpdate = true;
            xp += 5;
        }
        xp = (int)((float)xp / ((float)offer.getMaxUses() / 16.0f));
        if (offer.shouldRewardExp()) {
            this.level().addFreshEntity((Entity)new ExperienceOrb(this.level(), this.getX(), this.getY() + 0.5, this.getZ(), xp));
        }
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return null;
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundEvents.GENERIC_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.GENERIC_DEATH;
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return !this.isOverworldNPC() || !WorldUtil.isWorld(this.level(), Level.OVERWORLD) || this.tickCount >= 48000;
    }

    public Villager getBreedOffspring(ServerLevel world, AgeableMob mate) {
        return null;
    }

    public void thunderHit(ServerLevel world, LightningBolt lightning) {
        this.setRemainingFireTicks(this.getRemainingFireTicks() + 1);
        if (this.getRemainingFireTicks() == 0) {
            this.igniteForSeconds(8.0f);
        }
        this.hurt(this.level().damageSources().lightningBolt(), 5.0f);
    }

    public void die(DamageSource source) {
        if (CommonHooks.onLivingDeath((LivingEntity)this, (DamageSource)source)) {
            return;
        }
        if (!this.isRemoved() && !this.dead) {
            Entity attacker = source.getEntity();
            LivingEntity killer = this.getKillCredit();
            if (this.deathScore >= 0 && killer != null) {
                killer.awardKillScore((Entity)this, this.deathScore, source);
            }
            if (this.isSleeping()) {
                this.stopSleeping();
            }
            this.dead = true;
            this.getCombatTracker().recheckStatus();
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverlevel = (ServerLevel)level;
                if (attacker == null || attacker.killedEntity(serverlevel, (LivingEntity)this)) {
                    this.gameEvent((Holder)GameEvent.ENTITY_DIE);
                    this.dropAllDeathLoot(serverlevel, source);
                    this.createWitherRose(killer);
                }
                this.level().broadcastEntityEvent((Entity)this, (byte)3);
            }
            this.setPose(Pose.DYING);
        }
        this.stopTrading();
    }

    @Nullable
    public abstract Int2ObjectMap<VillagerTrades.ItemListing[]> getTradesMap();

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    public static class BuildableTrade
    implements VillagerTrades.ItemListing {
        private final Supplier<ItemStack> item;
        private Supplier<ItemCost> cost1 = null;
        @Nullable
        private Supplier<ItemCost> cost2 = null;
        private int xpValue = 2;
        private float priceMultiplier = 0.05f;
        private int maxUses = 16;
        private boolean isLocked = false;

        private BuildableTrade(Supplier<ItemStack> item) {
            this.item = item;
        }

        public static BuildableTrade forItem(ItemLike item) {
            return new BuildableTrade(() -> item.asItem().getDefaultInstance());
        }

        public static BuildableTrade forItem(ItemLike item, int amount) {
            return new BuildableTrade(() -> new ItemStack(item, amount));
        }

        public static BuildableTrade forStack(Supplier<ItemStack> stack) {
            return new BuildableTrade(stack);
        }

        public BuildableTrade locked() {
            this.isLocked = true;
            this.maxUses = 0;
            return this;
        }

        public BuildableTrade itemCost(ItemLike item) {
            return this.itemCost(item, 1);
        }

        public BuildableTrade itemCost(ItemLike item, int amount) {
            return this.stackCost(() -> new ItemStack(item, amount));
        }

        public BuildableTrade itemCost(Supplier<ItemLike> item) {
            return this.stackCost(() -> ((ItemLike)item.get()).asItem().getDefaultInstance());
        }

        public BuildableTrade stackCost(Supplier<ItemStack> cost) {
            if (this.cost1 == null) {
                this.cost1 = () -> {
                    ItemStack baseCost = (ItemStack)cost.get();
                    return new ItemCost((ItemLike)baseCost.getItem(), baseCost.getCount());
                };
            } else if (this.cost2 == null) {
                this.cost2 = () -> {
                    ItemStack baseCost = (ItemStack)cost.get();
                    return new ItemCost((ItemLike)baseCost.getItem(), baseCost.getCount());
                };
            }
            return this;
        }

        public BuildableTrade xp(int tradeXp) {
            this.xpValue = tradeXp;
            return this;
        }

        public BuildableTrade priceMultiplier(float multiplier) {
            this.priceMultiplier = multiplier;
            return this;
        }

        public BuildableTrade stock(int stock) {
            this.maxUses = stock;
            return this;
        }

        @Nullable
        public MerchantOffer getOffer(Entity trader, RandomSource rand) {
            MerchantOffer offer;
            if (this.cost2 != null) {
                offer = new MerchantOffer(this.cost1.get(), Optional.of(this.cost2.get()), this.item.get(), this.maxUses, this.xpValue, this.priceMultiplier);
            } else if (this.cost1 != null) {
                offer = new MerchantOffer(this.cost1.get(), this.item.get(), this.maxUses, this.xpValue, this.priceMultiplier);
            } else {
                return null;
            }
            if (this.isLocked) {
                offer.setToOutOfStock();
            }
            return offer;
        }
    }

    public static class TradeListBuilder {
        private final HashMap<Integer, VillagerTrades.ItemListing[]> trades = new HashMap();

        public TradeListBuilder trades(int professionLevel, BuildableTrade ... offers) {
            this.trades.put(professionLevel, offers);
            return this;
        }

        public Int2ObjectMap<VillagerTrades.ItemListing[]> build() {
            return new Int2ObjectOpenHashMap(this.trades);
        }
    }
}

