/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.base;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.tslat.aoa3.common.registration.AoAAttributes;
import net.tslat.aoa3.content.entity.base.AoAMonster;
import net.tslat.aoa3.content.entity.base.AoARangedAttacker;
import net.tslat.aoa3.content.entity.projectile.mob.BaseMobProjectile;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.PositionAndMotionUtil;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.behaviour.custom.attack.AnimatableRangedAttack;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.StayWithinDistanceOfAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.StrafeTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;
import org.jetbrains.annotations.Nullable;

public abstract class AoARangedMob<T extends AoARangedMob<T>>
extends AoAMonster<T>
implements AoARangedAttacker {
    protected AoARangedMob(EntityType<? extends AoARangedMob> entityType, Level world) {
        super(entityType, world);
    }

    public BrainActivityGroup<T> getFightTasks() {
        return BrainActivityGroup.fightTasks((Behavior[])new Behavior[]{new InvalidateAttackTarget().invalidateIf((entity, target) -> !DamageUtil.isAttackable(target) || this.distanceToSqr(target.position()) > Math.pow(this.getAttributeValue(Attributes.FOLLOW_RANGE), 2.0)), this.isStrafingMob() ? new StrafeTarget() : new StayWithinDistanceOfAttackTarget(), new AnimatableRangedAttack(this.getPreAttackTime()).attackInterval(entity -> this.getAttackSwingDuration())});
    }

    @Override
    public int calculateKillXp() {
        return !this.hasDrops ? 0 : (int)(5.0 + (this.getAttributeValue(Attributes.MAX_HEALTH) + this.getAttributeValue(Attributes.ARMOR) * 1.75 + this.getAttributeValue(Attributes.ARMOR_TOUGHNESS) * 1.5 + this.getAttributeValue((Holder)AoAAttributes.RANGED_ATTACK_DAMAGE) * 2.0) / 10.0);
    }

    protected boolean isStrafingMob() {
        return false;
    }

    @Nullable
    protected abstract SoundEvent getShootSound();

    protected abstract BaseMobProjectile getNewProjectileInstance();

    @Override
    public void doRangedAttackEntity(@Nullable BaseMobProjectile projectile, Entity target) {
        if (projectile != null) {
            boolean success;
            switch (projectile.getProjectileType()) {
                default: {
                    throw new MatchException(null, null);
                }
                case MAGIC: {
                    boolean bl = DamageUtil.doMagicProjectileAttack((Entity)this, (Entity)projectile, target, (float)this.getAttributeValue((Holder)AoAAttributes.RANGED_ATTACK_DAMAGE));
                    break;
                }
                case GUN: {
                    boolean bl = DamageUtil.doGunAttack((Entity)this, (Entity)projectile, target, source -> Float.valueOf((float)this.getAttributeValue((Holder)AoAAttributes.RANGED_ATTACK_DAMAGE)));
                    break;
                }
                case PHYSICAL: {
                    boolean bl = DamageUtil.doProjectileAttack((Entity)this, (Entity)projectile, target, (float)this.getAttributeValue((Holder)AoAAttributes.RANGED_ATTACK_DAMAGE));
                    break;
                }
                case ENERGY: {
                    boolean bl = success = DamageUtil.doEnergyProjectileAttack((Entity)this, (Entity)projectile, target, (float)this.getAttributeValue((Holder)AoAAttributes.RANGED_ATTACK_DAMAGE));
                }
            }
            if (success) {
                this.onProjectileAttack(projectile, target);
            }
        }
    }

    @Override
    public void doRangedAttackBlock(@Nullable BaseMobProjectile projectile, BlockState blockHit, BlockPos pos, Direction sideHit) {
    }

    public void onProjectileAttack(@Nullable BaseMobProjectile projectile, Entity target) {
    }

    public void performRangedAttack(LivingEntity target, float distanceFactor) {
        BaseMobProjectile projectile = this.getNewProjectileInstance();
        projectile.setYRot(this.getYHeadRot());
        PositionAndMotionUtil.moveRelativeToFacing((Entity)projectile, 0.0, 0.0, 0.0);
        PositionAndMotionUtil.moveTowards((Entity)projectile, target.getEyePosition(), 1.6, 4 - this.level().getDifficulty().getId());
        projectile.setDeltaMovement(PositionAndMotionUtil.accountForGravity(projectile.position(), projectile.getDeltaMovement(), target.position(), projectile.getGravity()));
        PositionAndMotionUtil.faceTowardsMotion((Entity)projectile);
        if (this.getShootSound() != null) {
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), this.getShootSound(), SoundSource.HOSTILE, 1.0f, 1.0f);
        }
        this.level().addFreshEntity((Entity)projectile);
    }
}

