/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.base;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.tslat.aoa3.content.entity.ai.mob.FlyingLookRandomlyGoal;
import net.tslat.aoa3.content.entity.ai.mob.RandomFlyingGoal;
import net.tslat.aoa3.content.entity.ai.mob.TelegraphedMeleeAttackGoal;
import net.tslat.aoa3.content.entity.ai.movehelper.RoamingFlightMovementController;
import net.tslat.aoa3.util.PlayerUtil;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class AoAFlyingMeleeMob
extends FlyingMob
implements Enemy,
GeoEntity {
    protected static final EntityDataAccessor<Boolean> INVULNERABLE = SynchedEntityData.defineId(AoAFlyingMeleeMob.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    protected AoAFlyingMeleeMob(EntityType<? extends FlyingMob> entityType, Level world) {
        super(entityType, world);
        this.moveControl = new RoamingFlightMovementController((Mob)this);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new RandomFlyingGoal((Mob)this, true));
        this.goalSelector.addGoal(2, new TelegraphedMeleeAttackGoal<AoAFlyingMeleeMob>(this).preAttackTime(this.getPreAttackTime()).attackInterval(this.getCurrentSwingDuration()));
        this.goalSelector.addGoal(3, (Goal)new FlyingLookRandomlyGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, true, pl -> pl instanceof Player && PlayerUtil.shouldPlayerBeAffected((Player)pl)));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(INVULNERABLE, (Object)false);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData) {
        this.xpReward = reason == MobSpawnType.MOB_SUMMONED ? 0 : (int)(5.0 + (this.getAttributeValue(Attributes.MAX_HEALTH) + this.getAttributeValue(Attributes.ARMOR) * 1.75 + this.getAttributeValue(Attributes.ATTACK_DAMAGE) * 2.0) / 10.0);
        return super.finalizeSpawn(world, difficulty, reason, spawnData);
    }

    protected PathNavigation createNavigation(Level world) {
        return new FlyingPathNavigation((Mob)this, world);
    }

    public SoundSource getSoundSource() {
        return SoundSource.HOSTILE;
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return null;
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource source) {
        return null;
    }

    protected int getAttackSwingDuration() {
        return 6;
    }

    protected int getPreAttackTime() {
        return 0;
    }

    protected void onAttack(Entity target) {
    }

    protected void onHit(DamageSource source, float amount) {
    }

    public void setInvulnerable(boolean isInvulnerable) {
        super.setInvulnerable(isInvulnerable);
        this.getEntityData().set(INVULNERABLE, (Object)isInvulnerable);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
        if (key.equals(INVULNERABLE)) {
            this.setInvulnerable((Boolean)this.getEntityData().get(INVULNERABLE));
        }
    }

    public void load(CompoundTag compound) {
        super.load(compound);
        this.setInvulnerable(this.isInvulnerable());
    }

    public void aiStep() {
        this.updateSwingTime();
        super.aiStep();
    }

    public boolean doHurtTarget(Entity target) {
        if (super.doHurtTarget(target)) {
            this.onAttack(target);
            return true;
        }
        return false;
    }

    public boolean hurt(DamageSource source, float amount) {
        if (super.hurt(source, amount)) {
            this.onHit(source, amount);
            return true;
        }
        return false;
    }

    protected boolean shouldDropLoot() {
        return super.shouldDropLoot() && this.xpReward > 0;
    }

    public boolean isIgnoringBlockTriggers() {
        return true;
    }

    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.EVENTS;
    }

    protected boolean shouldDespawnInPeaceful() {
        return true;
    }

    protected void playStepSound(BlockPos pos, BlockState blockIn) {
    }

    public int getCurrentSwingDuration() {
        int time = this.getAttackSwingDuration();
        if (MobEffectUtil.hasDigSpeed((LivingEntity)this)) {
            time -= 1 + MobEffectUtil.getDigSpeedAmplification((LivingEntity)this);
        }
        if (this.hasEffect(MobEffects.DIG_SLOWDOWN)) {
            time += (1 + this.getEffect(MobEffects.DIG_SLOWDOWN).getAmplifier()) * 2;
        }
        return time;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }
}

