/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.base;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.DeferredSpawnEggItem;
import net.neoforged.neoforge.entity.PartEntity;
import net.tslat.aoa3.common.networking.AoANetworking;
import net.tslat.aoa3.common.networking.packets.MultipartTogglePacket;
import org.jetbrains.annotations.Nullable;

public class AoAEntityPart<T extends LivingEntity>
extends PartEntity<T> {
    private final Vec3 posOffset;
    private float damageMultiplier = 1.0f;
    private final EntityDimensions size;
    private boolean isEnabled = true;

    public AoAEntityPart(T parent, float width, float height, float offsetLeftRight, float offsetY, float offsetFrontBack) {
        super(parent);
        this.size = EntityDimensions.scalable((float)width, (float)height);
        this.posOffset = new Vec3((double)offsetLeftRight, (double)offsetY, (double)offsetFrontBack);
        this.setPos(parent.position().add((double)offsetLeftRight, (double)offsetY, (double)offsetFrontBack));
        this.refreshDimensions();
    }

    public AoAEntityPart<T> setDamageMultiplier(float multiplier) {
        this.damageMultiplier = multiplier;
        return this;
    }

    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
        this.setBoundingBox(this.isEnabled ? this.makeBoundingBox() : AABB.ofSize((Vec3)this.position(), (double)0.0, (double)0.0, (double)0.0));
        if (!this.level().isClientSide) {
            AoANetworking.sendToAllPlayersTrackingEntity(new MultipartTogglePacket(this.getId(), enabled), (Entity)this);
        }
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void updatePosition() {
        LivingEntity parent = (LivingEntity)this.getParent();
        Vec3 offset = this.posOffset.scale((double)this.getScale());
        double rot = Math.toRadians(-parent.yHeadRot);
        double cos = Math.cos(rot);
        double sin = Math.sin(rot);
        double xOffset = -cos * offset.x + sin * offset.z;
        double zOffset = sin * offset.x + cos * offset.z;
        this.setOldPosAndRot();
        this.setPos(parent.position().x + xOffset, parent.position().y + offset.y, parent.position().z + zOffset);
    }

    @Nullable
    public ItemStack getPickResult() {
        SpawnEggItem egg = DeferredSpawnEggItem.deferredOnlyById((EntityType)((LivingEntity)this.getParent()).getType());
        return egg == null ? null : egg.getDefaultInstance();
    }

    public boolean hurt(DamageSource source, float amount) {
        if (!this.isEnabled) {
            return false;
        }
        return !this.isInvulnerableTo(source) && ((LivingEntity)this.getParent()).hurt(source, amount * this.damageMultiplier);
    }

    public boolean isPickable() {
        return this.isEnabled;
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        if (!this.isEnabled) {
            return InteractionResult.PASS;
        }
        LivingEntity parent = (LivingEntity)this.getParent();
        if (parent != null) {
            return parent.interact(player, hand);
        }
        return super.interact(player, hand);
    }

    public InteractionResult interactAt(Player player, Vec3 position, InteractionHand hand) {
        if (!this.isEnabled) {
            return InteractionResult.PASS;
        }
        LivingEntity parent = (LivingEntity)this.getParent();
        if (parent != null) {
            return parent.interactAt(player, position, hand);
        }
        return super.interactAt(player, position, hand);
    }

    public boolean is(Entity entity) {
        return this == entity || this.getParent() == entity;
    }

    public EntityDimensions getDimensions(Pose pose) {
        return this.size.scale(this.getScale());
    }

    public float getScale() {
        return ((LivingEntity)this.getParent()).getScale();
    }

    public boolean shouldBeSaved() {
        return false;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        tag.putBoolean("IsEnabled", this.isEnabled);
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        if (tag.contains("IsEnabled", 1)) {
            this.isEnabled = tag.getBoolean("IsEnabled");
        }
    }
}

