/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.base;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.neoforge.common.CommonHooks;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.content.entity.base.AoAEntityPart;
import net.tslat.aoa3.content.entity.base.AoAMultipartEntity;
import net.tslat.aoa3.content.entity.brain.task.temp.FixedFollowParent;
import net.tslat.aoa3.library.object.EntityDataHolder;
import net.tslat.aoa3.scheduling.AoAScheduler;
import net.tslat.aoa3.util.AttributeUtil;
import net.tslat.smartbrainlib.api.SmartBrainOwner;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.SmartBrainProvider;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.FirstApplicableBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.OneRandomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.look.LookAtTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.BreedWithPartner;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Panic;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.FloatToSurfaceOfFluid;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.FollowTemptation;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.WalkOrRunToWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.HurtBySensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.ItemTemptingSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyLivingEntitySensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyPlayersSensor;
import net.tslat.smartbrainlib.util.RandomUtil;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class AoAAnimal<T extends AoAAnimal<T>>
extends Animal
implements GeoEntity,
SmartBrainOwner<T>,
AoAMultipartEntity {
    protected static final AttributeModifier BABY_HEALTH_MOD = new AttributeModifier(AdventOfAscension.id("baby_health_mod"), -0.5, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
    public static final EntityDataHolder<Boolean> IMMOBILE = EntityDataHolder.register(AoAAnimal.class, EntityDataSerializers.BOOLEAN, false, animal -> animal.immobile, (animal, value) -> {
        animal.immobile = value;
    });
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    protected AoAEntityPart<?>[] parts = new AoAEntityPart[0];
    private EntityDataHolder<?>[] dataParams;
    private boolean immobile = false;

    public AoAAnimal(EntityType<? extends Animal> entityType, Level world) {
        super(entityType, world);
        this.getNavigation().setCanFloat(true);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        for (EntityDataHolder<?> dataHolder : this.dataParams = new EntityDataHolder[]{IMMOBILE}) {
            dataHolder.defineDefault(builder);
        }
    }

    protected final void registerDataParams(SynchedEntityData.Builder builder, EntityDataHolder<?> ... params) {
        EntityDataHolder[] newArray = new EntityDataHolder[this.dataParams.length + params.length];
        System.arraycopy(this.dataParams, 0, newArray, 0, this.dataParams.length);
        System.arraycopy(params, 0, newArray, this.dataParams.length, params.length);
        for (EntityDataHolder<?> param : params) {
            param.defineDefault(builder);
        }
        this.dataParams = newArray;
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return null;
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource source) {
        return null;
    }

    @Nullable
    protected SoundEvent getStepSound(BlockPos pos, BlockState blockState) {
        return null;
    }

    protected void playStepSound(BlockPos pos, BlockState blockState) {
        if (!blockState.liquid()) {
            BlockState state = this.level().getBlockState(pos.above());
            SoundType blockSound = state.getBlock() == Blocks.SNOW ? state.getSoundType((LevelReader)this.level(), pos, (Entity)this) : blockState.getSoundType((LevelReader)this.level(), pos, (Entity)this);
            SoundEvent stepSound = blockSound.getStepSound();
            SoundEvent stepSoundOverlay = this.getStepSound(pos, blockState);
            this.playStepSounds(stepSound, stepSoundOverlay);
            if (this.isQuadruped() && !this.level().isClientSide) {
                AoAScheduler.scheduleSyncronisedTask(() -> this.playStepSounds(stepSound, stepSoundOverlay), 6);
            }
        }
    }

    private void playStepSounds(SoundEvent stepSound, @Nullable SoundEvent stepSoundOverlay) {
        float stepWeight = this.getStepWeight() - 1.0f;
        this.playSound(stepSound, 0.75f + stepWeight * 0.15f, 1.0f - stepWeight * 0.1f);
        if (stepSoundOverlay != null) {
            this.playSound(stepSoundOverlay, 0.75f + stepWeight * 0.15f, 1.0f - stepWeight * 0.1f);
        }
    }

    protected float nextStep() {
        return this.moveDist + 1.0f;
    }

    protected float getStepWeight() {
        return 1.0f;
    }

    protected boolean isQuadruped() {
        return false;
    }

    public int getAmbientSoundInterval() {
        return 240;
    }

    public final RandomUtil.EasyRandom rand() {
        return new RandomUtil.EasyRandom(this.getRandom());
    }

    protected Brain.Provider<? extends T> brainProvider() {
        return new SmartBrainProvider((LivingEntity)this);
    }

    public List<ExtendedSensor<? extends T>> getSensors() {
        return ObjectArrayList.of((Object[])new ExtendedSensor[]{new ItemTemptingSensor().temptedWith((entity, stack) -> this.isFood((ItemStack)stack)), new NearbyPlayersSensor(), new NearbyLivingEntitySensor().setScanRate(entity -> 40), new HurtBySensor()});
    }

    public BrainActivityGroup<? extends T> getCoreTasks() {
        return BrainActivityGroup.coreTasks((Behavior[])new Behavior[]{new LookAtTarget(), new WalkOrRunToWalkTarget().startCondition(entity -> !this.isDoingStationaryActivity()), new FloatToSurfaceOfFluid()});
    }

    public BrainActivityGroup<? extends T> getIdleTasks() {
        return BrainActivityGroup.idleTasks((Behavior[])new Behavior[]{new BreedWithPartner().startCondition(entity -> this.canBreed()), new FirstApplicableBehaviour(new ExtendedBehaviour[]{new FixedFollowParent(), new FollowTemptation().startCondition(entity -> this.getTemptationTag() != null), new OneRandomBehaviour(new ExtendedBehaviour[]{new SetRandomWalkTarget().speedModifier(0.9f), new Idle().runFor(entity -> entity.getRandom().nextInt(30, 60))})})});
    }

    public Map<Activity, BrainActivityGroup<? extends T>> getAdditionalTasks() {
        return Map.of(Activity.PANIC, new BrainActivityGroup(Activity.PANIC).behaviours(new Behavior[]{new Panic().setRadius(15.0, 10.0).speedMod(entity -> 1.5f)}).requireAndWipeMemoriesOnUse(new MemoryModuleType[]{MemoryModuleType.HURT_BY_ENTITY}));
    }

    public List<Activity> getActivityPriorities() {
        return ObjectArrayList.of((Object[])new Activity[]{Activity.FIGHT, Activity.PANIC, Activity.IDLE});
    }

    protected void customServerAiStep() {
        this.tickBrain((LivingEntity)this);
        if (!this.isBaby()) {
            AttributeUtil.removeModifier((LivingEntity)this, (Holder<Attribute>)Attributes.MAX_HEALTH, BABY_HEALTH_MOD);
        } else {
            AttributeUtil.applyPermanentModifier((LivingEntity)this, (Holder<Attribute>)Attributes.MAX_HEALTH, BABY_HEALTH_MOD, true);
        }
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData) {
        this.xpReward = this.calculateKillXp();
        if (reason == MobSpawnType.SPAWNER) {
            this.xpReward = (int)((double)this.xpReward * 0.5);
        }
        if (this.isBaby()) {
            AttributeUtil.applyPermanentModifier((LivingEntity)this, (Holder<Attribute>)Attributes.MAX_HEALTH, BABY_HEALTH_MOD);
        }
        return super.finalizeSpawn(world, difficulty, reason, spawnData);
    }

    public int calculateKillXp() {
        return (int)(this.getAttributeValue(Attributes.MAX_HEALTH) / 25.0);
    }

    public void setImmobile(boolean immobile) {
        IMMOBILE.set((Entity)this, immobile);
        if (this.immobile) {
            this.getNavigation().stop();
        }
    }

    public boolean isDoingStationaryActivity() {
        return this.immobile;
    }

    public boolean hurt(DamageSource source, float amount) {
        AbstractArrow arrow;
        AoAEntityPart<?>[] aoAEntityPartArray;
        if (this.parts.length > 0 && (aoAEntityPartArray = source.getDirectEntity()) instanceof AbstractArrow && (arrow = (AbstractArrow)aoAEntityPartArray).getPierceLevel() > 0) {
            if (arrow.piercingIgnoreEntityIds == null) {
                arrow.piercingIgnoreEntityIds = new IntOpenHashSet(5);
            }
            for (AoAEntityPart<?> part : this.parts) {
                arrow.piercingIgnoreEntityIds.add(part.getId());
            }
            arrow.piercingIgnoreEntityIds.add(this.getId());
        }
        return super.hurt(source, amount);
    }

    public boolean doHurtTarget(Entity target) {
        if (super.doHurtTarget(target)) {
            this.onAttack(target);
            return true;
        }
        return false;
    }

    public boolean canBreed() {
        return true;
    }

    protected void onAttack(Entity target) {
    }

    public void die(DamageSource source) {
        if (CommonHooks.onLivingDeath((LivingEntity)this, (DamageSource)source)) {
            return;
        }
        if (!this.isRemoved() && !this.dead) {
            Entity lastAttacker = source.getEntity();
            LivingEntity killer = this.getKillCredit();
            if (this.deathScore >= 0 && killer != null) {
                killer.awardKillScore((Entity)this, this.deathScore, source);
            }
            if (this.isSleeping()) {
                this.stopSleeping();
            }
            this.dead = true;
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (lastAttacker == null || lastAttacker.killedEntity(serverLevel, (LivingEntity)this)) {
                    this.gameEvent((Holder)GameEvent.ENTITY_DIE);
                    this.dropAllDeathLoot(serverLevel, source);
                    this.createWitherRose(killer);
                }
                serverLevel.broadcastEntityEvent((Entity)this, (byte)3);
            }
            this.getCombatTracker().recheckStatus();
            this.setPose(Pose.DYING);
        }
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
        for (EntityDataHolder<?> dataHolder : this.dataParams) {
            if (dataHolder.checkSync((Entity)this, key)) break;
        }
    }

    public void tick() {
        super.tick();
        for (AoAEntityPart<?> part : this.getParts()) {
            part.updatePosition();
        }
    }

    public boolean isFood(ItemStack stack) {
        if (this.getFoodTag() != null) {
            return stack.is(this.getFoodTag());
        }
        return this.getTemptationTag() != null && stack.is(this.getTemptationTag());
    }

    @Nullable
    protected TagKey<Item> getTemptationTag() {
        return this.getFoodTag();
    }

    @Nullable
    protected TagKey<Item> getFoodTag() {
        return null;
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob partner) {
        return null;
    }

    public void finalizeSpawnChildFromBreeding(ServerLevel level, Animal animal, @Nullable AgeableMob baby) {
        super.finalizeSpawnChildFromBreeding(level, animal, baby);
        baby.finalizeSpawn((ServerLevelAccessor)level, level.getCurrentDifficultyAt(BlockPos.containing((Position)baby.position())), MobSpawnType.BREEDING, null);
    }

    @Override
    public AoAEntityPart<?>[] getParts() {
        return this.parts;
    }

    public boolean isMultipartEntity() {
        return this.isMultipartActive();
    }

    public void refreshDimensions() {
        super.refreshDimensions();
        this.refreshMultipartDimensions();
    }

    @Override
    public void setParts(AoAEntityPart<?> ... parts) {
        if (this.getParts().length > 0) {
            throw new IllegalStateException("Cannot add more parts after having already done so!");
        }
        this.parts = parts;
        this.defineParts(ENTITY_COUNTER, this::setId, parts);
    }

    public void setId(int id) {
        super.setId(id);
        this.setMultipartIds(id);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }
}

