/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.animal.precasia;

import java.util.UUID;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.AoATags;
import net.tslat.aoa3.common.registration.entity.AoAAnimals;
import net.tslat.aoa3.common.registration.entity.AoAEntityStats;
import net.tslat.aoa3.content.entity.base.AoAAnimal;
import net.tslat.aoa3.content.entity.base.AoAEntityPart;
import net.tslat.aoa3.content.entity.brain.task.temp.FixedFollowParent;
import net.tslat.aoa3.content.entity.brain.task.temp.SetRandomFlyingTarget;
import net.tslat.aoa3.library.object.EntityDataHolder;
import net.tslat.aoa3.util.AttributeUtil;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.FirstApplicableBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.OneRandomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.BreedWithPartner;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.FollowTemptation;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.util.BrainUtils;
import net.tslat.smartbrainlib.util.EntityRetrievalUtil;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DefaultAnimations;

public class OpteryxEntity
extends AoAAnimal<OpteryxEntity>
implements FlyingAnimal,
OwnableEntity {
    protected static final AttributeModifier EGG_HEALTH_MOD = new AttributeModifier(AdventOfAscension.id("baby_base_health"), -0.75, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
    public static final EntityDataHolder<Boolean> IS_EGG = EntityDataHolder.register(OpteryxEntity.class, EntityDataSerializers.BOOLEAN, false, entity -> entity.isEgg, (entity, value) -> {
        entity.isEgg = value;
    });
    protected static final EntityDimensions EGG_DIMENSIONS = EntityDimensions.fixed((float)0.375f, (float)0.5f);
    private static final RawAnimation TAKEOFF_ANIM = RawAnimation.begin().thenPlay("move.fly_start");
    private static final RawAnimation LANDING_ANIM = RawAnimation.begin().thenPlay("move.fly_stop");
    protected boolean isFlying = false;
    protected final FlyingPathNavigation flightNavigator;
    protected final PathNavigation walkNavigator;
    protected final FlyingMoveControl flightMoveControl = new FlyingMoveControl((Mob)this, 10, true);
    protected final MoveControl groundMoveControl = this.moveControl;
    @Nullable
    protected UUID ownerId = null;
    protected boolean isEgg = false;

    public OpteryxEntity(EntityType<? extends OpteryxEntity> entityType, Level world) {
        super(entityType, world);
        this.flightNavigator = new FlyingPathNavigation((Mob)this, world);
        this.walkNavigator = this.navigation;
        this.walkNavigator.setCanFloat(true);
        this.setParts(new AoAEntityPart<OpteryxEntity>(this, 0.375f, 0.4375f, 0.0f, 0.76f, this.getBbWidth() - 0.0625f), new AoAEntityPart<OpteryxEntity>(this, 0.25f, 0.25f, 0.0f, 0.97f, this.getBbWidth() + 0.25f), new AoAEntityPart<OpteryxEntity>(this, 0.25f, 0.25f, 0.0f, 0.97f, this.getBbWidth() + 0.5f), new AoAEntityPart<OpteryxEntity>(this, 0.375f, 0.4375f, 0.0f, 0.76f, -this.getBbWidth() + 0.0625f));
    }

    protected EntityDimensions getDefaultDimensions(Pose pose) {
        return this.isEgg() ? EGG_DIMENSIONS : super.getDefaultDimensions(pose);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        this.registerDataParams(builder, IS_EGG);
    }

    public PathNavigation getNavigation() {
        if (this.flightNavigator == null) {
            return super.getNavigation();
        }
        this.navigation = this.isFlying() ? this.flightNavigator : this.walkNavigator;
        return this.navigation;
    }

    public MoveControl getMoveControl() {
        this.moveControl = this.navigation == this.walkNavigator ? this.groundMoveControl : this.flightMoveControl;
        return this.moveControl;
    }

    @Override
    public BrainActivityGroup<? extends OpteryxEntity> getIdleTasks() {
        return BrainActivityGroup.idleTasks((Behavior[])new Behavior[]{new BreedWithPartner().startCondition(entity -> this.canBreed() && !this.isVehicle()), new FirstApplicableBehaviour(new ExtendedBehaviour[]{new FixedFollowParent(), new FollowTemptation().startCondition(entity -> this.getTemptationTag() != null), new OneRandomBehaviour(new ExtendedBehaviour[]{new FirstApplicableBehaviour(new ExtendedBehaviour[]{new SetRandomWalkTarget().speedModifier(0.9f).startCondition(entity -> !entity.isFlying()), new SetRandomFlyingTarget<OpteryxEntity>().verticalWeight(entity -> -1).speedModifier(0.9f).startCondition(OpteryxEntity::isFlying)}), new Idle().runFor(entity -> entity.getRandom().nextInt(30, 60))})}).startCondition(entity -> !this.isVehicle())});
    }

    public void checkDespawn() {
        if (this.isEggAge()) {
            return;
        }
        super.checkDespawn();
    }

    public boolean isPushable() {
        if (this.isEggAge()) {
            return false;
        }
        return super.isPushable();
    }

    public boolean isPushedByFluid() {
        if (this.isEggAge()) {
            return false;
        }
        return super.isPushedByFluid();
    }

    protected void pushEntities() {
        if (!this.isEggAge()) {
            super.pushEntities();
        }
    }

    @Override
    @Nullable
    protected TagKey<Item> getFoodTag() {
        return AoATags.Items.OPTERYX_FOOD;
    }

    @Override
    public boolean isFood(ItemStack stack) {
        return stack.getFoodProperties((LivingEntity)this) != null && stack.is(ItemTags.MEAT);
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        if (this.isEgg()) {
            return null;
        }
        return (SoundEvent)AoASounds.ENTITY_CHARGER_AMBIENT.get();
    }

    @Override
    @Nullable
    protected SoundEvent getHurtSound(DamageSource source) {
        if (this.isEgg()) {
            return SoundEvents.TURTLE_EGG_BREAK;
        }
        return (SoundEvent)AoASounds.ENTITY_OPTERYX_HURT.get();
    }

    @Override
    @Nullable
    protected SoundEvent getDeathSound() {
        if (this.isEgg()) {
            return SoundEvents.TURTLE_EGG_BREAK;
        }
        return (SoundEvent)AoASounds.ENTITY_OPTERYX_HURT.get();
    }

    public boolean causeFallDamage(float distance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }

    public boolean isEffectiveAi() {
        return !this.isEgg() && super.isEffectiveAi();
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("IsEgg", IS_EGG.get((Entity)this).booleanValue());
        if (this.getOwnerUUID() != null) {
            tag.putUUID("Owner", this.getOwnerUUID());
        }
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("IsEgg", 1)) {
            IS_EGG.set((Entity)this, tag.getBoolean("IsEgg"));
        }
        if (tag.contains("Owner", 11)) {
            this.ownerId = tag.getUUID("Owner");
        }
    }

    public void aiStep() {
        super.aiStep();
        if (this.isEgg()) {
            if (this.getParts()[0].isEnabled()) {
                this.toggleMultipart(false);
                this.refreshDimensions();
            }
        } else if (!this.getParts()[0].isEnabled()) {
            this.toggleMultipart(true);
            this.refreshDimensions();
        }
        if (this.level().isClientSide) {
            this.isFlying = !this.onGround();
        } else {
            if (this.isEgg()) {
                if (this.getAge() > -120000) {
                    if (this.getAge() == -24000) {
                        this.level().playSound(null, this.blockPosition(), SoundEvents.TURTLE_EGG_HATCH, SoundSource.NEUTRAL, 0.7f, (float)this.rand().randomValueBetween((double)0.2f, (double)1.1f));
                    } else if (this.getAge() % 12000 == 0) {
                        this.level().playSound(null, this.blockPosition(), SoundEvents.TURTLE_EGG_CRACK, SoundSource.NEUTRAL, 0.7f, (float)this.rand().randomValueBetween((double)0.2f, (double)1.1f));
                    }
                }
                this.setDeltaMovement(this.getDeltaMovement().multiply(0.25, 1.0, 0.25).subtract(0.0, this.getAttributeValue(Attributes.GRAVITY), 0.0));
                this.move(MoverType.SELF, this.getDeltaMovement());
                AttributeUtil.applyPermanentModifier((LivingEntity)this, (Holder<Attribute>)Attributes.MAX_HEALTH, EGG_HEALTH_MOD, true);
            } else {
                AttributeUtil.removeModifier((LivingEntity)this, (Holder<Attribute>)Attributes.MAX_HEALTH, EGG_HEALTH_MOD);
            }
            if (this.isVehicle() && this.isFlying) {
                this.setDeltaMovement(this.getDeltaMovement().subtract(0.0, this.getAttributeValue(Attributes.GRAVITY) * 0.5, 0.0));
            }
        }
    }

    @Override
    protected void customServerAiStep() {
        super.customServerAiStep();
        if (IS_EGG.is((Entity)this, true)) {
            IS_EGG.set((Entity)this, false);
        }
        boolean wasFlying = this.isFlying();
        if (this.isInLove()) {
            this.setDeltaMovement(this.getDeltaMovement().subtract(0.0, (double)0.1f, 0.0));
        }
        boolean bl = this.isFlying = !this.onGround();
        if (wasFlying != this.isFlying()) {
            this.updatePathControllers();
        }
        if (this.isFlying()) {
            if (!this.isBaby()) {
                this.setNoGravity(true);
            }
        } else if (!this.isVehicle()) {
            if (wasFlying) {
                this.triggerAnim("Movement", "Land");
                this.setNoGravity(false);
                this.getNavigation().stop();
                this.setDeltaMovement(0.0, -0.1f, 0.0);
            } else if (this.rand().oneInNChance(2000) && !BrainUtils.hasMemory((LivingEntity)this, (MemoryModuleType)MemoryModuleType.BREED_TARGET) && !this.isInLove()) {
                this.getNavigation().stop();
                this.setDeltaMovement(0.0, 0.2f, 0.0);
                this.triggerAnim("Movement", "Takeoff");
            }
        }
    }

    protected void updatePathControllers() {
        this.getNavigation();
        this.getMoveControl();
    }

    @Override
    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob partner) {
        return new OpteryxEntity((EntityType<? extends OpteryxEntity>)((EntityType)AoAAnimals.OPTERYX.get()), (Level)level);
    }

    @Override
    public void finalizeSpawnChildFromBreeding(ServerLevel level, Animal partner, @Nullable AgeableMob baby) {
        super.finalizeSpawnChildFromBreeding(level, partner, baby);
        if (baby instanceof OpteryxEntity) {
            OpteryxEntity babyOpteryx = (OpteryxEntity)baby;
            this.restrictTo(partner.blockPosition(), 5);
            partner.restrictTo(this.blockPosition(), 5);
            babyOpteryx.setAge(this.random.nextInt(-252000, -204000));
            Player player = EntityRetrievalUtil.getNearestPlayer((Entity)this, (double)15.0, pl -> true);
            if (player instanceof ServerPlayer) {
                ServerPlayer pl2 = (ServerPlayer)player;
                babyOpteryx.ownerId = pl2.getUUID();
            }
        }
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "Movement", 2, state -> {
            if (this.isEggAge()) {
                return PlayState.STOP;
            }
            if (this.isFlying()) {
                return state.setAndContinue(DefaultAnimations.FLY);
            }
            if (state.isMoving()) {
                return state.setAndContinue(this.isSprinting() ? DefaultAnimations.RUN : DefaultAnimations.WALK);
            }
            return state.setAndContinue(DefaultAnimations.IDLE);
        }).triggerableAnim("Takeoff", TAKEOFF_ANIM).triggerableAnim("Land", LANDING_ANIM));
    }

    public boolean isFlying() {
        return this.isFlying;
    }

    public boolean isEggAge() {
        return this.getAge() < -24000;
    }

    public boolean isEgg() {
        return IS_EGG.get((Entity)this);
    }

    public void setAge(int age) {
        super.setAge(age);
        if (!this.level().isClientSide()) {
            LivingEntity livingEntity;
            IS_EGG.set((Entity)this, this.isEggAge());
            if ((age == 0 || age == -24000) && (livingEntity = this.getOwner()) instanceof ServerPlayer) {
                ServerPlayer pl = (ServerPlayer)livingEntity;
                CriteriaTriggers.TAME_ANIMAL.trigger(pl, (Animal)this);
            }
        }
    }

    @Nullable
    public UUID getOwnerUUID() {
        return this.ownerId;
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        InteractionResult result;
        ItemStack stack;
        if (player.getUUID().equals(this.getOwnerUUID()) && this.isFood(stack = player.getItemInHand(hand)) && this.getHealth() < this.getMaxHealth()) {
            this.heal(stack.getFoodProperties((LivingEntity)this).nutrition());
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
            }
            this.gameEvent((Holder)GameEvent.EAT, (Entity)this);
            return InteractionResult.SUCCESS;
        }
        InteractionResult interactionResult = result = this.isEgg() ? InteractionResult.FAIL : super.mobInteract(player, hand);
        if (result != InteractionResult.PASS) {
            return result;
        }
        if (!this.isBaby() && player.getUUID().equals(this.getOwnerUUID()) && !this.isVehicle() && !player.isSecondaryUseActive()) {
            if (!this.level().isClientSide) {
                player.startRiding((Entity)this);
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        return InteractionResult.PASS;
    }

    public Vec3 getDismountLocationForPassenger(LivingEntity passenger) {
        Direction movingDirection = this.getMotionDirection();
        if (movingDirection.getAxis() == Direction.Axis.Y) {
            return super.getDismountLocationForPassenger(passenger);
        }
        BlockPos pos = this.blockPosition();
        BlockPos.MutableBlockPos testPos = new BlockPos.MutableBlockPos();
        for (int[] dismountOffset : DismountHelper.offsetsForDirection((Direction)movingDirection)) {
            double floorHeight = this.level().getBlockFloorHeight((BlockPos)testPos.set(pos.getX() + dismountOffset[0], pos.getY(), pos.getZ() + dismountOffset[1]));
            if (!DismountHelper.isBlockFloorValid((double)floorHeight)) continue;
            Vec3 floorPos = Vec3.upFromBottomCenterOf((Vec3i)testPos, (double)floorHeight);
            for (Pose pose : passenger.getDismountPoses()) {
                AABB dismountBoundingBox = passenger.getLocalBoundsForPose(pose);
                if (!DismountHelper.canDismountTo((CollisionGetter)this.level(), (LivingEntity)passenger, (AABB)dismountBoundingBox.move(floorPos))) continue;
                passenger.setPose(pose);
                return floorPos;
            }
        }
        return super.getDismountLocationForPassenger(passenger);
    }

    protected void tickRidden(Player player, Vec3 travelVector) {
        super.tickRidden(player, travelVector);
        if (!this.level().isClientSide() && !player.getUUID().equals(this.getOwnerUUID())) {
            player.stopRiding();
        }
        float yRot = Mth.rotLerp((float)0.1f, (float)this.getYRot(), (float)player.getYRot());
        this.setRot(yRot, player.getXRot() * 0.5f);
        this.yBodyRot = this.yHeadRot = this.getYRot();
        this.yRotO = this.yHeadRot;
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        Entity passenger = this.getFirstPassenger();
        if (passenger instanceof Player) {
            Player pl = (Player)passenger;
            return pl;
        }
        return null;
    }

    protected Vec3 getRiddenInput(Player passenger, Vec3 travelVector) {
        float forward = passenger.zza;
        if (forward <= 0.0f) {
            forward *= 0.25f;
        }
        return new Vec3(0.0, passenger.jumping ? 0.25 : -0.25, (double)forward);
    }

    protected float getRiddenSpeed(Player player) {
        return (float)this.getAttributeValue(Attributes.MOVEMENT_SPEED) * (this.isFlying ? 2.0f : 0.5f);
    }

    @Override
    public void die(DamageSource cause) {
        Component deathMessage = this.getCombatTracker().getDeathMessage();
        super.die(cause);
        if (this.dead && !this.level().isClientSide() && this.level().getGameRules().getBoolean(GameRules.RULE_SHOWDEATHMESSAGES) && this.getOwner() instanceof ServerPlayer) {
            this.getOwner().sendSystemMessage(deathMessage);
        }
    }

    public static AoAEntityStats.AttributeBuilder entityStats(EntityType<OpteryxEntity> entityType) {
        return AoAEntityStats.AttributeBuilder.create(entityType).health(34.0).moveSpeed(0.2875f).flyingSpeed(0.3f).followRange(32.0).knockbackResist(0.4f);
    }
}

