/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.animal.precasia;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.damagesource.DamageContainer;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.AoATags;
import net.tslat.aoa3.common.registration.block.AoAFluidTypes;
import net.tslat.aoa3.common.registration.entity.AoAAnimals;
import net.tslat.aoa3.common.registration.entity.AoAEntitySpawnPlacements;
import net.tslat.aoa3.common.registration.entity.AoAEntityStats;
import net.tslat.aoa3.common.registration.entity.AoAMonsters;
import net.tslat.aoa3.content.entity.base.AoAAnimal;
import net.tslat.aoa3.content.entity.base.AoAEntityPart;
import net.tslat.aoa3.content.entity.brain.task.temp.FixedFollowParent;
import net.tslat.aoa3.scheduling.AoAScheduler;
import net.tslat.aoa3.util.EntitySpawningUtil;
import net.tslat.effectslib.api.particle.ParticleBuilder;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.FirstApplicableBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.OneRandomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.BreedWithPartner;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.FollowTemptation;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DefaultAnimations;

public class HorndronEntity
extends AoAAnimal<HorndronEntity> {
    private static final RawAnimation STRUT_ANIM = RawAnimation.begin().thenPlay("misc.charge_up");

    public HorndronEntity(EntityType<? extends HorndronEntity> entityType, Level world) {
        super(entityType, world);
        this.setParts(new AoAEntityPart<HorndronEntity>(this, 1.0f, 1.0f, 0.0f, 0.755f, this.getBbWidth() / 2.0f + 0.5f).setDamageMultiplier(1.25f), new AoAEntityPart<HorndronEntity>(this, 0.75f, 1.1875f, 0.3725f, 0.75f, -this.getBbWidth() / 2.0f - 0.3725f).setDamageMultiplier(0.9f), new AoAEntityPart<HorndronEntity>(this, 0.75f, 1.1875f, -0.3725f, 0.75f, -this.getBbWidth() / 2.0f - 0.3725f).setDamageMultiplier(0.9f));
    }

    public int getMaxHeadYRot() {
        return 32;
    }

    public int getMaxHeadXRot() {
        return 15;
    }

    public int getHeadRotSpeed() {
        return 5;
    }

    @Override
    @Nullable
    protected SoundEvent getStepSound(BlockPos pos, BlockState blockState) {
        return this.age >= 0 ? (SoundEvent)AoASounds.ENTITY_GENERIC_HEAVY_STEP.get() : super.getStepSound(pos, blockState);
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return SoundEvents.POLAR_BEAR_AMBIENT;
    }

    @Override
    protected SoundEvent getDeathSound() {
        return (SoundEvent)AoASounds.ENTITY_HORNDRON_DEATH.get();
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)AoASounds.ENTITY_HORNDRON_HURT.get();
    }

    @Override
    public BrainActivityGroup<? extends HorndronEntity> getIdleTasks() {
        return BrainActivityGroup.idleTasks((Behavior[])new Behavior[]{new FirstApplicableBehaviour(new ExtendedBehaviour[]{new BreedWithPartner().startCondition(entity -> this.canBreed()), new FixedFollowParent(), new FollowTemptation().startCondition(entity -> this.getTemptationTag() != null), new OneRandomBehaviour(new ExtendedBehaviour[]{new SetRandomWalkTarget().speedModifier(0.9f), new Idle().runFor(entity -> entity.getRandom().nextInt(30, 60)).whenStarting(entity -> {
            if (this.age == 0 && this.random.nextFloat() < 0.01f) {
                this.triggerAnim("Walk/Run/Idle", "Charge");
            }
        })})})});
    }

    public void onDamageTaken(DamageContainer damageContainer) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            if (damageContainer.getSource().is(DamageTypeTags.IS_FIRE) && this.level().getFluidState(BlockPos.containing((Position)this.getEyePosition())).getFluidType() == AoAFluidTypes.TAR.get() && this.level().getFluidState(this.blockPosition().above()).getFluidType() == AoAFluidTypes.TAR.get()) {
                ParticleBuilder.forRandomPosInEntity((ParticleOptions)ParticleTypes.LARGE_SMOKE, (Entity)this).colourOverride(255, 255, 255, 255).spawnNTimes(20).sendToAllPlayersTrackingEntity(level2, (Entity)this);
                if (this.isDeadOrDying()) {
                    AoAScheduler.scheduleSyncronisedTask(() -> EntitySpawningUtil.spawnEntity(level2, (EntityType)AoAMonsters.SKELETAL_ABOMINATION.get(), this.position(), MobSpawnType.CONVERSION, abomination -> {
                        abomination.setXRot(this.getXRot());
                        abomination.setYRot(this.getYRot());
                        abomination.setYHeadRot(this.getYHeadRot());
                    }), 19 - this.deathTime);
                }
            }
        }
    }

    public void push(Entity entity) {
        super.push(entity);
        if (((Boolean)BrainUtils.memoryOrDefault((LivingEntity)this, (MemoryModuleType)MemoryModuleType.IS_PANICKING, () -> false)).booleanValue() && entity instanceof LivingEntity && entity.getBoundingBox().getSize() < this.getBoundingBox().getSize()) {
            entity.hurt(this.level().damageSources().cramming(), 6.0f);
        }
    }

    @Override
    public boolean isMultipartEntity() {
        return this.age >= 0 && super.isMultipartEntity();
    }

    @Override
    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob partner) {
        return new HorndronEntity((EntityType<? extends HorndronEntity>)((EntityType)AoAAnimals.HORNDRON.get()), (Level)level);
    }

    @Override
    @Nullable
    protected TagKey<Item> getFoodTag() {
        return AoATags.Items.HORNDRON_FOOD;
    }

    public static SpawnPlacements.SpawnPredicate<Entity> spawnRules() {
        return AoAEntitySpawnPlacements.SpawnBuilder.DEFAULT_ANIMAL;
    }

    public static AoAEntityStats.AttributeBuilder entityStats(EntityType<HorndronEntity> entityType) {
        return AoAEntityStats.AttributeBuilder.create(entityType).health(58.0).moveSpeed(0.25).followRange(16.0).knockbackResist(0.75);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(DefaultAnimations.genericWalkRunIdleController((Entity)this).triggerableAnim("Charge", STRUT_ANIM));
    }
}

