/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.animal.precasia;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.Tags;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.AoATags;
import net.tslat.aoa3.common.registration.entity.AoAAnimals;
import net.tslat.aoa3.common.registration.entity.AoAEntitySpawnPlacements;
import net.tslat.aoa3.common.registration.entity.AoAEntityStats;
import net.tslat.aoa3.content.entity.base.AoAAnimal;
import net.tslat.aoa3.content.entity.base.AoAEntityPart;
import net.tslat.aoa3.content.entity.brain.task.temp.FixedFollowParent;
import net.tslat.aoa3.scheduling.AoAScheduler;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.FirstApplicableBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.OneRandomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.SequentialBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.BreedWithPartner;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.CustomHeldBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Panic;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.FollowTemptation;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToBlock;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.custom.NearbyBlocksSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.HurtBySensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.ItemTemptingSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyLivingEntitySensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyPlayersSensor;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DefaultAnimations;

public class DeinotheriumEntity
extends AoAAnimal<DeinotheriumEntity> {
    private static final RawAnimation EAT_ANIM = RawAnimation.begin().thenPlay("misc.eat");

    public DeinotheriumEntity(EntityType<? extends DeinotheriumEntity> entityType, Level world) {
        super(entityType, world);
        this.setParts(new AoAEntityPart<DeinotheriumEntity>(this, this.getBbWidth(), 1.625f, 0.0f, 1.3125f, this.getBbWidth()), new AoAEntityPart<DeinotheriumEntity>(this, 1.0f, 1.0f, 0.0f, 1.9375f, this.getBbWidth() + 1.5f).setDamageMultiplier(1.25f), new AoAEntityPart<DeinotheriumEntity>(this, this.getBbWidth(), 1.75f, 0.0f, 1.3125f, -this.getBbWidth() * 0.5f).setDamageMultiplier(0.9f));
    }

    public int getMaxHeadYRot() {
        return 35;
    }

    public int getMaxHeadXRot() {
        return 20;
    }

    public int getHeadRotSpeed() {
        return 7;
    }

    @Override
    public int getAmbientSoundInterval() {
        return 480;
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return (SoundEvent)AoASounds.ENTITY_DEINOTHERIUM_AMBIENT.get();
    }

    @Override
    @Nullable
    protected SoundEvent getDeathSound() {
        return (SoundEvent)AoASounds.ENTITY_DEINOTHERIUM_DEATH.get();
    }

    @Override
    @Nullable
    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)AoASounds.ENTITY_DEINOTHERIUM_HURT.get();
    }

    @Override
    @Nullable
    protected SoundEvent getStepSound(BlockPos pos, BlockState blockState) {
        return this.age >= 0 ? (SoundEvent)AoASounds.ENTITY_GENERIC_HEAVY_STEP.get() : super.getStepSound(pos, blockState);
    }

    @Override
    public List<ExtendedSensor<? extends DeinotheriumEntity>> getSensors() {
        return ObjectArrayList.of((Object[])new ExtendedSensor[]{new ItemTemptingSensor().temptedWith((entity, stack) -> this.isFood((ItemStack)stack)), new NearbyPlayersSensor(), new NearbyLivingEntitySensor().setScanRate(entity -> 40), new HurtBySensor(), new NearbyBlocksSensor().setRadius(5.0, 3.0).setPredicate((state, entity) -> state.is(BlockTags.LEAVES)).setScanRate(entity -> 80)});
    }

    @Override
    public BrainActivityGroup<? extends DeinotheriumEntity> getIdleTasks() {
        return BrainActivityGroup.idleTasks((Behavior[])new Behavior[]{new FirstApplicableBehaviour(new ExtendedBehaviour[]{new BreedWithPartner().startCondition(entity -> this.canBreed()), new FixedFollowParent(), new FollowTemptation().startCondition(entity -> this.getTemptationTag() != null), new OneRandomBehaviour(new ExtendedBehaviour[]{new SequentialBehaviour(new ExtendedBehaviour[]{new SetWalkTargetToBlock().predicate((entity, block) -> ((BlockPos)block.getFirst()).distSqr((Vec3i)entity.blockPosition()) < 25.0 && ((BlockState)block.getSecond()).is(BlockTags.LEAVES)).closeEnoughWhen((entity, pos) -> 5).cooldownFor(entity -> entity.getRandom().nextInt(100, 200)), new CustomHeldBehaviour(entity -> {}).stopIf(entity -> entity.getNavigation().isDone()).whenStopping(entity -> {
            BlockPosTracker posTracker;
            BlockPos pos;
            Object patt0$temp = BrainUtils.getMemory((LivingEntity)entity, (MemoryModuleType)MemoryModuleType.LOOK_TARGET);
            if (patt0$temp instanceof BlockPosTracker && (pos = (posTracker = (BlockPosTracker)patt0$temp).currentBlockPosition()).distSqr((Vec3i)entity.blockPosition()) <= 20.0 && this.level().getBlockState(pos).is(BlockTags.LEAVES) && this.level().getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
                this.triggerAnim("Walk/Run/Idle", "Eat");
                this.setDeltaMovement(this.getDeltaMovement().multiply(0.0, 1.0, 0.0));
                entity.getNavigation().stop();
                BrainUtils.clearMemory((LivingEntity)entity, (MemoryModuleType)MemoryModuleType.PATH);
                AoAScheduler.scheduleSyncronisedTask(() -> {
                    if (pos.distSqr((Vec3i)entity.blockPosition()) <= 20.0 && this.level().getBlockState(pos).is(BlockTags.LEAVES)) {
                        this.level().destroyBlock(pos, false, (Entity)entity);
                    }
                }, 40);
            }
        }), new Idle().runFor(entity -> 60)}), new SetRandomWalkTarget().speedModifier(0.9f), new Idle().runFor(entity -> entity.getRandom().nextInt(30, 60))})}).noTimeout().startCondition(entity -> (Boolean)BrainUtils.memoryOrDefault((LivingEntity)entity, (MemoryModuleType)MemoryModuleType.IS_PANICKING, () -> false) == false)});
    }

    @Override
    public Map<Activity, BrainActivityGroup<? extends DeinotheriumEntity>> getAdditionalTasks() {
        return Map.of(Activity.PANIC, new BrainActivityGroup(Activity.PANIC).behaviours(new Behavior[]{new Panic().setRadius(15.0, 10.0).speedMod(entity -> 2.0f)}).requireAndWipeMemoriesOnUse(new MemoryModuleType[]{MemoryModuleType.HURT_BY_ENTITY}));
    }

    public void push(Entity entity) {
        super.push(entity);
        if (((Boolean)BrainUtils.memoryOrDefault((LivingEntity)this, (MemoryModuleType)MemoryModuleType.IS_PANICKING, () -> false)).booleanValue() && entity instanceof LivingEntity && entity.getBoundingBox().getSize() < this.getBoundingBox().getSize()) {
            entity.hurt(this.level().damageSources().cramming(), 10.0f);
        }
    }

    @Override
    @Nullable
    protected TagKey<Item> getFoodTag() {
        return AoATags.Items.DEINOTHERIUM_FOOD;
    }

    @Override
    public boolean isMultipartEntity() {
        return this.age >= 0 && super.isMultipartEntity();
    }

    @Override
    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob partner) {
        return new DeinotheriumEntity((EntityType<? extends DeinotheriumEntity>)((EntityType)AoAAnimals.DEINOTHERIUM.get()), (Level)level);
    }

    public static SpawnPlacements.SpawnPredicate<Entity> spawnRules() {
        return AoAEntitySpawnPlacements.SpawnBuilder.DEFAULT.and((SpawnPlacements.SpawnPredicate<Entity>)((SpawnPlacements.SpawnPredicate)(entityType, level, spawnType, pos, rand) -> {
            if (!MobSpawnType.ignoresLightRequirements((MobSpawnType)spawnType) && level.getRawBrightness(pos, 0) <= 8) {
                return false;
            }
            BlockState block = level.getBlockState(pos.below());
            return block.is(BlockTags.ANIMALS_SPAWNABLE_ON) || block.is(Tags.Blocks.SANDS);
        }));
    }

    public static AoAEntityStats.AttributeBuilder entityStats(EntityType<DeinotheriumEntity> entityType) {
        return AoAEntityStats.AttributeBuilder.create(entityType).health(95.0).moveSpeed(0.2f).followRange(16.0).meleeStrength(8.0).knockback(1.0).knockbackResist(0.9f);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(DefaultAnimations.genericWalkRunIdleController((Entity)this).triggerableAnim("Eat", EAT_ANIM));
    }
}

