/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.animal.barathos;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.CombatEntry;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.ItemAbilities;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.common.registration.custom.AoAWorldEvents;
import net.tslat.aoa3.common.registration.entity.AoAEntityStats;
import net.tslat.aoa3.content.entity.base.AoAAnimal;
import net.tslat.aoa3.content.world.event.AoAWorldEvent;
import net.tslat.aoa3.content.world.event.AoAWorldEventManager;
import net.tslat.aoa3.content.world.event.BarathosSandstormEvent;
import net.tslat.aoa3.library.builder.SoundBuilder;
import net.tslat.aoa3.library.object.EntityDataHolder;
import net.tslat.aoa3.util.InventoryUtil;
import net.tslat.aoa3.util.LootUtil;
import net.tslat.aoa3.util.MathUtil;
import net.tslat.effectslib.api.particle.ParticleBuilder;
import net.tslat.effectslib.networking.packet.TELParticlePacket;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.FirstApplicableBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.HeldBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.OneRandomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.registry.SBLMemoryTypes;
import net.tslat.smartbrainlib.util.BrainUtils;
import net.tslat.smartbrainlib.util.EntityRetrievalUtil;
import net.tslat.smartbrainlib.util.RandomUtil;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DefaultAnimations;

public class ArkbackEntity
extends AoAAnimal<ArkbackEntity> {
    private static final RawAnimation EAT_ANIM = RawAnimation.begin().thenPlay("misc.eat");
    private static final RawAnimation REST_START_ANIM = RawAnimation.begin().thenPlay("misc.rest.start");
    private static final RawAnimation REST_STOP_ANIM = RawAnimation.begin().thenPlay("misc.shake").thenPlay("misc.rest.stop");
    public static final int MAX_SAND = 29;
    public static final EntityDataHolder<Boolean> RESTING = EntityDataHolder.register(ArkbackEntity.class, EntityDataSerializers.BOOLEAN, false, entity -> entity.resting, (entity, value) -> {
        entity.resting = value;
    });
    public static final EntityDataHolder<Integer> SAND_LEVEL = EntityDataHolder.register(ArkbackEntity.class, EntityDataSerializers.INT, 0, entity -> entity.sandLevel, (entity, value) -> {
        entity.sandLevel = value;
    });
    private boolean resting = false;
    private int sandLevel = 0;

    public ArkbackEntity(EntityType<? extends ArkbackEntity> entityType, Level world) {
        super(entityType, world);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        this.registerDataParams(builder, RESTING, SAND_LEVEL);
    }

    public boolean isPushable() {
        return false;
    }

    public boolean isPushedByFluid() {
        return false;
    }

    public boolean canBeCollidedWith() {
        return true;
    }

    @Override
    protected float getStepWeight() {
        return 6.0f;
    }

    @Override
    @Nullable
    protected SoundEvent getStepSound(BlockPos pos, BlockState blockState) {
        return (SoundEvent)AoASounds.ENTITY_GENERIC_HEAVY_STEP.get();
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return (SoundEvent)AoASounds.ENTITY_ARKBACK_AMBIENT.get();
    }

    @Override
    public int getAmbientSoundInterval() {
        return 480;
    }

    @Override
    public BrainActivityGroup<? extends ArkbackEntity> getIdleTasks() {
        return BrainActivityGroup.idleTasks((Behavior[])new Behavior[]{new FirstApplicableBehaviour(new ExtendedBehaviour[]{new RestBehaviour(), new OneRandomBehaviour(new Pair[]{Pair.of((Object)new SetRandomWalkTarget().setRadius(30.0, 10.0).speedModifier(0.9f), (Object)20), Pair.of((Object)new Idle().runFor(entity -> entity.getRandom().nextInt(60, 240)), (Object)20), Pair.of((Object)((Object)new EatBehaviour()), (Object)1)}).stopIf(entity -> BrainUtils.hasMemory((LivingEntity)entity, (MemoryModuleType)MemoryModuleType.HURT_BY_ENTITY) && !BrainUtils.hasMemory((LivingEntity)entity, (MemoryModuleType)((MemoryModuleType)SBLMemoryTypes.SPECIAL_ATTACK_COOLDOWN.get())))})});
    }

    @Override
    public Map<Activity, BrainActivityGroup<? extends ArkbackEntity>> getAdditionalTasks() {
        return new Object2ObjectOpenHashMap(0);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("SandLevel", this.sandLevel);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("SandLevel", 3)) {
            this.setSandLevel(compound.getInt("SandLevel"));
        }
    }

    public InteractionResult interactAt(Player player, Vec3 pos, InteractionHand hand) {
        if (this.getSandLevel() <= 0 || !this.resting) {
            return InteractionResult.PASS;
        }
        if (!player.getItemInHand(hand).canPerformAction(ItemAbilities.SHOVEL_DIG)) {
            return InteractionResult.PASS;
        }
        if (pos.y < (double)this.getBbHeight()) {
            return InteractionResult.PASS;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer pl = (ServerPlayer)player;
            InventoryUtil.giveItemsTo(pl, LootUtil.generateLoot(AdventOfAscension.id("misc/arkback_harvest"), new LootParams.Builder(pl.serverLevel()).withParameter(LootContextParams.ORIGIN, (Object)pos).withOptionalParameter(LootContextParams.THIS_ENTITY, (Object)pl).create(LootContextParamSets.ARCHAEOLOGY)));
        }
        if (!this.level().isClientSide) {
            this.setSandLevel(this.getSandLevel() - 5);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.resting) {
            for (Entity entity2 : EntityRetrievalUtil.getEntities((Level)this.level(), (AABB)AABB.ofSize((Vec3)this.position().add(0.0, (double)this.getBbHeight(), 0.0), (double)this.getBbWidth(), (double)(1.5f * this.getScale()), (double)this.getBbWidth()), entity -> entity != this && entity.onGround() && entity.getY() >= this.getY() + (double)this.getBbHeight())) {
                entity2.setDeltaMovement(MathUtil.getBodyForward((LivingEntity)this).scale((double)-0.4f));
                entity2.hurtMarked = true;
            }
        }
    }

    @Override
    protected void customServerAiStep() {
        BarathosSandstormEvent sandstorm;
        AoAWorldEvent aoAWorldEvent;
        super.customServerAiStep();
        if (this.getSandLevel() < 29 && RandomUtil.oneInNChance((int)210) && (aoAWorldEvent = AoAWorldEventManager.getEventById(this.level(), AoAWorldEvents.BARATHOS_SANDSTORM.getId())) instanceof BarathosSandstormEvent && (sandstorm = (BarathosSandstormEvent)aoAWorldEvent).isActive() && this.getY() >= 90.0 && this.level().getBrightness(LightLayer.SKY, this.blockPosition()) == 15) {
            this.setSandLevel(this.getSandLevel() + 1);
        }
        if (this.onGround() && this.getDeltaMovement().horizontalDistanceSqr() > 0.0) {
            for (LivingEntity entity2 : EntityRetrievalUtil.getEntities((Level)this.level(), (AABB)this.getBoundingBox().inflate(0.5).move(this.getDeltaMovement()), entity -> entity != this && entity instanceof LivingEntity && entity.getBbHeight() < this.getBbHeight() && entity.getBbWidth() < this.getBbWidth())) {
                entity2.hurt(this.damageSources().cramming(), (float)(3 * this.level().getDifficulty().getId()));
            }
        }
    }

    public void setSandLevel(int sandLevel) {
        SAND_LEVEL.set((Entity)this, Mth.clamp((int)sandLevel, (int)0, (int)29));
    }

    public int getSandLevel() {
        return this.sandLevel;
    }

    public static AoAEntityStats.AttributeBuilder entityStats(EntityType<ArkbackEntity> entityType) {
        return AoAEntityStats.AttributeBuilder.create(entityType).health(130.0).knockbackResist(1.0).armour(50.0, 75.0).moveSpeed(0.22f);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "Main", 0, state -> {
            if (this.resting) {
                return state.setAndContinue(DefaultAnimations.REST);
            }
            return state.setAndContinue(state.isMoving() ? DefaultAnimations.WALK : DefaultAnimations.IDLE);
        }).triggerableAnim("rest_start", REST_START_ANIM).triggerableAnim("rest_stop", REST_STOP_ANIM));
        controllers.add(new AnimationController((GeoAnimatable)this, "Eating", 0, state -> this.level().getGameTime() - this.lastDamageStamp < 40L ? PlayState.STOP : PlayState.CONTINUE).receiveTriggeredAnimations().triggerableAnim("Eat", EAT_ANIM));
    }

    private static class RestBehaviour
    extends HeldBehaviour<ArkbackEntity> {
        private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = List.of(Pair.of((Object)MemoryModuleType.HURT_BY_ENTITY, (Object)MemoryStatus.VALUE_PRESENT));
        private int shakeTick = -1;

        public RestBehaviour() {
            this.runFor(entity -> 180 + ((ArkbackEntity)entity).random.nextInt(100));
        }

        public List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
            return MEMORY_REQUIREMENTS;
        }

        protected boolean checkExtraStartConditions(ServerLevel level, ArkbackEntity entity) {
            return !entity.getCombatTracker().entries.isEmpty() && ((CombatEntry)entity.getCombatTracker().entries.getLast()).damage() > 4.0f;
        }

        protected void start(ArkbackEntity entity) {
            entity.setImmobile(true);
            entity.triggerAnim("Main", "rest_start");
        }

        protected void stop(ArkbackEntity entity) {
            entity.setImmobile(false);
            this.shakeTick = -1;
            BrainUtils.setSpecialCooldown((LivingEntity)entity, (int)600);
        }

        protected void tick(ArkbackEntity entity) {
            if (this.runningTime == 25) {
                RESTING.set((Entity)entity, true);
            } else if (this.shakeTick >= 0) {
                if (this.shakeTick++ > 16) {
                    RESTING.set((Entity)entity, false);
                } else {
                    float sine;
                    Vec3 shakeDirection = MathUtil.getBodyRight((LivingEntity)entity).scale((double)Mth.floor((float)(Mth.sin((float)(45 * this.shakeTick)) * 2.0f))).add(0.0, 1.0, 0.0);
                    AABB plateBounds = AABB.ofSize((Vec3)entity.position().add(0.0, (double)entity.getBbHeight(), 0.0), (double)entity.getBbWidth(), (double)(1.5f * entity.getScale()), (double)entity.getBbWidth());
                    for (Entity rider2 : EntityRetrievalUtil.getEntities((Level)entity.level(), (AABB)plateBounds, rider -> rider != entity)) {
                        rider2.setDeltaMovement(shakeDirection);
                        rider2.hurtMarked = true;
                    }
                    if (this.shakeTick < 10 && entity.getSandLevel() > 0 && Mth.abs((float)(sine = Mth.sin((float)(45 * this.shakeTick)))) >= 0.9f) {
                        TELParticlePacket packet = new TELParticlePacket();
                        shakeDirection = MathUtil.getBodyRight((LivingEntity)entity).scale((double)(sine * 0.25f)).add(0.0, 0.25, 0.0);
                        plateBounds = plateBounds.move(0.0, 0.5, 0.0);
                        for (int i = 0; i < 100; ++i) {
                            packet.particle(ParticleBuilder.forRandomPosInBounds((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.SAND.defaultBlockState()), (AABB)plateBounds).velocity(shakeDirection.add(entity.random.nextGaussian() * (double)0.05f, entity.random.nextGaussian() * (double)0.05f, entity.random.nextGaussian() * (double)0.05f)).scaleMod((float)entity.random.nextGaussian() * 0.4f + 0.8f));
                            packet.particle(ParticleBuilder.forRandomPosInBounds((ParticleOptions)new BlockParticleOption(ParticleTypes.FALLING_DUST, Blocks.SAND.defaultBlockState()), (AABB)plateBounds).velocity(shakeDirection.scale((double)0.1f).add(entity.random.nextGaussian() * (double)0.05f, entity.random.nextGaussian() * (double)0.05f, entity.random.nextGaussian() * (double)0.05f)).scaleMod(entity.random.nextFloat() * 0.4f + 0.3f));
                        }
                        packet.sendToAllPlayersTrackingEntity((ServerLevel)entity.level(), (Entity)entity);
                        entity.setSandLevel(entity.getSandLevel() - 10);
                    }
                }
            }
            if (this.shakeTick == -1 && this.timedOut(entity.level().getGameTime() + 37L)) {
                this.shakeTick = 0;
                entity.triggerAnim("Main", "rest_stop");
            }
        }
    }

    private static class EatBehaviour
    extends HeldBehaviour<ArkbackEntity> {
        private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = List.of(Pair.of((Object)MemoryModuleType.HURT_BY, (Object)MemoryStatus.VALUE_ABSENT));

        public EatBehaviour() {
            this.runFor(entity -> 103);
            this.stopIf(arkback -> arkback.level().getGameTime() - arkback.lastDamageStamp < 40L);
        }

        protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
            return MEMORY_REQUIREMENTS;
        }

        protected boolean checkExtraStartConditions(ServerLevel level, ArkbackEntity entity) {
            return !entity.resting && level.getBlockState(BlockPos.containing((Position)entity.position().add(MathUtil.getBodyForward((LivingEntity)entity).scale((double)entity.getBbWidth())).subtract(0.0, 1.0, 0.0))).isSolid();
        }

        protected void start(ArkbackEntity entity) {
            entity.setImmobile(true);
            entity.triggerAnim("Eating", "Eat");
        }

        protected void stop(ArkbackEntity entity) {
            entity.setImmobile(false);
        }

        protected void tick(ArkbackEntity entity) {
            if (this.runningTime == 75 || this.runningTime == 90) {
                new SoundBuilder(SoundEvents.CAMEL_EAT).followEntity((Entity)entity).varyPitch(0.2f).execute();
                ParticleBuilder.forPositions((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, AoABlocks.BARON_SAND.toStack()), (Vec3[])new Vec3[]{entity.position().add(MathUtil.getBodyForward((LivingEntity)entity).scale(2.0)).add(0.0, (double)(entity.getBbHeight() / 2.0f), 0.0)}).spawnNTimes(Mth.ceil((double)RandomUtil.randomValueBetween((double)10.0, (double)20.0))).sendToAllPlayersTrackingEntity((ServerLevel)entity.level(), (Entity)entity);
                if (entity.getHealth() < entity.getMaxHealth()) {
                    float heal = Math.min(entity.getMaxHealth() - entity.getHealth(), (float)RandomUtil.randomValueBetween((double)7.0, (double)12.0));
                    entity.heal(heal);
                    ParticleBuilder.forRandomPosInEntity((ParticleOptions)ParticleTypes.HEART, (Entity)entity).spawnNTimes(Mth.ceil((float)heal)).sendToAllPlayersTrackingEntity((ServerLevel)entity.level(), (Entity)entity);
                }
            }
        }
    }
}

