/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.ai.movehelper;

import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;

public class UnderwaterWalkingMovementController
extends MoveControl {
    private final PathfinderMob entity;

    public UnderwaterWalkingMovementController(PathfinderMob entity) {
        super((Mob)entity);
        this.entity = entity;
    }

    public void tick() {
        if (!this.entity.isEyeInFluid(FluidTags.WATER)) {
            super.tick();
            return;
        }
        if (this.operation == MoveControl.Operation.MOVE_TO && !this.entity.getNavigation().isDone()) {
            LivingEntity target = this.entity.getTarget();
            double distanceX = this.wantedX - this.entity.getX();
            double distanceY = this.wantedY + 1.0 - this.entity.getY();
            double distanceZ = this.wantedZ - this.entity.getZ();
            if (target != null && target.getY() < this.entity.getY()) {
                distanceY = target.getY() - this.entity.getY();
            }
            distanceY /= Math.sqrt(distanceX * distanceX + distanceY * distanceY + distanceZ * distanceZ);
            float rotation = (float)(Mth.atan2((double)distanceZ, (double)distanceX) * 57.2957763671875) - 90.0f;
            this.entity.setYRot(this.rotlerp(this.entity.getYRot(), rotation, 90.0f));
            this.entity.yBodyRot = this.entity.getYRot();
            float moveSpeed = (float)(this.speedModifier * this.entity.getAttributeValue(Attributes.MOVEMENT_SPEED));
            float lerpedSpeed = Mth.lerp((float)0.125f, (float)this.entity.getSpeed(), (float)moveSpeed);
            this.entity.setSpeed(lerpedSpeed);
            this.entity.setDeltaMovement(this.entity.getDeltaMovement().add((double)lerpedSpeed * distanceX * 0.01, (double)lerpedSpeed * distanceY * 0.1, (double)lerpedSpeed * distanceZ * 0.01));
        } else {
            this.entity.setDeltaMovement(this.entity.getDeltaMovement().add(0.0, -0.008, 0.0));
            if (this.operation == MoveControl.Operation.WAIT) {
                this.entity.setSpeed(0.0f);
            }
        }
    }
}

