/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.ai.movehelper;

import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.NeoForgeMod;

public class SmoothSwimmingMoveControlFixed
extends MoveControl {
    protected final int maxTurnX;
    protected final int maxTurnY;
    protected final float waterSpeedMod;
    protected final float landSpeedMod;
    protected final boolean hasGravity;

    public SmoothSwimmingMoveControlFixed(Mob mob, int maxTurnX, int maxTurnY, float waterSpeedMod, float landSpeedMod, boolean hasGravity) {
        super(mob);
        this.maxTurnX = maxTurnX;
        this.maxTurnY = maxTurnY;
        this.waterSpeedMod = waterSpeedMod;
        this.landSpeedMod = landSpeedMod;
        this.hasGravity = hasGravity;
    }

    public void tick() {
        if (this.hasGravity && this.mob.isInWater()) {
            this.mob.setDeltaMovement(this.mob.getDeltaMovement().add(0.0, 0.005, 0.0));
        }
        if (this.operation == MoveControl.Operation.MOVE_TO && !this.mob.getNavigation().isDone()) {
            Vec3 distance = new Vec3(this.wantedX, this.wantedY, this.wantedZ).subtract(this.mob.position());
            if (distance.lengthSqr() < (double)2.5E-7f) {
                this.mob.setZza(0.0f);
                return;
            }
            float attemptedRot = (float)(Mth.atan2((double)distance.z, (double)distance.x) * 57.2957763671875) - 90.0f;
            float speed = (float)(this.speedModifier * this.mob.getAttributeValue(NeoForgeMod.SWIM_SPEED));
            this.mob.setYRot(this.rotlerp(this.mob.getYRot(), attemptedRot, this.maxTurnY));
            this.mob.yBodyRot = this.mob.getYRot();
            this.mob.yHeadRot = this.mob.getYRot();
            if (!this.mob.isInWater()) {
                this.mob.setSpeed(speed * this.landSpeedMod * SmoothSwimmingMoveControlFixed.getTurningSpeedFactor(Math.abs(Mth.wrapDegrees((float)(this.mob.getYRot() - attemptedRot)))));
                return;
            }
            double lateralDist = distance.horizontalDistance();
            this.mob.setSpeed(speed * this.waterSpeedMod);
            if (Math.abs(distance.y) > (double)5.0E-5f || Math.abs(lateralDist) > (double)5.0E-5f) {
                float rotX = -((float)(Mth.atan2((double)distance.y, (double)lateralDist) * 57.2957763671875));
                this.mob.setXRot(this.rotlerp(this.mob.getXRot(), Mth.clamp((float)Mth.wrapDegrees((float)rotX), (float)(-this.maxTurnX), (float)this.maxTurnX), 50.0f));
            }
            float f6 = Mth.cos((float)(this.mob.getXRot() * ((float)Math.PI / 180)));
            float f4 = Mth.sin((float)(this.mob.getXRot() * ((float)Math.PI / 180)));
            this.mob.zza = f6 * speed;
            this.mob.yya = -f4 * speed;
            return;
        }
        this.mob.setSpeed(0.0f);
        this.mob.setXxa(0.0f);
        this.mob.setYya(0.0f);
        this.mob.setZza(0.0f);
    }

    protected static float getTurningSpeedFactor(float rot) {
        return 1.0f - Mth.clamp((float)((rot - 10.0f) / 50.0f), (float)0.0f, (float)1.0f);
    }
}

