/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.ai.movehelper;

import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;

public class RoamingSwimmingMovementController
extends MoveControl {
    private final PathfinderMob entity;

    public RoamingSwimmingMovementController(PathfinderMob entity) {
        super((Mob)entity);
        this.entity = entity;
    }

    public void tick() {
        if (this.entity.isEyeInFluid(FluidTags.WATER)) {
            this.entity.setDeltaMovement(this.entity.getDeltaMovement().add(0.0, -1.0E-4, 0.0));
        }
        if (this.operation == MoveControl.Operation.MOVE_TO && !this.entity.getNavigation().isDone()) {
            float moveSpeed = (float)(this.speedModifier * this.entity.getAttributeValue(Attributes.MOVEMENT_SPEED)) * 2.0f;
            double distanceX = this.wantedX - this.entity.getX();
            double distanceY = this.wantedY - this.entity.getY();
            double distanceZ = this.wantedZ - this.entity.getZ();
            distanceY /= Math.sqrt(distanceX * distanceX + distanceY * distanceY + distanceZ * distanceZ);
            this.entity.setSpeed(Mth.lerp((float)0.2f, (float)this.entity.getSpeed(), (float)moveSpeed));
            this.entity.setDeltaMovement(this.entity.getDeltaMovement().add((double)moveSpeed * distanceX * 0.005, (double)moveSpeed * distanceY * 0.1, (double)moveSpeed * distanceZ * 0.005));
            if (distanceX != 0.0 || distanceZ != 0.0) {
                float targetAngle = (float)(Mth.atan2((double)distanceZ, (double)distanceX) * 57.2957763671875) - 90.0f;
                this.entity.setYRot(this.rotlerp(this.entity.getYRot(), targetAngle, 90.0f));
                this.entity.yBodyRot = this.entity.getYRot();
            }
        } else {
            this.entity.setSpeed(0.0f);
        }
    }
}

