/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.ai.movehelper;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidType;
import net.tslat.smartbrainlib.api.core.navigation.SmoothGroundNavigation;

public class MultiFluidSmoothGroundNavigation
extends SmoothGroundNavigation {
    public MultiFluidSmoothGroundNavigation(Mob mob, Level level) {
        super(mob, level);
    }

    protected boolean canUpdatePath() {
        return this.mob.onGround() || this.mob.isInFluidType((fluidType, height) -> this.canSwimInFluid((FluidType)fluidType), true) || this.mob.isPassenger();
    }

    public int getSurfaceY() {
        if (this.mob.isInFluidType((fluidType, height) -> this.canSwimInFluid((FluidType)fluidType), true) && this.canFloat()) {
            int basePos = this.mob.getBlockY();
            BlockPos.MutableBlockPos pos = BlockPos.containing((double)this.mob.getX(), (double)basePos, (double)this.mob.getZ()).mutable();
            BlockState state = this.level.getBlockState((BlockPos)pos);
            while (this.canSwimInFluid(state.getFluidState().getFluidType())) {
                state = this.level.getBlockState((BlockPos)pos.move(Direction.UP));
                if (pos.getY() - basePos <= 16) continue;
                return basePos;
            }
            return pos.getY();
        }
        return Mth.floor((double)(this.mob.getY() + 0.5));
    }

    protected boolean canSwimInFluid(FluidType fluidType) {
        return fluidType.canSwim((Entity)this.mob);
    }
}

