/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.block.generation.plants;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.CaveVines;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class StackableCappedPlantBlock
extends Block
implements BonemealableBlock {
    public static final BooleanProperty IS_CAP = BooleanProperty.create((String)"is_cap");
    protected final Direction growthDirection;

    public StackableCappedPlantBlock(BlockBehaviour.Properties properties, Direction growDirection) {
        super(properties);
        this.growthDirection = growDirection;
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)IS_CAP, (Comparable)Boolean.valueOf(true)));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level level = context.getLevel();
        BlockState attachState = level.getBlockState(context.getClickedPos().relative(this.growthDirection));
        return !this.isHeadBlock(attachState) && !this.isStemBlock(attachState) ? this.getStateForPlacement(level) : this.getStemBlock();
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos attachPos = pos.relative(this.growthDirection.getOpposite());
        BlockState attachBlock = level.getBlockState(attachPos);
        if (!this.canSurviveOn(attachBlock)) {
            return false;
        }
        return this.isHeadBlock(attachBlock) || this.isStemBlock(attachBlock) || attachBlock.isFaceSturdy((BlockGetter)level, pos, this.growthDirection);
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!state.canSurvive((LevelReader)level, pos)) {
            level.destroyBlock(pos, true);
            return;
        }
        if (!this.isHeadBlock(state) && level.getBlockState(pos.relative(this.growthDirection)).isAir()) {
            level.setBlockAndUpdate(pos, this.getHeadBlock());
        }
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return CaveVines.SHAPE;
    }

    public BlockState updateShape(BlockState state, Direction directionToNeighbour, BlockState neighbourState, LevelAccessor level, BlockPos pos, BlockPos neighbourPos) {
        if (directionToNeighbour == this.growthDirection.getOpposite() && !state.canSurvive((LevelReader)level, pos)) {
            level.scheduleTick(pos, (Block)this, 1);
        }
        if (directionToNeighbour != this.growthDirection || !neighbourState.is((Block)this) && !this.isStemBlock(neighbourState)) {
            return state;
        }
        return this.getStemBlock();
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        BlockState checkState;
        while ((checkState = level.getBlockState(pos = pos.relative(this.growthDirection))).is((Block)this)) {
        }
        return pos.getY() > level.getMinBuildHeight() && checkState.isAir();
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        while (level.getBlockState(pos = pos.relative(this.growthDirection)).is((Block)this)) {
        }
        level.setBlockAndUpdate(pos, this.getHeadBlock());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{IS_CAP});
    }

    public boolean canSurviveOn(BlockState state) {
        return true;
    }

    protected BlockState getStateForPlacement(Level level) {
        return this.defaultBlockState();
    }

    public boolean isHeadBlock(BlockState state) {
        return state.getBlock() == this && (Boolean)state.getValue((Property)IS_CAP) != false;
    }

    public boolean isStemBlock(BlockState state) {
        return state.getBlock() == this && (Boolean)state.getValue((Property)IS_CAP) == false;
    }

    protected BlockState getHeadBlock() {
        return (BlockState)this.defaultBlockState().setValue((Property)IS_CAP, (Comparable)Boolean.valueOf(true));
    }

    protected BlockState getStemBlock() {
        return (BlockState)this.defaultBlockState().setValue((Property)IS_CAP, (Comparable)Boolean.valueOf(false));
    }
}

