/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.block.generation.plants;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.TallGrassBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class GrowablePlantBlock
extends TallGrassBlock {
    public GrowablePlantBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    abstract int getGrowHeight(ServerLevel var1, RandomSource var2, BlockPos var3, BlockState var4);

    abstract void growPlant(ServerLevel var1, RandomSource var2, BlockPos var3, BlockState var4);

    abstract BlockState getGrownPlantForHeight(ServerLevel var1, RandomSource var2, BlockPos var3, BlockState var4, int var5);

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        if (this.getGrownPlantForHeight(level, random, pos, state, 0).canSurvive((LevelReader)level, pos)) {
            int height = this.getGrowHeight(level, random, pos, state);
            BlockPos.MutableBlockPos checkPos = pos.mutable();
            for (int i = 0; i < height - 1; ++i) {
                if (level.isEmptyBlock((BlockPos)checkPos.setY(checkPos.getY() + 1))) continue;
                return;
            }
            this.growPlant(level, random, pos, state);
        }
    }

    protected final BlockState mergeWaterlogging(Level level, BlockState state, BlockPos pos) {
        return state.hasProperty((Property)BlockStateProperties.WATERLOGGED) ? (BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(level.isWaterAt(pos))) : state;
    }
}

