/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.block.generation.plants;

import com.mojang.serialization.MapCodec;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GenericPlantBlock
extends BushBlock {
    private final VoxelShape shape;
    private final Predicate<BlockState> validSurface;

    public GenericPlantBlock(BlockBehaviour.Properties properties, Predicate<BlockState> validSurface, float width, float height) {
        super(properties);
        float sidePadding = (16.0f - width) / 2.0f;
        this.shape = Block.box((double)sidePadding, (double)0.0, (double)sidePadding, (double)(16.0f - sidePadding), (double)height, (double)(16.0f - sidePadding));
        this.validSurface = validSurface;
    }

    protected MapCodec<? extends BushBlock> codec() {
        return null;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.shape;
    }

    protected boolean mayPlaceOn(BlockState state, BlockGetter level, BlockPos pos) {
        return this.validSurface.test(state);
    }
}

