/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.block.generation.log;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.tslat.aoa3.content.block.generation.log.LogBlock;
import org.jetbrains.annotations.Nullable;

public class VoxLog
extends LogBlock {
    private static final VoxelShape X_SHAPE = Shapes.join((VoxelShape)Shapes.block(), (VoxelShape)VoxLog.box((double)0.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0), (BooleanOp)BooleanOp.NOT_SAME);
    private static final VoxelShape Z_SHAPE = Shapes.join((VoxelShape)Shapes.block(), (VoxelShape)VoxLog.box((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)16.0), (BooleanOp)BooleanOp.NOT_SAME);
    private static final VoxelShape Y_SHAPE = Shapes.join((VoxelShape)Shapes.block(), (VoxelShape)VoxLog.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), (BooleanOp)BooleanOp.NOT_SAME);

    public VoxLog(BlockBehaviour.Properties properties) {
        super(properties, null);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return switch ((Direction.Axis)state.getValue((Property)AXIS)) {
            case Direction.Axis.X -> X_SHAPE;
            case Direction.Axis.Y -> Y_SHAPE;
            default -> Z_SHAPE;
        };
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER))).setValue((Property)AXIS, (Comparable)context.getClickedFace().getAxis());
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            world.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        return super.updateShape(state, facing, facingState, world, currentPos, facingPos);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.WATERLOGGED, AXIS});
    }
}

