/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.block.functional.utility;

import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.tslat.aoa3.common.registration.worldgen.AoADimensions;
import net.tslat.aoa3.content.block.blockentity.BossAltarBlockEntity;
import net.tslat.aoa3.content.item.misc.summoning.BossTokenItem;
import net.tslat.aoa3.content.world.nowhere.NowhereBossArena;
import net.tslat.aoa3.scheduling.AoAScheduler;
import net.tslat.aoa3.util.BlockUtil;
import net.tslat.aoa3.util.InteractionResults;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.WorldUtil;
import net.tslat.smartbrainlib.util.EntityRetrievalUtil;
import org.jetbrains.annotations.Nullable;

public class BossAltar
extends Block
implements EntityBlock {
    private static final VoxelShape SHAPE = BlockUtil.pixelBasedCube(4, 0, 4, 12, 12, 12);

    public BossAltar(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BossAltarBlockEntity(pos, state);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        EntityType<? extends Entity> entityType;
        if (!WorldUtil.isWorld(level, AoADimensions.NOWHERE)) {
            return InteractionResults.BlockUseItemOn.noActionTaken();
        }
        if (level.getDifficulty() == Difficulty.PEACEFUL) {
            if (!level.isClientSide && hand == InteractionHand.MAIN_HAND) {
                player.sendSystemMessage((Component)LocaleUtil.getLocaleMessage(LocaleUtil.createFeedbackLocaleKey("nowhere.boss.difficulty"), ChatFormatting.RED, new Component[0]));
            }
            return InteractionResults.BlockUseItemOn.noActionTaken();
        }
        ItemStack heldItem = player.getItemInHand(hand);
        BossTokenItem bossItem = this.getEntityTypeFromStack(heldItem);
        if (bossItem == null || (entityType = bossItem.getEntityType(heldItem)) == null) {
            if (hand == InteractionHand.OFF_HAND && !level.isClientSide()) {
                player.sendSystemMessage((Component)LocaleUtil.getLocaleMessage(LocaleUtil.createFeedbackLocaleKey("nowhere.boss.badItem"), ChatFormatting.RED, new Component[0]));
            }
            return InteractionResults.BlockUseItemOn.noActionTaken();
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            AABB teleportBounds = new AABB((double)(pos.getX() - 3), (double)pos.getY(), (double)(pos.getZ() - 3), (double)(pos.getX() + 4), (double)(pos.getY() + 3), (double)(pos.getZ() + 3));
            List players = EntityRetrievalUtil.getPlayers((Level)level, (AABB)teleportBounds, LivingEntity::isAlive);
            if (players.isEmpty()) {
                player.sendSystemMessage((Component)LocaleUtil.getLocaleMessage(LocaleUtil.createFeedbackLocaleKey("nowhere.boss.tooFar"), ChatFormatting.RED, new Component[0]));
                return InteractionResults.BlockUseItemOn.noActionTaken();
            }
            NowhereBossArena arena = NowhereBossArena.getFreeArena(serverLevel);
            if (arena == null) {
                player.sendSystemMessage((Component)LocaleUtil.getLocaleMessage(LocaleUtil.createFeedbackLocaleKey("nowhere.boss.full"), ChatFormatting.RED, new Component[0]));
            } else {
                BlockEntity blockEntity = level.getBlockEntity(pos);
                if (blockEntity instanceof BossAltarBlockEntity) {
                    BossAltarBlockEntity bossAltar = (BossAltarBlockEntity)blockEntity;
                    if (bossAltar.getCurrentEntity() != null) {
                        player.sendSystemMessage((Component)LocaleUtil.getLocaleMessage(LocaleUtil.createFeedbackLocaleKey("nowhere.boss.inUse"), ChatFormatting.RED, new Component[0]));
                        return InteractionResults.BlockUseItemOn.noActionTaken();
                    }
                    bossAltar.updateEntity(entityType);
                    AoAScheduler.scheduleSyncronisedTask(() -> bossAltar.updateEntity(null), 95);
                }
                arena.placePlayersAndBoss(serverLevel, players, pl -> pl.level() == level && pl.isAlive() && teleportBounds.contains(pl.position()), heldItem, entityType, bossItem::spawnBoss);
            }
        }
        return InteractionResults.BlockUseItemOn.succeedAndSwingArmBothSides(level.isClientSide);
    }

    @Nullable
    private BossTokenItem getEntityTypeFromStack(ItemStack stack) {
        BossTokenItem bossTokenItem;
        Item item = stack.getItem();
        Objects.requireNonNull(item);
        Item item2 = item;
        int n = 0;
        block4: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BossTokenItem.class, BlockItem.class}, (Object)item2, n)) {
                case 0: {
                    BossTokenItem bossToken;
                    bossTokenItem = bossToken = (BossTokenItem)item2;
                    break block4;
                }
                case 1: {
                    BlockItem blockItem = (BlockItem)item2;
                    Block block = blockItem.getBlock();
                    if (!(block instanceof BossTokenItem)) {
                        n = 2;
                        continue block4;
                    }
                    BossTokenItem token = (BossTokenItem)block;
                    bossTokenItem = token;
                    break block4;
                }
                default: {
                    bossTokenItem = null;
                    break block4;
                }
            }
            break;
        }
        return bossTokenItem;
    }
}

