/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.block.functional.plant;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.util.TriState;
import net.tslat.aoa3.content.block.functional.plant.AoACropBlock;

public abstract class HangingCropBlock
extends AoACropBlock {
    public HangingCropBlock(BlockBehaviour.Properties properties, Supplier<Item> seedItem) {
        super(properties, seedItem);
    }

    protected boolean mayPlaceOn(BlockState state, BlockGetter world, BlockPos pos) {
        return state.is(BlockTags.LEAVES);
    }

    @Override
    public abstract VoxelShape getShape(BlockState var1, BlockGetter var2, BlockPos var3, CollisionContext var4);

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        float growthMod;
        int age;
        if (!world.isAreaLoaded(pos, 1)) {
            return;
        }
        if (world.getRawBrightness(pos, 0) >= 9 && (age = this.getAge(state)) < this.getMaxAge() && CommonHooks.canCropGrow((Level)world, (BlockPos)pos, (BlockState)state, (random.nextInt((int)(25.0f / (growthMod = this.getGrowthMod(state, (BlockGetter)world, pos))) + 1) == 0 ? 1 : 0) != 0)) {
            world.setBlock(pos, this.getStateForAge(age + 1), 2);
            CommonHooks.fireCropGrowPost((Level)world, (BlockPos)pos, (BlockState)state);
        }
    }

    public float getGrowthMod(BlockState state, BlockGetter level, BlockPos pos) {
        boolean longitudeAdjacent;
        float modifier = 1.0f;
        BlockPos.MutableBlockPos testPos = new BlockPos.MutableBlockPos();
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                float adjacentMod = 0.0f;
                BlockState blockstate = level.getBlockState((BlockPos)testPos.set(pos.getX() + x, pos.getY() + 1, pos.getZ() + z));
                if (blockstate.canSustainPlant(level, (BlockPos)testPos, Direction.DOWN, state) != TriState.FALSE) {
                    adjacentMod = 1.0f;
                    if (blockstate.isFertile(level, (BlockPos)testPos.move(Direction.DOWN))) {
                        adjacentMod = 3.0f;
                    }
                }
                if (x != 0 || z != 0) {
                    adjacentMod /= 4.0f;
                }
                modifier += adjacentMod;
            }
        }
        BlockPos eastPos = pos.west();
        BlockPos westPos = pos.east();
        Block block = state.getBlock();
        boolean latitudeAdjacent = block == level.getBlockState(eastPos).getBlock() || block == level.getBlockState(westPos).getBlock();
        boolean bl = longitudeAdjacent = block == level.getBlockState(pos.north()).getBlock() || block == level.getBlockState(pos.south()).getBlock();
        if (latitudeAdjacent && longitudeAdjacent) {
            modifier /= 2.0f;
        } else if (block == level.getBlockState(eastPos.north()).getBlock() || block == level.getBlockState(westPos.north()).getBlock() || block == level.getBlockState(westPos.south()).getBlock() || block == level.getBlockState(eastPos.south()).getBlock()) {
            modifier /= 2.0f;
        }
        return modifier;
    }

    public boolean canSurvive(BlockState pState, LevelReader world, BlockPos pos) {
        BlockPos leafPos = pos.above();
        return this.mayPlaceOn(world.getBlockState(leafPos), (BlockGetter)world, leafPos);
    }
}

