/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.block.functional.misc;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.tslat.aoa3.common.registration.item.AoAItems;

public class LivingGrowth
extends Block {
    public static final IntegerProperty GROWTH_STAGE = BlockStateProperties.AGE_5;
    private static final VoxelShape[] AGE_SHAPES = new VoxelShape[]{Shapes.create((AABB)new AABB(0.0625, 0.0, 0.0625, 0.9375, 0.0625, 0.9375)), Shapes.create((AABB)new AABB(0.1875, 0.0, 0.1875, 0.8125, 0.5, 0.8125)), Shapes.create((AABB)new AABB(0.0625, 0.0, 0.0625, 0.9375, 0.875, 0.9375)), Shapes.create((AABB)new AABB(0.0625, 0.0, 0.0625, 0.9375, 1.4375, 0.9375)), Shapes.create((AABB)new AABB(0.001, 0.0, 0.001, 0.99, 1.625, 0.99)), Shapes.create((AABB)new AABB(0.001, 0.0, 0.001, 0.99, 1.625, 0.99))};

    public LivingGrowth(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)GROWTH_STAGE, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return AGE_SHAPES[(Integer)state.getValue((Property)GROWTH_STAGE)];
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource rand) {
        super.tick(state, world, pos, rand);
        int currentAge = (Integer)state.getValue((Property)GROWTH_STAGE);
        if (currentAge < 6) {
            if (world.getDifficulty() == Difficulty.PEACEFUL) {
                world.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                ItemEntity itemEntity = new ItemEntity(EntityType.ITEM, (Level)world);
                itemEntity.setItem(new ItemStack((ItemLike)AoAItems.PETALS.get()));
                itemEntity.setPos((double)pos.getX(), (double)pos.getY() + 0.5, (double)pos.getZ());
                world.addFreshEntity((Entity)itemEntity);
            } else if (currentAge != 5) {
                world.setBlockAndUpdate(pos, (BlockState)this.defaultBlockState().setValue((Property)GROWTH_STAGE, (Comparable)Integer.valueOf(currentAge + 1)));
                world.scheduleTick(pos, state.getBlock(), 40);
            }
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{GROWTH_STAGE});
    }
}

