/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.block.functional.misc;

import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.tslat.aoa3.common.registration.entity.AoAMonsters;
import net.tslat.aoa3.common.registration.worldgen.AoAWorldgenKeys;
import net.tslat.aoa3.content.entity.monster.precasia.AttercopusEntity;
import net.tslat.aoa3.library.object.AllDirections;
import net.tslat.aoa3.util.BlockUtil;
import net.tslat.aoa3.util.EntitySpawningUtil;
import net.tslat.smartbrainlib.util.EntityRetrievalUtil;
import org.jetbrains.annotations.Nullable;

public class CocoonBlock
extends Block {
    public static final BooleanProperty WEBBED = BooleanProperty.create((String)"webbed");
    private static final VoxelShape WEBBED_SHAPE = BlockUtil.pixelBasedCube(3, 1, 3, 13, 15, 13);
    private static final VoxelShape SHAPE = BlockUtil.pixelBasedCube(3, 0, 3, 13, 14, 13);

    public CocoonBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)WEBBED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean isRandomlyTicking(BlockState state) {
        return (Boolean)state.getValue((Property)WEBBED) != false && super.isRandomlyTicking(state);
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!CocoonBlock.shouldTrySpawn(level, pos, state)) {
            return;
        }
        if (CocoonBlock.trySpawn(level, pos, random) && random.nextBoolean()) {
            level.scheduleTick(pos, (Block)this, random.nextIntBetweenInclusive(60, 700));
        }
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!CocoonBlock.shouldTrySpawn(level, pos, state)) {
            return;
        }
        if (CocoonBlock.trySpawn(level, pos, random) && random.nextInt(5) == 0) {
            level.scheduleTick(pos, (Block)this, random.nextIntBetweenInclusive(60, 200));
        }
    }

    private static boolean trySpawn(ServerLevel level, BlockPos pos, RandomSource random) {
        List directions = Util.shuffledCopy((Object[])AllDirections.values(), (RandomSource)random);
        for (AllDirections direction : directions) {
            BlockPos spawnPos = pos.offset(direction.angle());
            if (level.getBlockState(spawnPos).isSuffocating((BlockGetter)level, spawnPos) || !Monster.isDarkEnoughToSpawn((ServerLevelAccessor)level, (BlockPos)pos, (RandomSource)random)) continue;
            EntitySpawningUtil.spawnEntity(level, (EntityType)AoAMonsters.ATTERCOPUS.get(), Vec3.atCenterOf((Vec3i)spawnPos), MobSpawnType.SPAWNER);
            return true;
        }
        return false;
    }

    private static boolean shouldTrySpawn(ServerLevel level, BlockPos pos, BlockState state) {
        if (!((Boolean)state.getValue((Property)WEBBED)).booleanValue()) {
            return false;
        }
        AABB bounds = new AABB(pos);
        if (EntityRetrievalUtil.getPlayers((Level)level, (AABB)bounds.inflate(30.0)).isEmpty()) {
            return false;
        }
        if (((Registry)level.registryAccess().registry(Registries.STRUCTURE).get()).getOptional(AoAWorldgenKeys.Structures.ATTERCOPUS_NEST).map(nest -> level.structureManager().getStructureWithPieceAt(pos, nest) == StructureStart.INVALID_START).orElse(true).booleanValue()) {
            return false;
        }
        return EntityRetrievalUtil.getEntities((Level)level, (AABB)bounds.inflate(10.0), entity -> entity instanceof AttercopusEntity).size() <= 20;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        if (context.getLevel().getBlockState(context.getClickedPos()).is(Blocks.COBWEB)) {
            return (BlockState)super.getStateForPlacement(context).setValue((Property)WEBBED, (Comparable)Boolean.valueOf(true));
        }
        return super.getStateForPlacement(context);
    }

    public VoxelShape getShape(BlockState state, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return (Boolean)state.getValue((Property)WEBBED) != false ? WEBBED_SHAPE : SHAPE;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WEBBED});
    }
}

