/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.block.functional.light;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.common.registration.worldgen.AoADimensions;
import net.tslat.aoa3.util.WorldUtil;

public class VoxLight
extends Block {
    public VoxLight(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.getItem() == AoAItems.ACTIVE_RUNE_STONE.get() && WorldUtil.isWorld(level, AoADimensions.MYSTERIUM)) {
            List itemsList;
            if (!level.isClientSide && (itemsList = level.getEntitiesOfClass(ItemEntity.class, new AABB((double)pos.getX(), (double)(pos.getY() + 1), (double)pos.getZ(), (double)(pos.getX() + 1), (double)(pos.getY() + 2), (double)(pos.getZ() + 1)))).size() > 1) {
                ItemEntity realmstone = null;
                ItemEntity runicEnergy = null;
                for (ItemEntity entity : itemsList) {
                    Item item = entity.getItem().getItem();
                    if (item == AoAItems.BLANK_REALMSTONE.get()) {
                        realmstone = entity;
                    } else if (item == AoAItems.RUNIC_ENERGY.get()) {
                        runicEnergy = entity;
                    }
                    if (realmstone == null || runicEnergy == null) continue;
                    player.getItemInHand(hand).shrink(1);
                    realmstone.setItem(new ItemStack((ItemLike)AoAItems.RUNANDOR_REALMSTONE.get()));
                    runicEnergy.discard();
                }
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }
}

