/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.block.functional.altar;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.Tags;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.common.registration.worldgen.AoADimensions;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.WorldUtil;
import net.tslat.smartbrainlib.util.EntityRetrievalUtil;

public class GuardianAltar
extends Block {
    public GuardianAltar(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!WorldUtil.isWorld(level, AoADimensions.HAVEN)) {
            return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
        }
        if (stack.getItem() == AoAItems.VOLIANT_HEART.get()) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                if (level.getSignal(pos.relative(direction), direction) != 0) continue;
                return ItemInteractionResult.FAIL;
            }
            if (!EntityRetrievalUtil.getEntities((Level)level, (AABB)AABB.ofSize((Vec3)Vec3.atCenterOf((Vec3i)pos), (double)30.0, (double)30.0, (double)30.0), entity -> entity.getType().is(Tags.EntityTypes.BOSSES)).isEmpty()) {
                return ItemInteractionResult.FAIL;
            }
            if (!level.isClientSide) {
                if (!player.getAbilities().instabuild) {
                    stack.shrink(1);
                }
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    BlockPos checkPos = pos.relative(direction);
                    if (level.getBlockState(checkPos).getBlock() != Blocks.REDSTONE_WIRE) continue;
                    this.breakWire(level, checkPos, 0);
                }
                for (Player pl : EntityRetrievalUtil.getPlayers((Level)level, (AABB)AABB.ofSize((Vec3)Vec3.atCenterOf((Vec3i)pos), (double)50.0, (double)50.0, (double)50.0))) {
                    pl.sendSystemMessage((Component)LocaleUtil.getLocaleMessage("message.mob.four_guardians.spawn"));
                }
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    private int breakWire(Level world, BlockPos curPos, int currentCount) {
        world.addFreshEntity((Entity)new ItemEntity(world, (double)curPos.getX(), (double)curPos.getY(), (double)curPos.getZ(), new ItemStack((ItemLike)Blocks.REDSTONE_WIRE)));
        world.setBlockAndUpdate(curPos, Blocks.AIR.defaultBlockState());
        ++currentCount;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos newPos = curPos.relative(direction);
            if (world.getBlockState(newPos).getBlock() == Blocks.REDSTONE_WIRE) {
                currentCount = this.breakWire(world, newPos, currentCount);
            }
            if (currentCount < 20) continue;
            return currentCount;
        }
        return currentCount;
    }
}

