/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.block.decoration.misc;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class SteelPlateBlock
extends Block {
    private static final NonNullList<VoxelShape> SHAPE_MAP = SteelPlateBlock.generateShapeMap();

    public SteelPlateBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.UP, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.DOWN, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext useContext) {
        if (useContext.getItemInHand().getItem() != this.asItem()) {
            return false;
        }
        if (state == this.defaultBlockState()) {
            return false;
        }
        return (Boolean)state.getValue((Property)PipeBlock.PROPERTY_BY_DIRECTION.get(useContext.replacingClickedOnBlock() ? useContext.getClickedFace() : useContext.getClickedFace().getOpposite())) == false;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState replacingState = context.getLevel().getBlockState(context.getClickedPos());
        if (replacingState.getBlock() == this) {
            if (!context.replacingClickedOnBlock()) {
                return (BlockState)replacingState.setValue((Property)PipeBlock.PROPERTY_BY_DIRECTION.get(context.getClickedFace().getOpposite()), (Comparable)Boolean.valueOf(true));
            }
            for (Direction direction : context.getNearestLookingDirections()) {
                BooleanProperty property = (BooleanProperty)PipeBlock.PROPERTY_BY_DIRECTION.get(direction);
                if (((Boolean)replacingState.getValue((Property)property)).booleanValue()) continue;
                return (BlockState)((BlockState)replacingState.setValue((Property)property, (Comparable)Boolean.valueOf(true))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER));
            }
            return null;
        }
        if (context.getPlayer() != null && context.getPlayer().isCrouching()) {
            return this.defaultBlockState();
        }
        if (!context.replacingClickedOnBlock()) {
            return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)PipeBlock.PROPERTY_BY_DIRECTION.get(context.getClickedFace().getOpposite()), (Comparable)Boolean.valueOf(true))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER));
        }
        int n = 0;
        Direction[] directionArray = context.getNearestLookingDirections();
        int n2 = directionArray.length;
        if (n < n2) {
            Direction direction = directionArray[n];
            return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)PipeBlock.PROPERTY_BY_DIRECTION.get(direction), (Comparable)Boolean.valueOf(true))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER));
        }
        return null;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            world.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        return super.updateShape(state, facing, facingState, world, currentPos, facingPos);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.UP, BlockStateProperties.DOWN, BlockStateProperties.NORTH, BlockStateProperties.SOUTH, BlockStateProperties.EAST, BlockStateProperties.WEST, BlockStateProperties.WATERLOGGED});
    }

    public boolean useShapeForLightOcclusion(BlockState state) {
        return true;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (VoxelShape)SHAPE_MAP.get(SteelPlateBlock.stateToShapeIndex(state));
    }

    private static int stateToShapeIndex(BlockState state) {
        int lookup = 0;
        if (((Boolean)state.getValue((Property)BlockStateProperties.UP)).booleanValue()) {
            lookup |= 1;
        }
        if (((Boolean)state.getValue((Property)BlockStateProperties.DOWN)).booleanValue()) {
            lookup |= 2;
        }
        if (((Boolean)state.getValue((Property)BlockStateProperties.NORTH)).booleanValue()) {
            lookup |= 4;
        }
        if (((Boolean)state.getValue((Property)BlockStateProperties.SOUTH)).booleanValue()) {
            lookup |= 8;
        }
        if (((Boolean)state.getValue((Property)BlockStateProperties.EAST)).booleanValue()) {
            lookup |= 0x10;
        }
        if (((Boolean)state.getValue((Property)BlockStateProperties.WEST)).booleanValue()) {
            lookup |= 0x20;
        }
        return lookup;
    }

    private static NonNullList<VoxelShape> generateShapeMap() {
        Object[] shapeList = new VoxelShape[64];
        VoxelShape[] definedShapes = new VoxelShape[]{Shapes.box((double)0.0, (double)0.9375, (double)0.0, (double)1.0, (double)1.0, (double)1.0), Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.0625, (double)1.0), Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)0.0625), Shapes.box((double)0.0, (double)0.0, (double)0.9375, (double)1.0, (double)1.0, (double)1.0), Shapes.box((double)0.9375, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0), Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)0.0625, (double)1.0, (double)1.0)};
        shapeList[0] = Shapes.block();
        for (int i = 1; i < 64; ++i) {
            int shapeIndex = 0;
            VoxelShape[] shapes = new VoxelShape[Integer.bitCount(i)];
            for (int j = 0; j <= 5; ++j) {
                if ((i >> j & 1) != 1) continue;
                shapes[shapeIndex++] = definedShapes[j];
            }
            shapeList[i] = Shapes.or((VoxelShape)Shapes.empty(), (VoxelShape[])shapes);
        }
        return NonNullList.of((Object)Shapes.empty(), (Object[])shapeList);
    }
}

